/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class MetricsMap<@UnknownKeyFor K, @UnknownKeyFor T>
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Factory<K, T> factory;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<K, T> metrics = new ConcurrentHashMap<K, T>();

    public MetricsMap(@UnknownKeyFor @NonNull @Initialized Factory<K, T> factory) {
        this.factory = factory;
    }

    public T get(K key) {
        Object metric = this.metrics.get(key);
        if (metric == null) {
            metric = this.factory.createInstance(key);
            metric = MoreObjects.firstNonNull(this.metrics.putIfAbsent(key, metric), metric);
        }
        return (T)metric;
    }

    public @Nullable T tryGet(K key) {
        return (T)this.metrics.get(key);
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized Map.Entry<K, T>> entries() {
        return Iterables.unmodifiableIterable(this.metrics.entrySet());
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<T> values() {
        return Iterables.unmodifiableIterable(this.metrics.values());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof MetricsMap) {
            MetricsMap metricsMap = (MetricsMap)object;
            return Objects.equals(this.metrics, metricsMap.metrics);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.metrics.hashCode();
    }

    public static interface Factory<@UnknownKeyFor K, @UnknownKeyFor T>
    extends Serializable {
        public T createInstance(K var1);
    }
}

