/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.util.Map;
import org.apache.avro.Schema;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class AvroCoderCloudObjectTranslator
implements CloudObjectTranslator<AvroCoder> {
    private static final @UnknownKeyFor @NonNull @Initialized String TYPE_FIELD = "type";
    private static final @UnknownKeyFor @NonNull @Initialized String SCHEMA_FIELD = "schema";
    private static final @UnknownKeyFor @NonNull @Initialized String REFLECT_API_FIELD = "reflect_api";

    AvroCoderCloudObjectTranslator() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized AvroCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(AvroCoder.class);
        Structs.addString((Map<String, Object>)((Object)base), SCHEMA_FIELD, target.getSchema().toString());
        Structs.addString((Map<String, Object>)((Object)base), TYPE_FIELD, target.getType().getName());
        Structs.addBoolean((Map<String, Object>)((Object)base), REFLECT_API_FIELD, target.useReflectApi());
        return base;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AvroCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
        Schema.Parser parser = new Schema.Parser();
        String className = Structs.getString((Map<String, Object>)((Object)cloudObject), TYPE_FIELD);
        String schemaString = Structs.getString((Map<String, Object>)((Object)cloudObject), SCHEMA_FIELD);
        boolean useReflectApi = Structs.getBoolean((Map<String, Object>)((Object)cloudObject), REFLECT_API_FIELD);
        try {
            Class<?> type = Class.forName(className);
            Schema schema = parser.parse(schemaString);
            return AvroCoder.of(type, (Schema)schema, (boolean)useReflectApi);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized AvroCoder> getSupportedClass() {
        return AvroCoder.class;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
        return CloudObject.forClass(AvroCoder.class).getClassName();
    }
}

