/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.Message;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.util.JsonFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class RowCoderCloudObjectTranslator
implements CloudObjectTranslator<RowCoder> {
    private static final @UnknownKeyFor @NonNull @Initialized String SCHEMA = "schema";

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized RowCoder> getSupportedClass() {
        return RowCoder.class;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized RowCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(RowCoder.class);
        try {
            Structs.addString((Map<String, Object>)((Object)base), SCHEMA, JsonFormat.printer().print((MessageOrBuilder)SchemaTranslation.schemaToProto((Schema)target.getSchema(), (boolean)true)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return base;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RowCoder fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
        try {
            SchemaApi.Schema.Builder schemaBuilder = SchemaApi.Schema.newBuilder();
            JsonFormat.parser().merge(Structs.getString((Map<String, Object>)((Object)cloudObject), SCHEMA), (Message.Builder)schemaBuilder);
            Schema schema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)schemaBuilder.build());
            UUID uuid = schema.getUUID();
            if (schema.isEncodingPositionsOverridden() && uuid != null) {
                RowCoder.overrideEncodingPositions((UUID)uuid, (Map)schema.getEncodingPositions());
            }
            return RowCoder.of((Schema)schema);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
        return CloudObject.forClass(RowCoder.class).getClassName();
    }
}

