/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.producer.Attempt;
import com.amazonaws.services.kinesis.producer.IKinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import com.amazonaws.services.kinesis.producer.UserRecordFailedException;
import com.amazonaws.services.kinesis.producer.UserRecordResult;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Supplier;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.kinesis.AutoValue_KinesisIO_Read;
import org.apache.beam.sdk.io.kinesis.AutoValue_KinesisIO_Write;
import org.apache.beam.sdk.io.kinesis.BasicKinesisProvider;
import org.apache.beam.sdk.io.kinesis.KinesisPartitioner;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.KinesisRecordCoder;
import org.apache.beam.sdk.io.kinesis.KinesisSource;
import org.apache.beam.sdk.io.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Experimental(value=Experimental.Kind.SOURCE_SINK)
public final class KinesisIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KinesisIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_NUM_RETRIES = 6;

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized KinesisRecord> read() {
        return Read.newBuilder().setCoder((Coder<KinesisRecord>)KinesisRecordCoder.of()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> readData() {
        return Read.newBuilder(KinesisRecord::getDataAsBytes).setCoder(ByteArrayCoder.of()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_KinesisIO_Write.Builder().setRetries(6).build();
    }

    static class KinesisWriteException
    extends IOException {
        KinesisWriteException(@UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized Throwable cause) {
            super(message, cause);
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<byte[]>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized String getStreamName();

        abstract @Nullable @UnknownKeyFor @Initialized String getPartitionKey();

        abstract @Nullable @UnknownKeyFor @Initialized KinesisPartitioner getPartitioner();

        abstract @Nullable @UnknownKeyFor @Initialized Properties getProducerProperties();

        abstract @Nullable @UnknownKeyFor @Initialized AWSClientsProvider getAWSClientsProvider();

        abstract @UnknownKeyFor @NonNull @Initialized int getRetries();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Write withStreamName(@UnknownKeyFor @NonNull @Initialized String streamName) {
            return this.builder().setStreamName(streamName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withPartitionKey(@UnknownKeyFor @NonNull @Initialized String partitionKey) {
            return this.builder().setPartitionKey(partitionKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withPartitioner(@UnknownKeyFor @NonNull @Initialized KinesisPartitioner partitioner) {
            return this.builder().setPartitioner(partitioner).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProducerProperties(@UnknownKeyFor @NonNull @Initialized Properties properties) {
            return this.builder().setProducerProperties(properties).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider awsClientsProvider) {
            return this.builder().setAWSClientsProvider(awsClientsProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider awsCredentialsProvider, @UnknownKeyFor @NonNull @Initialized Regions region) {
            return this.withAWSClientsProvider(awsCredentialsProvider, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider awsCredentialsProvider, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint) {
            return this.withAWSClientsProvider(awsCredentialsProvider, region, serviceEndpoint, true);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint, true);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider awsCredentialsProvider, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint, @UnknownKeyFor @NonNull @Initialized boolean verifyCertificate) {
            return this.withAWSClientsProvider(new BasicKinesisProvider(awsCredentialsProvider, region, serviceEndpoint, verifyCertificate));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint, @UnknownKeyFor @NonNull @Initialized boolean verifyCertificate) {
            AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awsAccessKey, awsSecretKey));
            return this.withAWSClientsProvider((AWSCredentialsProvider)awsCredentialsProvider, region, serviceEndpoint, verifyCertificate);
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Write withRetries(@UnknownKeyFor @NonNull @Initialized int retries) {
            return this.builder().setRetries(retries).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> input) {
            LOG.warn("You are using a deprecated IO for Kinesis. Please migrate to module 'org.apache.beam:beam-sdks-java-io-amazon-web-services2'.");
            Preconditions.checkArgument((this.getStreamName() != null ? 1 : 0) != 0, (Object)"withStreamName() is required");
            Preconditions.checkArgument((this.getPartitionKey() != null || this.getPartitioner() != null ? 1 : 0) != 0, (Object)"withPartitionKey() or withPartitioner() is required");
            Preconditions.checkArgument((this.getPartitionKey() == null || this.getPartitioner() == null ? 1 : 0) != 0, (Object)"only one of either withPartitionKey() or withPartitioner() is possible");
            Preconditions.checkArgument((this.getAWSClientsProvider() != null ? 1 : 0) != 0, (Object)"withAWSClientsProvider() is required");
            this.createProducerConfiguration();
            input.apply((PTransform)ParDo.of((DoFn)new KinesisWriterFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private @UnknownKeyFor @NonNull @Initialized KinesisProducerConfiguration createProducerConfiguration() {
            Properties props = this.getProducerProperties();
            if (props == null) {
                props = new Properties();
            }
            return KinesisProducerConfiguration.fromProperties((Properties)props);
        }

        private static class KinesisWriterFn
        extends DoFn<byte[], Void> {
            private static final @UnknownKeyFor @NonNull @Initialized int MAX_NUM_FAILURES = 10;
            private static @UnknownKeyFor @NonNull @Initialized int producerRefCount = 0;
            private static @UnknownKeyFor @NonNull @Initialized IKinesisProducer producer;
            private final @UnknownKeyFor @NonNull @Initialized Write spec;
            private transient @UnknownKeyFor @NonNull @Initialized KinesisPartitioner partitioner;
            private transient @UnknownKeyFor @NonNull @Initialized LinkedBlockingDeque<@UnknownKeyFor @NonNull @Initialized KinesisWriteException> failures;
            private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @NonNull @Initialized UserRecordResult>> putFutures;

            KinesisWriterFn(@UnknownKeyFor @NonNull @Initialized Write spec) {
                this.spec = spec;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setupSharedProducer() {
                Class<KinesisWriterFn> clazz = KinesisWriterFn.class;
                synchronized (KinesisWriterFn.class) {
                    if (producer == null) {
                        producer = this.spec.getAWSClientsProvider().createKinesisProducer(this.spec.createProducerConfiguration());
                        producerRefCount = 0;
                    }
                    ++producerRefCount;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void teardownSharedProducer() {
                IKinesisProducer obsolete = null;
                Class<KinesisWriterFn> clazz = KinesisWriterFn.class;
                synchronized (KinesisWriterFn.class) {
                    if (--producerRefCount == 0) {
                        obsolete = producer;
                        producer = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    if (obsolete != null) {
                        obsolete.flushSync();
                        obsolete.destroy();
                    }
                    return;
                }
            }

            @DoFn.Setup
            public void setup() {
                this.setupSharedProducer();
                if (this.spec.getPartitioner() != null) {
                    this.partitioner = this.spec.getPartitioner();
                }
            }

            @DoFn.StartBundle
            public void startBundle() {
                this.putFutures = Collections.synchronizedList(new ArrayList());
                this.failures = new LinkedBlockingDeque(10);
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                ByteBuffer data = ByteBuffer.wrap((byte[])c.element());
                String partitionKey = this.spec.getPartitionKey();
                String explicitHashKey = null;
                if (this.partitioner != null) {
                    partitionKey = this.partitioner.getPartitionKey((byte[])c.element());
                    explicitHashKey = this.partitioner.getExplicitHashKey((byte[])c.element());
                }
                ListenableFuture f = producer.addUserRecord(this.spec.getStreamName(), partitionKey, explicitHashKey, data);
                this.putFutures.add((Future<UserRecordResult>)f);
            }

            @DoFn.FinishBundle
            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.flushBundle();
            }

            private void flushBundle() throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized IOException {
                UserRecordResult result;
                int numFailedRecords;
                int retries = this.spec.getRetries();
                int retryTimeout = 1000;
                String message = "";
                do {
                    numFailedRecords = 0;
                    producer.flush();
                    for (Future<UserRecordResult> f : this.putFutures) {
                        result = f.get();
                        if (result.isSuccessful()) continue;
                        ++numFailedRecords;
                    }
                    Thread.sleep(retryTimeout);
                    retryTimeout *= 2;
                } while (numFailedRecords > 0 && retries-- > 0);
                if (numFailedRecords > 0) {
                    for (Future<UserRecordResult> f : this.putFutures) {
                        result = f.get();
                        if (result.isSuccessful()) continue;
                        this.failures.offer(new KinesisWriteException("Put record was not successful.", (Throwable)new UserRecordFailedException(result)));
                    }
                    LOG.error("After [{}] retries, number of failed records [{}] is still greater than 0", (Object)this.spec.getRetries(), (Object)numFailedRecords);
                }
                this.checkForFailures(message);
            }

            private void checkForFailures(@UnknownKeyFor @NonNull @Initialized String message) throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (this.failures.isEmpty()) {
                    return;
                }
                StringBuilder logEntry = new StringBuilder();
                logEntry.append(message).append(System.lineSeparator());
                int i = 0;
                while (!this.failures.isEmpty()) {
                    ++i;
                    KinesisWriteException exc = this.failures.remove();
                    logEntry.append(System.lineSeparator()).append(exc.getMessage());
                    Throwable cause = exc.getCause();
                    if (cause == null) continue;
                    logEntry.append(": ").append(cause.getMessage());
                    if (!(cause instanceof UserRecordFailedException)) continue;
                    List attempts = ((UserRecordFailedException)cause).getResult().getAttempts();
                    for (Attempt attempt : attempts) {
                        if (attempt.getErrorMessage() == null) continue;
                        logEntry.append(System.lineSeparator()).append(attempt.getErrorMessage());
                    }
                }
                String errorMessage = String.format("Some errors occurred writing to Kinesis. First %d errors: %s", i, logEntry.toString());
                throw new IOException(errorMessage);
            }

            @DoFn.Teardown
            public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.teardownSharedProducer();
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setStreamName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitionKey(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitioner(@UnknownKeyFor @NonNull @Initialized KinesisPartitioner var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setProducerProperties(@UnknownKeyFor @NonNull @Initialized Properties var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRetries(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized String getStreamName();

        abstract @Nullable @UnknownKeyFor @Initialized StartingPoint getInitialPosition();

        abstract @Nullable @UnknownKeyFor @Initialized AWSClientsProvider getAWSClientsProvider();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumRecords();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getMaxReadTime();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getUpToDateThreshold();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getRequestRecordsLimit();

        abstract @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory getWatermarkPolicyFactory();

        abstract @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory getRateLimitPolicyFactory();

        abstract @UnknownKeyFor @NonNull @Initialized Integer getMaxCapacityPerShard();

        abstract @UnknownKeyFor @NonNull @Initialized Coder<T> getCoder();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized KinesisRecord, T> getParseFn();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> newBuilder(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized KinesisRecord, T> parseFn) {
            return new AutoValue_KinesisIO_Read.Builder<T>().setParseFn(parseFn).setMaxNumRecords(Long.MAX_VALUE).setUpToDateThreshold(Duration.ZERO).setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).setRateLimitPolicyFactory(RateLimitPolicyFactory.withDefaultRateLimiter()).setMaxCapacityPerShard(10000);
        }

        static @UnknownKeyFor @NonNull @Initialized Builder<@UnknownKeyFor @NonNull @Initialized KinesisRecord> newBuilder() {
            return Read.newBuilder((SerializableFunction & Serializable)x -> x);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withStreamName(@UnknownKeyFor @NonNull @Initialized String streamName) {
            return this.toBuilder().setStreamName(streamName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withInitialPositionInStream(@UnknownKeyFor @NonNull @Initialized InitialPositionInStream initialPosition) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialPosition)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withInitialTimestampInStream(@UnknownKeyFor @NonNull @Initialized Instant initialTimestamp) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialTimestamp)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider awsClientsProvider) {
            return this.toBuilder().setAWSClientsProvider(awsClientsProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider awsCredentialsProvider, @UnknownKeyFor @NonNull @Initialized Regions region) {
            return this.withAWSClientsProvider(awsCredentialsProvider, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider awsCredentialsProvider, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint) {
            return this.withAWSClientsProvider(awsCredentialsProvider, region, serviceEndpoint, true);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint, true);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider awsCredentialsProvider, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint, @UnknownKeyFor @NonNull @Initialized boolean verifyCertificate) {
            return this.withAWSClientsProvider(new BasicKinesisProvider(awsCredentialsProvider, region, serviceEndpoint, verifyCertificate));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Regions region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint, @UnknownKeyFor @NonNull @Initialized boolean verifyCertificate) {
            AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awsAccessKey, awsSecretKey));
            return this.withAWSClientsProvider((AWSCredentialsProvider)awsCredentialsProvider, region, serviceEndpoint, verifyCertificate);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
            Preconditions.checkArgument((maxNumRecords > 0L ? 1 : 0) != 0, (String)"maxNumRecords must be positive, but was: %s", (long)maxNumRecords);
            return this.toBuilder().setMaxNumRecords(maxNumRecords).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
            Preconditions.checkArgument((maxReadTime != null ? 1 : 0) != 0, (Object)"maxReadTime can not be null");
            return this.toBuilder().setMaxReadTime(maxReadTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withUpToDateThreshold(@UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold) {
            Preconditions.checkArgument((upToDateThreshold != null ? 1 : 0) != 0, (Object)"upToDateThreshold can not be null");
            return this.toBuilder().setUpToDateThreshold(upToDateThreshold).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withRequestRecordsLimit(@UnknownKeyFor @NonNull @Initialized int limit) {
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (String)"limit must be positive, but was: %s", (int)limit);
            Preconditions.checkArgument((limit <= 10000 ? 1 : 0) != 0, (String)"limit must be up to 10,000, but was: %s", (int)limit);
            return this.toBuilder().setRequestRecordsLimit(limit).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withArrivalTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withArrivalTimeWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized Duration watermarkIdleDurationThreshold) {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy(watermarkIdleDurationThreshold)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withProcessingTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withProcessingTimePolicy()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCustomWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory) {
            Preconditions.checkArgument((watermarkPolicyFactory != null ? 1 : 0) != 0, (Object)"watermarkPolicyFactory cannot be null");
            return this.toBuilder().setWatermarkPolicyFactory(watermarkPolicyFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withFixedDelayRateLimitPolicy() {
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withFixedDelayRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized Duration delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay(delay)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withDynamicDelayRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withDelay(delay)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCustomRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory) {
            Preconditions.checkArgument((rateLimitPolicyFactory != null ? 1 : 0) != 0, (Object)"rateLimitPolicyFactory cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(rateLimitPolicyFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMaxCapacityPerShard(@UnknownKeyFor @NonNull @Initialized Integer maxCapacity) {
            Preconditions.checkArgument((maxCapacity > 0 ? 1 : 0) != 0, (String)"maxCapacity must be positive, but was: %s", (Object)maxCapacity);
            return this.toBuilder().setMaxCapacityPerShard(maxCapacity).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Read.Unbounded unbounded;
            LOG.warn("You are using a deprecated IO for Kinesis. Please migrate to module 'org.apache.beam:beam-sdks-java-io-amazon-web-services2'.");
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new KinesisSource(this.getAWSClientsProvider(), this.getStreamName(), this.getInitialPosition(), this.getUpToDateThreshold(), this.getWatermarkPolicyFactory(), this.getRateLimitPolicyFactory(), this.getRequestRecordsLimit(), this.getMaxCapacityPerShard()));
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return ((PCollection)((PCollection)input.apply((PTransform)transform)).apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<T>(){}).via(this.getParseFn()))).setCoder(this.getCoder());
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setStreamName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setInitialPosition(@UnknownKeyFor @NonNull @Initialized StartingPoint var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUpToDateThreshold(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRequestRecordsLimit(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWatermarkPolicyFactory(@UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRateLimitPolicyFactory(@UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxCapacityPerShard(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized KinesisRecord, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }
}

