/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.http;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="HTTP", name="i18n::ActionHTTP.Name", description="i18n::ActionHTTP.Description", image="HTTP.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionHttp.keyword"}, documentationUrl="/workflow/actions/http.html")
public class ActionHttp
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionHttp.class;
    private static final String URL_FIELDNAME = "URL";
    private static final String UPLOADFILE_FIELDNAME = "UPLOAD";
    private static final String TARGETFILE_FIELDNAME = "DESTINATION";
    private String url = null;
    private String targetFilename;
    private boolean fileAppended;
    private boolean dateTimeAdded;
    private String targetFilenameExtension;
    private String uploadFilename;
    private String urlFieldname;
    private String uploadFieldname;
    private String destinationFieldname;
    private boolean runForEveryRow;
    private boolean ignoreSsl;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private String username;
    private String password;
    private boolean addfilenameresult = true;
    private String[] headerName;
    private String[] headerValue;

    public ActionHttp(String n) {
        super(n, "");
    }

    public ActionHttp() {
        this("");
    }

    private void allocate(int nrHeaders) {
        this.headerName = new String[nrHeaders];
        this.headerValue = new String[nrHeaders];
    }

    public Object clone() {
        ActionHttp je = (ActionHttp)super.clone();
        if (this.headerName != null) {
            int nrHeaders = this.headerName.length;
            je.allocate(nrHeaders);
            System.arraycopy(this.headerName, 0, je.headerName, 0, nrHeaders);
            System.arraycopy(this.headerValue, 0, je.headerValue, 0, nrHeaders);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"url", (String)this.url));
        retval.append("      ").append(XmlHandler.addTagValue((String)"targetfilename", (String)this.targetFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"file_appended", (boolean)this.fileAppended));
        retval.append("      ").append(XmlHandler.addTagValue((String)"date_time_added", (boolean)this.dateTimeAdded));
        retval.append("      ").append(XmlHandler.addTagValue((String)"targetfilename_extension", (String)this.targetFilenameExtension));
        retval.append("      ").append(XmlHandler.addTagValue((String)"uploadfilename", (String)this.uploadFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"run_every_row", (boolean)this.runForEveryRow));
        retval.append("      ").append(XmlHandler.addTagValue((String)"ignore_ssl", (boolean)this.ignoreSsl));
        retval.append("      ").append(XmlHandler.addTagValue((String)"url_fieldname", (String)this.urlFieldname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"upload_fieldname", (String)this.uploadFieldname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"dest_fieldname", (String)this.destinationFieldname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"username", (String)this.username));
        retval.append("      ").append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"proxy_host", (String)this.proxyHostname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XmlHandler.addTagValue((String)"non_proxy_hosts", (String)this.nonProxyHosts));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addfilenameresult", (boolean)this.addfilenameresult));
        retval.append("      <headers>").append(Const.CR);
        if (this.headerName != null) {
            for (int i = 0; i < this.headerName.length; ++i) {
                retval.append("        <header>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"header_name", (String)this.headerName[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"header_value", (String)this.headerValue[i]));
                retval.append("        </header>").append(Const.CR);
            }
        }
        retval.append("      </headers>").append(Const.CR);
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.url = XmlHandler.getTagValue((Node)entrynode, (String)"url");
            this.targetFilename = XmlHandler.getTagValue((Node)entrynode, (String)"targetfilename");
            this.fileAppended = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"file_appended"));
            this.dateTimeAdded = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"date_time_added"));
            this.targetFilenameExtension = Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"targetfilename_extension"), (String)XmlHandler.getTagValue((Node)entrynode, (String)"targetfilename_extention"));
            this.uploadFilename = XmlHandler.getTagValue((Node)entrynode, (String)"uploadfilename");
            this.urlFieldname = XmlHandler.getTagValue((Node)entrynode, (String)"url_fieldname");
            this.uploadFieldname = XmlHandler.getTagValue((Node)entrynode, (String)"upload_fieldname");
            this.destinationFieldname = XmlHandler.getTagValue((Node)entrynode, (String)"dest_fieldname");
            this.runForEveryRow = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"run_every_row"));
            this.ignoreSsl = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"ignore_ssl"));
            this.username = XmlHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"password"));
            this.proxyHostname = XmlHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XmlHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.nonProxyHosts = XmlHandler.getTagValue((Node)entrynode, (String)"non_proxy_hosts");
            this.addfilenameresult = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"addfilenameresult"), (String)"Y"));
            Node headers = XmlHandler.getSubNode((Node)entrynode, (String)"headers");
            int nrHeaders = XmlHandler.countNodes((Node)headers, (String)"header");
            this.allocate(nrHeaders);
            for (int i = 0; i < nrHeaders; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)headers, (String)"header", (int)i);
                this.headerName[i] = XmlHandler.getTagValue((Node)fnode, (String)"header_name");
                this.headerValue[i] = XmlHandler.getTagValue((Node)fnode, (String)"header_value");
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'HTTP' from XML node", (Throwable)xe);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTargetFilename() {
        return this.targetFilename;
    }

    public void setTargetFilename(String targetFilename) {
        this.targetFilename = targetFilename;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public boolean isAddFilenameToResult() {
        return this.addfilenameresult;
    }

    public void setAddFilenameToResult(boolean addfilenameresult) {
        this.addfilenameresult = addfilenameresult;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String[] getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String[] headerName) {
        this.headerName = headerName;
    }

    public String[] getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderValue(String[] headerValue) {
        this.headerValue = headerValue;
    }

    /*
     * Exception decompiling
     */
    public synchronized Result execute(Result previousResult, int nr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isEvaluation() {
        return true;
    }

    public String getUploadFilename() {
        return this.uploadFilename;
    }

    public void setUploadFilename(String uploadFilename) {
        this.uploadFilename = uploadFilename;
    }

    public String getUrlFieldname() {
        return this.urlFieldname;
    }

    public void setUrlFieldname(String getFieldname) {
        this.urlFieldname = getFieldname;
    }

    public String getUploadFieldname() {
        return this.uploadFieldname;
    }

    public void setUploadFieldname(String uploadFieldname) {
        this.uploadFieldname = uploadFieldname;
    }

    public String getDestinationFieldname() {
        return this.destinationFieldname;
    }

    public void setDestinationFieldname(String destinationFieldname) {
        this.destinationFieldname = destinationFieldname;
    }

    public boolean isRunForEveryRow() {
        return this.runForEveryRow;
    }

    public void setRunForEveryRow(boolean runForEveryRow) {
        this.runForEveryRow = runForEveryRow;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public boolean isDateTimeAdded() {
        return this.dateTimeAdded;
    }

    public void setDateTimeAdded(boolean dateTimeAdded) {
        this.dateTimeAdded = dateTimeAdded;
    }

    public String getTargetFilenameExtension() {
        return this.targetFilenameExtension;
    }

    public void setTargetFilenameExtension(String uploadFilenameExtension) {
        this.targetFilenameExtension = uploadFilenameExtension;
    }

    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    public void setIgnoreSsl(boolean ignoreSsl) {
        this.ignoreSsl = ignoreSsl;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        String realUrl = this.resolve(this.url);
        ResourceReference reference = new ResourceReference((IResourceHolder)this);
        reference.getEntries().add(new ResourceEntry(realUrl, ResourceEntry.ResourceType.URL));
        references.add(reference);
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "targetFilename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "targetFilenameExtention", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "uploadFilename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "proxyPort", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }
}

