/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execsqlrow;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execsqlrow.ExecSqlRow;
import org.apache.hop.pipeline.transforms.execsqlrow.ExecSqlRowData;

@Transform(id="ExecSqlRow", image="execsqlrow.svg", name="i18n::ExecSqlRow.Name", description="i18n::ExecSqlRow.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", keywords={"i18n::ExecSqlRowMeta.keyword"}, documentationUrl="/pipeline/transforms/execsqlrow.html")
public class ExecSqlRowMeta
extends BaseTransformMeta<ExecSqlRow, ExecSqlRowData> {
    private static final Class<?> PKG = ExecSqlRowMeta.class;
    private IHopMetadataProvider metadataProvider;
    @HopMetadataProperty(key="sql_field", injectionKey="SQL_FIELD_NAME", injectionKeyDescription="ExecSqlRowMeta.Injection.SQL_FIELD_NAME")
    private String sqlField;
    @HopMetadataProperty(key="update_field", injectionKey="UPDATE_STATS", injectionKeyDescription="ExecSqlRowMeta.Injection.UPDATE_STATS")
    private String updateField;
    @HopMetadataProperty(key="insert_field", injectionKey="INSERT_STATS", injectionKeyDescription="ExecSqlRowMeta.Injection.INSERT_STATS")
    private String insertField;
    @HopMetadataProperty(key="delete_field", injectionKey="DELETE_STATS", injectionKeyDescription="ExecSqlRowMeta.Injection.DELETE_STATS")
    private String deleteField;
    @HopMetadataProperty(key="read_field", injectionKey="READ_STATS", injectionKeyDescription="ExecSqlRowMeta.Injection.READ_STATS")
    private String readField;
    @HopMetadataProperty(key="commit", injectionKey="COMMIT_SIZE", injectionKeyDescription="ExecSqlRowMeta.Injection.COMMIT_SIZE")
    private int commitSize;
    @HopMetadataProperty(injectionKey="READ_SQL_FROM_FILE", injectionKeyDescription="ExecSqlRowMeta.Injection.READ_SQL_FROM_FILE", defaultBoolean=false)
    private boolean sqlFromfile;
    @HopMetadataProperty(injectionKey="SEND_SINGLE_STATEMENT", injectionKeyDescription="ExecSqlRowMeta.Injection.SEND_SINGLE_STATEMENT", defaultBoolean=false)
    private boolean sendOneStatement;
    @HopMetadataProperty(injectionKey="CONNECTION_NAME", injectionKeyDescription="ExecSqlRowMeta.Injection.CONNECTION_NAME")
    private String connection;

    public String getSqlField() {
        return this.sqlField;
    }

    public void setSqlField(String sqlField) {
        this.sqlField = sqlField;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connectionName) {
        this.connection = connectionName;
    }

    public boolean isSendOneStatement() {
        return this.sendOneStatement;
    }

    public void setSendOneStatement(boolean sendOneStatement) {
        this.sendOneStatement = sendOneStatement;
    }

    public boolean isSqlFromfile() {
        return this.sqlFromfile;
    }

    public void setSqlFromfile(boolean sqlFromfile) {
        this.sqlFromfile = sqlFromfile;
    }

    public String getSqlFieldName() {
        return this.sqlField;
    }

    public void setSqlFieldName(String sqlField) {
        this.sqlField = sqlField;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public String getDeleteField() {
        return this.deleteField;
    }

    public void setDeleteField(String deleteField) {
        this.deleteField = deleteField;
    }

    public String getInsertField() {
        return this.insertField;
    }

    public void setInsertField(String insertField) {
        this.insertField = insertField;
    }

    public String getReadField() {
        return this.readField;
    }

    public void setReadField(String readField) {
        this.readField = readField;
    }

    public String getUpdateField() {
        return this.updateField;
    }

    public void setUpdateField(String updateField) {
        this.updateField = updateField;
    }

    public Object clone() {
        return super.clone();
    }

    public void setDefault() {
        this.sqlFromfile = false;
        this.commitSize = 1;
        this.connection = null;
        this.sqlField = null;
        this.sendOneStatement = true;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        RowMetaAndData add = ExecSqlRow.getResultRow(new Result(), this.getUpdateField(), this.getInsertField(), this.getDeleteField(), this.getReadField());
        r.mergeRowMeta(add.getRowMeta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Database db = null;
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (databaseMeta != null) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                db = new Database(loggingObject, variables, databaseMeta);
                this.databases = new Database[]{db};
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.DBConnectionOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                cr = this.sqlField != null && this.sqlField.length() != 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.SQLFieldNameEntered", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.SQLFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.ConnectionNeeded", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        catch (HopException e) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage(), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        finally {
            db.disconnect();
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.TransformReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlRowMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

