/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.util.Objects;
import org.apache.cassandra.db.AbstractArrayClusteringPrefix;
import org.apache.cassandra.db.ArrayClusteringBound;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.AbstractRangeTombstoneMarker;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public class RangeTombstoneBoundMarker
extends AbstractRangeTombstoneMarker<ClusteringBound<?>> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RangeTombstoneBoundMarker(new ArrayClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, AbstractArrayClusteringPrefix.EMPTY_VALUES_ARRAY), null));
    private final DeletionTime deletion;

    public RangeTombstoneBoundMarker(ClusteringBound<?> bound, DeletionTime deletion) {
        super(bound);
        this.deletion = deletion;
    }

    public static <V> RangeTombstoneBoundMarker inclusiveOpen(boolean reversed, V[] boundValues, ValueAccessor<V> accessor, DeletionTime deletion) {
        ClusteringBound<V> bound = accessor.factory().inclusiveOpen(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static <V> RangeTombstoneBoundMarker inclusiveOpen(boolean reversed, ClusteringPrefix<V> from, DeletionTime deletion) {
        return RangeTombstoneBoundMarker.inclusiveOpen(reversed, from.getRawValues(), from.accessor(), deletion);
    }

    public static <V> RangeTombstoneBoundMarker exclusiveOpen(boolean reversed, V[] boundValues, ValueAccessor<V> accessor, DeletionTime deletion) {
        ClusteringBound<V> bound = accessor.factory().exclusiveOpen(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static <V> RangeTombstoneBoundMarker exclusiveOpen(boolean reversed, ClusteringPrefix<V> from, DeletionTime deletion) {
        return RangeTombstoneBoundMarker.exclusiveOpen(reversed, from.getRawValues(), from.accessor(), deletion);
    }

    public static <V> RangeTombstoneBoundMarker inclusiveClose(boolean reversed, V[] boundValues, ValueAccessor<V> accessor, DeletionTime deletion) {
        ClusteringBound<V> bound = accessor.factory().inclusiveClose(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static <V> RangeTombstoneBoundMarker inclusiveClose(boolean reversed, ClusteringPrefix<V> from, DeletionTime deletion) {
        return RangeTombstoneBoundMarker.inclusiveClose(reversed, from.getRawValues(), from.accessor(), deletion);
    }

    public static <V> RangeTombstoneBoundMarker exclusiveClose(boolean reversed, V[] boundValues, ValueAccessor<V> accessor, DeletionTime deletion) {
        ClusteringBound<V> bound = accessor.factory().exclusiveClose(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static <V> RangeTombstoneBoundMarker exclusiveClose(boolean reversed, ClusteringPrefix<V> from, DeletionTime deletion) {
        return RangeTombstoneBoundMarker.exclusiveClose(reversed, from.getRawValues(), from.accessor(), deletion);
    }

    @Override
    public boolean isBoundary() {
        return false;
    }

    @Override
    public boolean hasInvalidDeletions() {
        return !this.deletionTime().validate();
    }

    public DeletionTime deletionTime() {
        return this.deletion;
    }

    @Override
    public DeletionTime openDeletionTime(boolean reversed) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return this.deletion;
    }

    @Override
    public DeletionTime closeDeletionTime(boolean reversed) {
        if (this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return this.deletion;
    }

    @Override
    public boolean openIsInclusive(boolean reversed) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return ((ClusteringBound)this.bound).isInclusive();
    }

    @Override
    public boolean closeIsInclusive(boolean reversed) {
        if (this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return ((ClusteringBound)this.bound).isInclusive();
    }

    @Override
    public ClusteringBound<?> openBound(boolean reversed) {
        return this.isOpen(reversed) ? (ClusteringBound)this.clustering() : null;
    }

    @Override
    public ClusteringBound<?> closeBound(boolean reversed) {
        return this.isClose(reversed) ? (ClusteringBound)this.clustering() : null;
    }

    @Override
    public RangeTombstoneBoundMarker clone(ByteBufferCloner cloner) {
        return new RangeTombstoneBoundMarker((ClusteringBound<?>)((ClusteringBound)this.clustering()).clone(cloner), this.deletion);
    }

    @Override
    public RangeTombstoneBoundMarker withNewOpeningDeletionTime(boolean reversed, DeletionTime newDeletionTime) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return new RangeTombstoneBoundMarker((ClusteringBound)this.clustering(), newDeletionTime);
    }

    @Override
    public void digest(Digest digest) {
        ((ClusteringBound)this.bound).digest(digest);
        this.deletion.digest(digest);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + this.deletion.unsharedHeapSize();
    }

    @Override
    public String toString(TableMetadata metadata) {
        return String.format("Marker %s@%d/%d", ((ClusteringBound)this.bound).toString(metadata), this.deletion.markedForDeleteAt(), this.deletion.localDeletionTime());
    }

    public boolean equals(Object other) {
        if (!(other instanceof RangeTombstoneBoundMarker)) {
            return false;
        }
        RangeTombstoneBoundMarker that = (RangeTombstoneBoundMarker)other;
        return ((ClusteringBound)this.bound).equals(that.bound) && this.deletion.equals(that.deletion);
    }

    public int hashCode() {
        return Objects.hash(this.bound, this.deletion);
    }
}

