/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.repair.CoordinatedRepairResult;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;

public interface RepairTask {
    public String name();

    default public String successMessage() {
        return this.name() + " completed successfully";
    }

    public Future<CoordinatedRepairResult> performUnsafe(ExecutorPlus var1) throws Exception;

    default public Future<CoordinatedRepairResult> perform(ExecutorPlus executor) {
        try {
            return this.performUnsafe(executor);
        }
        catch (Error | Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            return ImmediateFuture.failure(e);
        }
    }
}

