/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.TimeUUID;

public class FinalizePromise
extends RepairMessage {
    public final TimeUUID sessionID;
    public final InetAddressAndPort participant;
    public final boolean promised;
    public static final IVersionedSerializer<FinalizePromise> serializer = new IVersionedSerializer<FinalizePromise>(){

        @Override
        public void serialize(FinalizePromise msg, DataOutputPlus out, int version) throws IOException {
            msg.sessionID.serialize(out);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(msg.participant, out, version);
            out.writeBoolean(msg.promised);
        }

        @Override
        public FinalizePromise deserialize(DataInputPlus in, int version) throws IOException {
            return new FinalizePromise(TimeUUID.deserialize(in), InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version), in.readBoolean());
        }

        @Override
        public long serializedSize(FinalizePromise msg, int version) {
            long size = TimeUUID.sizeInBytes();
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(msg.participant, version);
            return size += (long)TypeSizes.sizeof(msg.promised);
        }
    };

    public FinalizePromise(TimeUUID sessionID, InetAddressAndPort participant, boolean promised) {
        super(null);
        assert (sessionID != null);
        assert (participant != null);
        this.sessionID = sessionID;
        this.participant = participant;
        this.promised = promised;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizePromise that = (FinalizePromise)o;
        if (this.promised != that.promised) {
            return false;
        }
        if (!this.sessionID.equals(that.sessionID)) {
            return false;
        }
        return this.participant.equals(that.participant);
    }

    public int hashCode() {
        int result = this.sessionID.hashCode();
        result = 31 * result + this.participant.hashCode();
        result = 31 * result + (this.promised ? 1 : 0);
        return result;
    }
}

