/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.flink.FlinkStateBackendFactory;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface FlinkPipelineOptions
extends PipelineOptions,
ApplicationNameOptions,
StreamingOptions,
FileStagingOptions {
    public static final @UnknownKeyFor @NonNull @Initialized String AUTO = "[auto]";
    public static final @UnknownKeyFor @NonNull @Initialized String PIPELINED = "PIPELINED";
    public static final @UnknownKeyFor @NonNull @Initialized String EXACTLY_ONCE = "EXACTLY_ONCE";

    @Description(value="Address of the Flink Master where the Pipeline should be executed. Can either be of the form \"host:port\" or one of the special values [local], [collection] or [auto].")
    @Default.String(value="[auto]")
    public @UnknownKeyFor @NonNull @Initialized String getFlinkMaster();

    public void setFlinkMaster(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The degree of parallelism to be used when distributing operations onto workers. If the parallelism is not set, the configured Flink default is used, or 1 if none can be found.")
    @Default.Integer(value=-1)
    public @UnknownKeyFor @NonNull @Initialized Integer getParallelism();

    public void setParallelism(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The pipeline wide maximum degree of parallelism to be used. The maximum parallelism specifies the upper limit for dynamic scaling and the number of key groups used for partitioned state.")
    @Default.Integer(value=-1)
    public @UnknownKeyFor @NonNull @Initialized Integer getMaxParallelism();

    public void setMaxParallelism(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The interval in milliseconds at which to trigger checkpoints of the running pipeline. Default: No checkpointing.")
    @Default.Long(value=-1L)
    public @UnknownKeyFor @NonNull @Initialized Long getCheckpointingInterval();

    public void setCheckpointingInterval(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The checkpointing mode that defines consistency guarantee.")
    @Default.String(value="EXACTLY_ONCE")
    public @UnknownKeyFor @NonNull @Initialized String getCheckpointingMode();

    public void setCheckpointingMode(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The maximum time in milliseconds that a checkpoint may take before being discarded.")
    @Default.Long(value=-1L)
    public @UnknownKeyFor @NonNull @Initialized Long getCheckpointTimeoutMillis();

    public void setCheckpointTimeoutMillis(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The minimal pause in milliseconds before the next checkpoint is triggered.")
    @Default.Long(value=-1L)
    public @UnknownKeyFor @NonNull @Initialized Long getMinPauseBetweenCheckpoints();

    public void setMinPauseBetweenCheckpoints(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The maximum number of concurrent checkpoints. Defaults to 1 (=no concurrent checkpoints).")
    @Default.Integer(value=1)
    public @UnknownKeyFor @NonNull @Initialized int getNumConcurrentCheckpoints();

    public void setNumConcurrentCheckpoints(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="Sets the expected behaviour for tasks in case that they encounter an error in their checkpointing procedure. If this is set to true, the task will fail on checkpointing error. If this is set to false, the task will only decline the checkpoint and continue running. ")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized Boolean getFailOnCheckpointingErrors();

    public void setFailOnCheckpointingErrors(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="If set, finishes the current bundle and flushes all output before checkpointing the state of the operators. By default, starts checkpointing immediately and buffers any remaining bundle output as part of the checkpoint. The setting may affect the checkpoint alignment.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized boolean getFinishBundleBeforeCheckpointing();

    public void setFinishBundleBeforeCheckpointing(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="Shuts down sources which have been idle for the configured time of milliseconds. Once a source has been shut down, checkpointing is not possible anymore. Shutting down the sources eventually leads to pipeline shutdown (=Flink job finishes) once all input has been processed. Unless explicitly set, this will default to Long.MAX_VALUE when checkpointing is enabled and to 0 when checkpointing is disabled. See https://issues.apache.org/jira/browse/FLINK-2491 for progress on this issue.")
    @Default.Long(value=-1L)
    public @UnknownKeyFor @NonNull @Initialized Long getShutdownSourcesAfterIdleMs();

    public void setShutdownSourcesAfterIdleMs(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="Sets the number of times that failed tasks are re-executed. A value of zero effectively disables fault tolerance. A value of -1 indicates that the system default value (as defined in the configuration) should be used.")
    @Default.Integer(value=-1)
    public @UnknownKeyFor @NonNull @Initialized Integer getNumberOfExecutionRetries();

    public void setNumberOfExecutionRetries(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Sets the delay in milliseconds between executions. A value of {@code -1} indicates that the default value should be used.")
    @Default.Long(value=-1L)
    public @UnknownKeyFor @NonNull @Initialized Long getExecutionRetryDelay();

    public void setExecutionRetryDelay(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="Sets the behavior of reusing objects.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getObjectReuse();

    public void setObjectReuse(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Sets the behavior of operator chaining.")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized Boolean getOperatorChaining();

    public void setOperatorChaining(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Deprecated
    @Description(value="Sets the state backend factory to use in streaming mode. Defaults to the flink cluster's state.backend configuration.")
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FlinkStateBackendFactory> getStateBackendFactory();

    @Deprecated
    public void setStateBackendFactory(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FlinkStateBackendFactory> var1);

    public void setStateBackend(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="State backend to store Beam's state. Use 'rocksdb' or 'filesystem'.")
    public @UnknownKeyFor @NonNull @Initialized String getStateBackend();

    public void setStateBackendStoragePath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="State backend path to persist state backend data. Used to initialize state backend.")
    public @UnknownKeyFor @NonNull @Initialized String getStateBackendStoragePath();

    @Description(value="Disable Beam metrics in Flink Runner")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getDisableMetrics();

    public void setDisableMetrics(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Enables or disables externalized checkpoints. Works in conjunction with CheckpointingInterval")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean isExternalizedCheckpointsEnabled();

    public void setExternalizedCheckpointsEnabled(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Sets the behavior of externalized checkpoints on cancellation.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getRetainExternalizedCheckpointsOnCancellation();

    public void setRetainExternalizedCheckpointsOnCancellation(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="The maximum number of elements in a bundle.")
    @Default.Long(value=1000L)
    public @UnknownKeyFor @NonNull @Initialized Long getMaxBundleSize();

    public void setMaxBundleSize(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The maximum time to wait before finalising a bundle (in milliseconds).")
    @Default.Long(value=1000L)
    public @UnknownKeyFor @NonNull @Initialized Long getMaxBundleTimeMills();

    public void setMaxBundleTimeMills(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="Interval in milliseconds for sending latency tracking marks from the sources to the sinks. Interval value <= 0 disables the feature.")
    @Default.Long(value=0L)
    public @UnknownKeyFor @NonNull @Initialized Long getLatencyTrackingInterval();

    public void setLatencyTrackingInterval(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The interval in milliseconds for automatic watermark emission.")
    public @UnknownKeyFor @NonNull @Initialized Long getAutoWatermarkInterval();

    public void setAutoWatermarkInterval(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="Flink mode for data exchange of batch pipelines. Reference {@link org.apache.flink.api.common.ExecutionMode}. Set this to BATCH_FORCED if pipelines get blocked, see https://issues.apache.org/jira/browse/FLINK-10672")
    @Default.String(value="PIPELINED")
    public @UnknownKeyFor @NonNull @Initialized String getExecutionModeForBatch();

    public void setExecutionModeForBatch(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Savepoint restore path. If specified, restores the streaming pipeline from the provided path.")
    public @UnknownKeyFor @NonNull @Initialized String getSavepointPath();

    public void setSavepointPath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Flag indicating whether non restored state is allowed if the savepoint contains state for an operator that is no longer part of the pipeline.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getAllowNonRestoredState();

    public void setAllowNonRestoredState(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Flag indicating whether auto-balance sharding for WriteFiles transform should be enabled. This might prove useful in streaming use-case, where pipeline needs to write quite many events into files, typically divided into N shards. Default behavior on Flink would be, that some workers will receive more shards to take care of than others. This cause workers to go out of balance in terms of processing backlog and memory usage. Enabling this feature will make shards to be spread evenly among available workers in improve throughput and memory usage stability.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean isAutoBalanceWriteFilesShardingEnabled();

    public void setAutoBalanceWriteFilesShardingEnabled(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="If not null, reports the checkpoint duration of each ParDo stage in the provided metric namespace.")
    public @UnknownKeyFor @NonNull @Initialized String getReportCheckpointDuration();

    public void setReportCheckpointDuration(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Flag indicating whether result of GBK needs to be re-iterable. Re-iterable result implies that all values for a single key must fit in memory as we currently do not support spilling to disk.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getReIterableGroupByKeyResult();

    public void setReIterableGroupByKeyResult(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Remove unneeded deep copy between operators. See https://issues.apache.org/jira/browse/BEAM-11146")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getFasterCopy();

    public void setFasterCopy(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Directory containing Flink YAML configuration files. These properties will be set to all jobs submitted to Flink and take precedence over configurations in FLINK_CONF_DIR.")
    public @UnknownKeyFor @NonNull @Initialized String getFlinkConfDir();

    public void setFlinkConfDir(@UnknownKeyFor @NonNull @Initialized String var1);

    public static @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions defaults() {
        return (FlinkPipelineOptions)PipelineOptionsFactory.as(FlinkPipelineOptions.class);
    }
}

