/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.unbounded;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.FlinkSourceReaderBase;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.core.io.InputStatus;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkUnboundedSourceReader<@UnknownKeyFor T>
extends FlinkSourceReaderBase<T, WindowedValue<ValueWithRecordId<T>>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkUnboundedSourceReader.class);
    @VisibleForTesting
    protected static final @UnknownKeyFor @NonNull @Initialized String PENDING_BYTES_METRIC_NAME = "pendingBytes";
    private static final @UnknownKeyFor @NonNull @Initialized long SLEEP_ON_IDLE_MS = 50L;
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void>> dataAvailableFutureRef;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @NonNull @Initialized ReaderAndOutput> readers = new ArrayList<FlinkSourceReaderBase.ReaderAndOutput>();
    private @UnknownKeyFor @NonNull @Initialized int currentReaderIndex = 0;
    private volatile @UnknownKeyFor @NonNull @Initialized boolean shouldEmitWatermark;

    public FlinkUnboundedSourceReader(@UnknownKeyFor @NonNull @Initialized SourceReaderContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Function<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>, @UnknownKeyFor @NonNull @Initialized Long> timestampExtractor) {
        super(context, pipelineOptions, timestampExtractor);
        this.dataAvailableFutureRef = new AtomicReference<CompletableFuture>(DUMMY_FUTURE);
    }

    @VisibleForTesting
    protected FlinkUnboundedSourceReader(@UnknownKeyFor @NonNull @Initialized SourceReaderContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService executor, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Function<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>, @UnknownKeyFor @NonNull @Initialized Long> timestampExtractor) {
        super(executor, context, pipelineOptions, timestampExtractor);
        this.dataAvailableFutureRef = new AtomicReference<CompletableFuture>(DUMMY_FUTURE);
    }

    @Override
    public void start() {
        this.createPendingBytesGauge(this.context);
        Long watermarkInterval = ((FlinkPipelineOptions)this.pipelineOptions.as(FlinkPipelineOptions.class)).getAutoWatermarkInterval();
        if (watermarkInterval != null) {
            this.scheduleTaskAtFixedRate(() -> {
                this.shouldEmitWatermark = true;
                CompletableFuture<Void> f = this.dataAvailableFutureRef.get();
                if (f != DUMMY_FUTURE) {
                    f.complete(null);
                }
            }, watermarkInterval, watermarkInterval);
        } else {
            LOG.warn("AutoWatermarkInterval is not set, watermarks won't be emitted.");
        }
    }

    public @UnknownKeyFor @NonNull @Initialized InputStatus pollNext(@UnknownKeyFor @NonNull @Initialized ReaderOutput<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>> output) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.checkExceptionAndMaybeThrow();
        this.maybeEmitWatermark();
        this.maybeCreateReaderForNewSplits();
        FlinkSourceReaderBase.ReaderAndOutput reader = this.nextReaderWithData();
        if (reader != null) {
            this.emitRecord(reader, output);
            return InputStatus.MORE_AVAILABLE;
        }
        LOG.trace("No data available for now.");
        return InputStatus.NOTHING_AVAILABLE;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void> isAvailableForAliveReaders() {
        CompletableFuture<Void> future = this.dataAvailableFutureRef.get();
        if (future == DUMMY_FUTURE) {
            CompletableFuture<Void> newFuture = new CompletableFuture<Void>();
            this.dataAvailableFutureRef.set(newFuture);
            if (this.shouldEmitWatermark || this.hasException()) {
                this.dataAvailableFutureRef.set(DUMMY_FUTURE);
                newFuture.complete(null);
            } else {
                LOG.debug("There is no data available, scheduling the idle reader checker.");
                this.scheduleTask(() -> {
                    CompletableFuture<Void> f = this.dataAvailableFutureRef.get();
                    if (f != DUMMY_FUTURE) {
                        f.complete(null);
                    }
                }, 50L);
            }
            return newFuture;
        }
        if (future.isDone()) {
            this.dataAvailableFutureRef.getAndSet(DUMMY_FUTURE);
            return future;
        }
        return future;
    }

    private void emitRecord(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @NonNull @Initialized ReaderAndOutput readerAndOutput, @UnknownKeyFor @NonNull @Initialized ReaderOutput<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>> output) {
        UnboundedSource.UnboundedReader reader = FlinkUnboundedSourceReader.asUnbounded(readerAndOutput.reader);
        Object item = reader.getCurrent();
        byte[] recordId = reader.getCurrentRecordId();
        Instant timestamp = reader.getCurrentTimestamp();
        WindowedValue windowedValue = WindowedValue.of((Object)new ValueWithRecordId(item, recordId), (Instant)timestamp, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.NO_FIRING);
        LOG.trace("Emitting record: {}", (Object)windowedValue);
        if (this.timestampExtractor == null) {
            readerAndOutput.getAndMaybeCreateSplitOutput(output).collect((Object)windowedValue);
        } else {
            readerAndOutput.getAndMaybeCreateSplitOutput(output).collect((Object)windowedValue, ((Long)this.timestampExtractor.apply(windowedValue)).longValue());
        }
        this.numRecordsInCounter.inc();
    }

    private void maybeEmitWatermark() {
        if (this.shouldEmitWatermark) {
            this.allReaders().values().forEach(readerAndOutput -> {
                SourceOutput sourceOutput = readerAndOutput.sourceOutput();
                if (sourceOutput != null) {
                    long watermark = FlinkUnboundedSourceReader.asUnbounded(readerAndOutput.reader).getWatermark().getMillis();
                    sourceOutput.emitWatermark(new Watermark(watermark));
                }
            });
            this.shouldEmitWatermark = false;
        }
    }

    private void maybeCreateReaderForNewSplits() throws @UnknownKeyFor @NonNull @Initialized Exception {
        while (!this.sourceSplits().isEmpty()) {
            Optional<FlinkSourceReaderBase.ReaderAndOutput> readerAndOutputOpt = this.createAndTrackNextReader();
            if (readerAndOutputOpt.isPresent()) {
                this.readers.add(readerAndOutputOpt.get());
                continue;
            }
            this.checkExceptionAndMaybeThrow();
        }
    }

    @Nullable
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ReaderAndOutput nextReaderWithData() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int numReaders = this.readers.size();
        for (int i = 0; i < numReaders; ++i) {
            FlinkSourceReaderBase.ReaderAndOutput readerAndOutput = this.readers.get(this.currentReaderIndex);
            this.currentReaderIndex = (this.currentReaderIndex + 1) % numReaders;
            if (!readerAndOutput.startOrAdvance()) continue;
            return readerAndOutput;
        }
        return null;
    }

    private static <T> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<T> asUnbounded(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader) {
        return (UnboundedSource.UnboundedReader)reader;
    }

    private void createPendingBytesGauge(@UnknownKeyFor @NonNull @Initialized SourceReaderContext context) {
        context.metricGroup().gauge(PENDING_BYTES_METRIC_NAME, () -> {
            long pendingBytes = -1L;
            for (FlinkSourceReaderBase.ReaderAndOutput readerAndOutput : this.allReaders().values()) {
                long pendingBytesForReader = FlinkUnboundedSourceReader.asUnbounded(readerAndOutput.reader).getSplitBacklogBytes();
                if (pendingBytesForReader == -1L) continue;
                pendingBytes = pendingBytes == -1L ? pendingBytesForReader : pendingBytes + pendingBytesForReader;
            }
            return pendingBytes;
        });
    }
}

