/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class CombineFnBase {

    @Internal
    static abstract class AbstractGlobalCombineFn<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    implements GlobalCombineFn<InputT, AccumT, OutputT>,
    Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized String INCOMPATIBLE_GLOBAL_WINDOW_ERROR_MESSAGE = "Default values are not supported in Combine.globally() if the input PCollection is not windowed by GlobalWindows. Instead, use Combine.globally().withoutDefaults() to output an empty PCollection if the input PCollection is empty, or Combine.globally().asSingletonView() to get the default output of the CombineFn if the input PCollection is empty.";

        AbstractGlobalCombineFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            return registry.getCoder(this.getClass(), AbstractGlobalCombineFn.class, (Map<Type, ? extends Coder<?>>)ImmutableMap.of(this.getInputTVariable(), inputCoder), this.getAccumTVariable());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            return registry.getCoder(this.getClass(), AbstractGlobalCombineFn.class, (Map<Type, ? extends Coder<?>>)ImmutableMap.of(this.getInputTVariable(), inputCoder, this.getAccumTVariable(), this.getAccumulatorCoder(registry, inputCoder)), this.getOutputTVariable());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getIncompatibleGlobalWindowErrorMessage() {
            return INCOMPATIBLE_GLOBAL_WINDOW_ERROR_MESSAGE;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeVariable<@UnknownKeyFor @KeyForBottom @NonNull @Initialized @NonNull @Initialized ?> getInputTVariable() {
            return (TypeVariable)new TypeDescriptor<InputT>(AbstractGlobalCombineFn.class){}.getType();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeVariable<@UnknownKeyFor @KeyForBottom @NonNull @Initialized @NonNull @Initialized ?> getAccumTVariable() {
            return (TypeVariable)new TypeDescriptor<AccumT>(AbstractGlobalCombineFn.class){}.getType();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeVariable<@UnknownKeyFor @KeyForBottom @NonNull @Initialized @NonNull @Initialized ?> getOutputTVariable() {
            return (TypeVariable)new TypeDescriptor<OutputT>(AbstractGlobalCombineFn.class){}.getType();
        }

        @Override
        public void populateDisplayData( @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        }
    }

    @Internal
    public static interface GlobalCombineFn<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends Serializable,
    HasDisplayData {
        public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry var1, @UnknownKeyFor @NonNull @Initialized Coder<InputT> var2) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException;

        public @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry var1, @UnknownKeyFor @NonNull @Initialized Coder<InputT> var2) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException;

        public @UnknownKeyFor @NonNull @Initialized String getIncompatibleGlobalWindowErrorMessage();

        public OutputT defaultValue();
    }
}

