/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.AutoValue_ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@AutoValue
@Internal
public abstract class ValueInSingleWindow<@UnknownKeyFor T> {
    public T getValue() {
        return this.getNullableValue();
    }

    protected abstract @Nullable T getNullableValue();

    public abstract @UnknownKeyFor @NonNull @Initialized Instant getTimestamp();

    public abstract @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow();

    public abstract @UnknownKeyFor @NonNull @Initialized PaneInfo getPane();

    public static <T> @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T> of(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        return new AutoValue_ValueInSingleWindow<T>(value, timestamp, window, paneInfo);
    }

    public static class Coder<@UnknownKeyFor T>
    extends StructuredCoder<ValueInSingleWindow<T>> {
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<T> valueCoder;
        private final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;

        public static <T> @UnknownKeyFor @NonNull @Initialized Coder<T> of(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return new Coder<T>(valueCoder, windowCoder);
        }

        Coder(@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            this.valueCoder = valueCoder;
            this.windowCoder = windowCoder;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
            this.windowCoder.encode(windowedElem.getWindow(), outStream);
            PaneInfo.PaneInfoCoder.INSTANCE.encode(windowedElem.getPane(), outStream);
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Instant timestamp = InstantCoder.of().decode(inStream);
            BoundedWindow window = this.windowCoder.decode(inStream);
            PaneInfo pane = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            T value = this.valueCoder.decode(inStream, context);
            return new AutoValue_ValueInSingleWindow<T>(value, timestamp, window, pane);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return ImmutableList.of(this.valueCoder);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.coders.Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
            return ImmutableList.of(this.valueCoder, this.windowCoder);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
            this.windowCoder.verifyDeterministic();
        }
    }
}

