/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.PropertyGroup;
import com.dropbox.core.v2.files.FolderSharingInfo;
import com.dropbox.core.v2.files.Metadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class FolderMetadata
extends Metadata {
    protected final String id;
    protected final String sharedFolderId;
    protected final FolderSharingInfo sharingInfo;
    protected final List<PropertyGroup> propertyGroups;

    public FolderMetadata(String name, String id, String pathLower, String pathDisplay, String parentSharedFolderId, String sharedFolderId, FolderSharingInfo sharingInfo, List<PropertyGroup> propertyGroups) {
        super(name, pathLower, pathDisplay, parentSharedFolderId);
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        this.id = id;
        if (sharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        this.sharingInfo = sharingInfo;
        if (propertyGroups != null) {
            for (PropertyGroup x : propertyGroups) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
            }
        }
        this.propertyGroups = propertyGroups;
    }

    public FolderMetadata(String name, String id) {
        this(name, id, null, null, null, null, null, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getPathLower() {
        return this.pathLower;
    }

    @Override
    public String getPathDisplay() {
        return this.pathDisplay;
    }

    @Override
    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public FolderSharingInfo getSharingInfo() {
        return this.sharingInfo;
    }

    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public static Builder newBuilder(String name, String id) {
        return new Builder(name, id);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.sharedFolderId, this.sharingInfo, this.propertyGroups});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FolderMetadata other = (FolderMetadata)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.id != other.id && !this.id.equals(other.id) || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.pathDisplay != other.pathDisplay && (this.pathDisplay == null || !this.pathDisplay.equals(other.pathDisplay)) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)) || this.sharedFolderId != other.sharedFolderId && (this.sharedFolderId == null || !this.sharedFolderId.equals(other.sharedFolderId)) || this.sharingInfo != other.sharingInfo && (this.sharingInfo == null || !this.sharingInfo.equals(other.sharingInfo)) || this.propertyGroups != other.propertyGroups && (this.propertyGroups == null || !this.propertyGroups.equals(other.propertyGroups)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FolderMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FolderMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            this.writeTag("folder", g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            if (value.pathLower != null) {
                g.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g);
            }
            if (value.pathDisplay != null) {
                g.writeFieldName("path_display");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathDisplay, g);
            }
            if (value.parentSharedFolderId != null) {
                g.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g);
            }
            if (value.sharedFolderId != null) {
                g.writeFieldName("shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.sharedFolderId, g);
            }
            if (value.sharingInfo != null) {
                g.writeFieldName("sharing_info");
                StoneSerializers.nullableStruct(FolderSharingInfo.Serializer.INSTANCE).serialize(value.sharingInfo, g);
            }
            if (value.propertyGroups != null) {
                g.writeFieldName("property_groups");
                StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).serialize(value.propertyGroups, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FolderMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<PropertyGroup> f_propertyGroups;
            FolderSharingInfo f_sharingInfo;
            String f_sharedFolderId;
            String f_parentSharedFolderId;
            String f_pathDisplay;
            String f_pathLower;
            String f_id;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("folder".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_name = null;
                f_id = null;
                f_pathLower = null;
                f_pathDisplay = null;
                f_parentSharedFolderId = null;
                f_sharedFolderId = null;
                f_sharingInfo = null;
                f_propertyGroups = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_display".equals(field)) {
                        f_pathDisplay = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("shared_folder_id".equals(field)) {
                        f_sharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("sharing_info".equals(field)) {
                        f_sharingInfo = StoneSerializers.nullableStruct(FolderSharingInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("property_groups".equals(field)) {
                        f_propertyGroups = StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FolderMetadata value = new FolderMetadata(f_name, f_id, f_pathLower, f_pathDisplay, f_parentSharedFolderId, f_sharedFolderId, f_sharingInfo, f_propertyGroups);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends Metadata.Builder {
        protected final String id;
        protected String sharedFolderId;
        protected FolderSharingInfo sharingInfo;
        protected List<PropertyGroup> propertyGroups;

        protected Builder(String name, String id) {
            super(name);
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            this.id = id;
            this.sharedFolderId = null;
            this.sharingInfo = null;
            this.propertyGroups = null;
        }

        public Builder withSharedFolderId(String sharedFolderId) {
            if (sharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            return this;
        }

        public Builder withSharingInfo(FolderSharingInfo sharingInfo) {
            this.sharingInfo = sharingInfo;
            return this;
        }

        public Builder withPropertyGroups(List<PropertyGroup> propertyGroups) {
            if (propertyGroups != null) {
                for (PropertyGroup x : propertyGroups) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
                }
            }
            this.propertyGroups = propertyGroups;
            return this;
        }

        @Override
        public Builder withPathLower(String pathLower) {
            super.withPathLower(pathLower);
            return this;
        }

        @Override
        public Builder withPathDisplay(String pathDisplay) {
            super.withPathDisplay(pathDisplay);
            return this;
        }

        @Override
        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            super.withParentSharedFolderId(parentSharedFolderId);
            return this;
        }

        @Override
        public FolderMetadata build() {
            return new FolderMetadata(this.name, this.id, this.pathLower, this.pathDisplay, this.parentSharedFolderId, this.sharedFolderId, this.sharingInfo, this.propertyGroups);
        }
    }
}

