/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400UnsignedBin2
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 2;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 65535;
    private static final int defaultValue = 0;
    static /* synthetic */ Class class$java$lang$Integer;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return 2;
    }

    public Object getDefaultValue() {
        return new Integer(0);
    }

    public int getInstanceType() {
        return 10;
    }

    public Class getJavaType() {
        return class$java$lang$Integer == null ? (class$java$lang$Integer = AS400UnsignedBin2.class$("java.lang.Integer")) : class$java$lang$Integer;
    }

    public byte[] toBytes(Object object) {
        int n = (Integer)object;
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 4);
        }
        byte[] byArray = new byte[2];
        BinaryConverter.unsignedShortToByteArray(n, byArray, 0);
        return byArray;
    }

    public byte[] toBytes(int n) {
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("intValue (" + String.valueOf(n) + ")", 4);
        }
        byte[] byArray = new byte[2];
        BinaryConverter.unsignedShortToByteArray(n, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        int n = (Integer)object;
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 4);
        }
        BinaryConverter.unsignedShortToByteArray(n, byArray, 0);
        return 2;
    }

    public int toBytes(int n, byte[] byArray) {
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("intValue (" + String.valueOf(n) + ")", 4);
        }
        BinaryConverter.unsignedShortToByteArray(n, byArray, 0);
        return 2;
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        int n2 = (Integer)object;
        if (n2 < 0 || n2 > 65535) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 4);
        }
        BinaryConverter.unsignedShortToByteArray(n2, byArray, n);
        return 2;
    }

    public int toBytes(int n, byte[] byArray, int n2) {
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("intValue (" + String.valueOf(n) + ")", 4);
        }
        BinaryConverter.unsignedShortToByteArray(n, byArray, n2);
        return 2;
    }

    public int toInt(byte[] byArray) {
        return BinaryConverter.byteArrayToUnsignedShort(byArray, 0);
    }

    public int toInt(byte[] byArray, int n) {
        return BinaryConverter.byteArrayToUnsignedShort(byArray, n);
    }

    public Object toObject(byte[] byArray) {
        return new Integer(BinaryConverter.byteArrayToUnsignedShort(byArray, 0));
    }

    public Object toObject(byte[] byArray, int n) {
        return new Integer(BinaryConverter.byteArrayToUnsignedShort(byArray, n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

