/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLLocatorBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBlobLocator
extends SQLLocatorBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private SQLConversionSettings settings_;
    private int truncated_;
    private boolean outOfBounds_ = false;
    private int columnIndex_;
    private byte[] value_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;
    private Object savedValue_;
    private boolean inputStreamRead_ = false;

    SQLBlobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, false);
        this.maxLength_ = n2 == 0 ? Integer.MAX_VALUE : n2;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    public Object clone() {
        return new SQLBlobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
        this.value_ = null;
        this.savedValue_ = null;
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.convertFromRawBytes(byArray, n, convTable, false);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
        this.value_ = null;
        this.savedValue_ = null;
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null || this.value_ != null) {
            this.writeToServer();
        }
    }

    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.truncated_ = byArray.length > this.maxLength_ ? byArray.length - this.maxLength_ : 0;
        } else if (object instanceof String) {
            byte[] byArray = null;
            try {
                byArray = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
            object = byArray;
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        } else if (object instanceof Reader) {
            object = new HexReaderInputStream((Reader)object);
        } else if (!(object instanceof String || object instanceof Blob || object instanceof Reader || object instanceof InputStream)) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.savedObjectWrittenToServer_ = false;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        block22: {
            Object object = this.savedObject_;
            if (object instanceof byte[]) {
                this.value_ = (byte[])object;
                int n = this.value_.length;
                if (this.value_.length > this.maxLength_) {
                    byte[] byArray = new byte[this.maxLength_];
                    System.arraycopy(this.value_, 0, byArray, 0, this.maxLength_);
                    this.value_ = byArray;
                }
                this.truncated_ = n - this.value_.length;
                break block22;
            }
            if (object instanceof Blob) {
                int n;
                int n2;
                Blob blob;
                if (this.savedObject_ instanceof AS400JDBCBlobLocator) {
                    Blob blob2 = blob = (AS400JDBCBlobLocator)this.savedObject_;
                    synchronized (blob2) {
                        if (((AS400JDBCBlobLocator)blob).savedObject_ != null) {
                            this.savedObject_ = ((AS400JDBCBlobLocator)blob).savedObject_;
                            this.savedObjectWrittenToServer_ = false;
                            this.scale_ = ((AS400JDBCBlobLocator)blob).savedScale_;
                            ((AS400JDBCBlobLocator)blob).savedObject_ = null;
                            if (!(this.savedObject_ instanceof AS400JDBCBlobLocator)) {
                                this.doConversion();
                                return;
                            }
                        }
                    }
                }
                int n3 = n2 = (n = (int)(blob = (Blob)object).length()) < 0 ? Integer.MAX_VALUE : n;
                if (n2 > this.maxLength_) {
                    n2 = this.maxLength_;
                }
                this.value_ = blob.getBytes(1L, n2);
                this.truncated_ = n - n2;
                break block22;
            }
            if (object instanceof InputStream) {
                if (!this.inputStreamRead_) {
                    int n = this.scale_;
                    if (n >= 0) {
                        this.value_ = SQLLocatorBase.readInputStream((InputStream)object, n, null, false);
                        if (this.value_.length < n) {
                            JDError.throwSQLException((Object)this, "07006");
                        }
                        int n4 = this.value_.length;
                        if (this.value_.length > this.maxLength_) {
                            byte[] byArray = new byte[this.maxLength_];
                            System.arraycopy(this.value_, 0, byArray, 0, this.maxLength_);
                            this.value_ = byArray;
                        }
                        this.truncated_ = n4 - this.value_.length;
                    } else if (n == -2) {
                        this.value_ = SQLLocatorBase.readInputStream((InputStream)object, n, null, false);
                        this.inputStreamRead_ = true;
                        int n5 = this.value_.length;
                        if (this.value_.length > this.maxLength_) {
                            byte[] byArray = new byte[this.maxLength_];
                            System.arraycopy(this.value_, 0, byArray, 0, this.maxLength_);
                            this.value_ = byArray;
                        }
                        this.truncated_ = n5 - this.value_.length;
                    } else {
                        JDError.throwSQLException("07006");
                    }
                }
            } else {
                JDError.throwSQLException("07006");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToServer() throws SQLException {
        if (this.value_ != null) {
            this.locator_.writeData(0L, this.value_, true);
        } else if (this.savedObject_ instanceof byte[]) {
            byte[] byArray = (byte[])this.savedObject_;
            this.locator_.writeData(0L, byArray, true);
        } else if (this.savedObject_ instanceof InputStream) {
            int n = this.scale_;
            if (n == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (n > 0) {
                this.value_ = SQLLocatorBase.readInputStream((InputStream)this.savedObject_, n, this.locator_, false);
                if (this.value_.length < n) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (n == -2) {
                this.value_ = SQLLocatorBase.readInputStream((InputStream)this.savedObject_, n, this.locator_, false);
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (this.savedObject_ instanceof Blob) {
            Blob blob;
            boolean bl = false;
            if (this.savedObject_ instanceof AS400JDBCBlobLocator) {
                blob = (AS400JDBCBlobLocator)this.savedObject_;
                AS400JDBCBlobLocator aS400JDBCBlobLocator = blob;
                synchronized (aS400JDBCBlobLocator) {
                    if (((AS400JDBCBlobLocator)blob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCBlobLocator)blob).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCBlobLocator)blob).savedScale_;
                        ((AS400JDBCBlobLocator)blob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!bl) {
                blob = (Blob)this.savedObject_;
                int n = (int)blob.length();
                byte[] byArray = blob.getBytes(1L, n);
                this.locator_.writeData(0L, byArray, 0, n, true);
            }
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    public int getSQLType() {
        return 4;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCBlobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "BLOB";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 960;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2004;
    }

    public String getTypeName() {
        return "BLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public void clearTruncated() {
        this.truncated_ = 0;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCInputStream(new JDLobLocator(this.locator_));
    }

    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCBlob(this.value_, this.maxLength_);
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        int n = (int)this.locator_.getLength();
        if (n == 0) {
            return new byte[0];
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, n);
        int n2 = dBLobData.getLength();
        byte[] byArray = new byte[n2];
        System.arraycopy(dBLobData.getRawBytes(), dBLobData.getOffset(), byArray, 0, n2);
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return byArray;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
    }

    public void saveValue() throws SQLException {
        if (this.value_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }

    public Object getSavedValue() {
        return this.savedValue_;
    }
}

