/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.StorageService;

public class TokenRange {
    private final Token.TokenFactory tokenFactory;
    public final Range<Token> range;
    public final List<EndpointDetails> endpoints;

    private TokenRange(Token.TokenFactory tokenFactory, Range<Token> range, List<EndpointDetails> endpoints) {
        this.tokenFactory = tokenFactory;
        this.range = range;
        this.endpoints = endpoints;
    }

    private String toStr(Token tk) {
        return this.tokenFactory.toString(tk);
    }

    public static TokenRange create(Token.TokenFactory tokenFactory, Range<Token> range, List<InetAddressAndPort> endpoints, boolean withPorts) {
        ArrayList<EndpointDetails> details = new ArrayList<EndpointDetails>(endpoints.size());
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        for (InetAddressAndPort ep : endpoints) {
            details.add(new EndpointDetails(ep, StorageService.instance.getNativeaddress(ep, withPorts), snitch.getDatacenter(ep), snitch.getRack(ep)));
        }
        return new TokenRange(tokenFactory, range, details);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean withPorts) {
        StringBuilder sb = new StringBuilder("TokenRange(");
        sb.append("start_token:").append(this.toStr((Token)this.range.left));
        sb.append(", end_token:").append(this.toStr((Token)this.range.right));
        ArrayList<String> hosts = new ArrayList<String>(this.endpoints.size());
        ArrayList<String> rpcs = new ArrayList<String>(this.endpoints.size());
        ArrayList<String> endpointDetails = new ArrayList<String>(this.endpoints.size());
        for (EndpointDetails ep : this.endpoints) {
            hosts.add(ep.host.getHostAddress(withPorts));
            rpcs.add(ep.nativeAddress);
            endpointDetails.add(ep.toString(withPorts));
        }
        sb.append(", endpoints:").append(hosts);
        sb.append(", rpc_endpoints:").append(rpcs);
        sb.append(", endpoint_details:").append(endpointDetails);
        sb.append(")");
        return sb.toString();
    }

    public static class EndpointDetails {
        public final InetAddressAndPort host;
        public final String nativeAddress;
        public final String datacenter;
        public final String rack;

        private EndpointDetails(InetAddressAndPort host, String nativeAddress, String datacenter, String rack) {
            assert (host != null);
            this.host = host;
            this.nativeAddress = nativeAddress;
            this.datacenter = datacenter;
            this.rack = rack;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean withPorts) {
            String dcStr = this.datacenter == null ? "" : String.format(", datacenter:%s", this.datacenter);
            String rackStr = this.rack == null ? "" : String.format(", rack:%s", this.rack);
            return String.format("EndpointDetails(host:%s%s%s)", this.host.getHostAddress(withPorts), dcStr, rackStr);
        }
    }
}

