/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import org.apache.beam.repackaged.direct_java.runners.core.MergingStateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.ReduceFn;
import org.apache.beam.repackaged.direct_java.runners.core.StateAccessor;
import org.apache.beam.repackaged.direct_java.runners.core.StateMerging;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class NonEmptyPanes<@UnknownKeyFor K, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> {
    static <K, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized NonEmptyPanes<K, W> create(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> strategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ReduceFn<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> reduceFn) {
        if (strategy.getMode() == WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES) {
            return new DiscardingModeNonEmptyPanes(reduceFn);
        }
        return new GeneralNonEmptyPanes();
    }

    public abstract void recordContent(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> var1);

    public abstract void clearPane(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> var1);

    public abstract @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> var1);

    public abstract void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> var1);

    public abstract void onMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> var1);

    private static class GeneralNonEmptyPanes<@UnknownKeyFor K, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends NonEmptyPanes<K, W> {
        private static final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long>> PANE_ADDITIONS_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("count", VarLongCoder.of(), Sum.ofLongs()));

        private GeneralNonEmptyPanes() {
        }

        @Override
        public void recordContent(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
            state.access(PANE_ADDITIONS_TAG).add((Object)1L);
        }

        @Override
        public void clearPane(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
            state.access(PANE_ADDITIONS_TAG).clear();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
            return state.access(PANE_ADDITIONS_TAG).isEmpty();
        }

        @Override
        public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> state) {
            StateMerging.prefetchCombiningValues(state, PANE_ADDITIONS_TAG);
        }

        @Override
        public void onMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> context) {
            StateMerging.mergeCombiningValues(context, PANE_ADDITIONS_TAG);
        }
    }

    private static class DiscardingModeNonEmptyPanes<@UnknownKeyFor K, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends NonEmptyPanes<K, W> {
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ReduceFn<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> reduceFn;

        private DiscardingModeNonEmptyPanes(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ReduceFn<K, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> reduceFn) {
            this.reduceFn = reduceFn;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
            return this.reduceFn.isEmpty(state);
        }

        @Override
        public void recordContent(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
        }

        @Override
        public void clearPane(@UnknownKeyFor @NonNull @Initialized StateAccessor<K> state) {
        }

        @Override
        public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> state) {
        }

        @Override
        public void onMerge(@UnknownKeyFor @NonNull @Initialized MergingStateAccessor<K, W> context) {
        }
    }
}

