/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Iterator;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class SaxonImportQuery
extends StyleElement {
    private String href;
    private String moduleURI;

    public void importModule() throws XPathException {
        this.prepareAttributes();
        this.loadLibraryModule();
    }

    public void prepareAttributes() throws XPathException {
        if (this.href != null || this.moduleURI != null) {
            return;
        }
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string = this.getNamePool().getClarkName(n);
            if (string == "href") {
                this.href = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string == "namespace") {
                this.moduleURI = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
            this.moduleURI = "";
        }
        if (this.href == null && this.moduleURI == null) {
            this.compileError("At least one of href or namespace must be specified");
            this.moduleURI = "";
        }
    }

    public void validate() throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    private void loadLibraryModule() throws XPathException {
        if (this.href == null && this.moduleURI == null) {
            return;
        }
        try {
            XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
            this.getExecutable().setFunctionLibrary(new ExecutableFunctionLibrary(this.getConfiguration()));
            StaticQueryContext staticQueryContext = this.loadModule();
            short s = staticQueryContext.getModuleNamespaceCode();
            NamePool namePool = this.getTargetNamePool();
            Iterator iterator = staticQueryContext.getGlobalFunctionLibrary().getFunctionDefinitions();
            while (iterator.hasNext()) {
                XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
                if (namePool.getURICode(xQueryFunction.getFunctionFingerprint()) != s) continue;
                xSLStylesheet.declareXQueryFunction(xQueryFunction);
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    private StaticQueryContext loadModule() throws XPathException {
        StreamSource[] streamSourceArray;
        ModuleURIResolver moduleURIResolver = this.getConfiguration().getModuleURIResolver();
        if (moduleURIResolver == null) {
            moduleURIResolver = this.getConfiguration().getStandardModuleURIResolver();
        }
        String[] stringArray = new String[]{this.href};
        try {
            streamSourceArray = moduleURIResolver.resolve(this.moduleURI, this.getBaseURI(), stringArray);
            if (streamSourceArray == null) {
                moduleURIResolver = this.getConfiguration().getStandardModuleURIResolver();
                streamSourceArray = moduleURIResolver.resolve(this.moduleURI, this.getBaseURI(), stringArray);
            }
        }
        catch (XPathException xPathException) {
            throw StaticError.makeStaticError(xPathException);
        }
        if (streamSourceArray.length != 1) {
            StaticError staticError = new StaticError("Query module resolver must return a single module");
            throw staticError;
        }
        StreamSource streamSource = streamSourceArray[0];
        String string = streamSource.getSystemId();
        if (string == null) {
            streamSource.setSystemId(stringArray[0]);
        }
        String string2 = QueryReader.readSourceQuery(streamSource, this.getConfiguration().getNameChecker());
        StaticQueryContext staticQueryContext = StaticQueryContext.makeStaticQueryContext(string, this.getExecutable(), null, string2, this.moduleURI);
        this.getExecutable().fixupQueryModules(staticQueryContext);
        return staticQueryContext;
    }

    public Expression compile(Executable executable) throws XPathException {
        executable.setReasonUnableToCompile("Cannot compile a stylesheet that imports an XQuery library module");
        return null;
    }
}

