/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.AutoValue_ReleaseInfo;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
@Internal
public abstract class ReleaseInfo
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized String PROPERTIES_PATH = "/org/apache/beam/sdk/sdk.properties";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ReleaseInfo.class);
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_NAME = "Apache Beam SDK for Java";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_VERSION = "Unknown";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_DOCKER_IMAGE_ROOT = "apache";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_DOCKER_IMAGE_PREFIX = "beam_";

    public static @UnknownKeyFor @NonNull @Initialized ReleaseInfo getReleaseInfo() {
        return LazyInit.INSTANCE;
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getProperties();

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.getProperties().get("name");
    }

    public @UnknownKeyFor @NonNull @Initialized String getVersion() {
        return this.getProperties().get("version");
    }

    public @UnknownKeyFor @NonNull @Initialized String getSdkVersion() {
        return this.getProperties().get("sdk_version");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDevSdkVersion() {
        return this.getProperties().get("sdk_version").contains("dev");
    }

    public @UnknownKeyFor @NonNull @Initialized String getDefaultDockerRepoRoot() {
        return this.getProperties().get("docker_image_default_repo_root");
    }

    public @UnknownKeyFor @NonNull @Initialized String getDefaultDockerRepoPrefix() {
        return this.getProperties().get("docker_image_default_repo_prefix");
    }

    private static class LazyInit {
        private static final @UnknownKeyFor @NonNull @Initialized ReleaseInfo INSTANCE;

        private LazyInit() {
        }

        static {
            Properties properties = new Properties();
            try (InputStream in = ReleaseInfo.class.getResourceAsStream(ReleaseInfo.PROPERTIES_PATH);){
                if (in == null) {
                    LOG.warn("Beam properties resource not found: {}", (Object)ReleaseInfo.PROPERTIES_PATH);
                } else {
                    properties.load(in);
                }
            }
            catch (IOException e) {
                LOG.warn("Error loading Beam properties resource: ", (Throwable)e);
            }
            if (!properties.containsKey("name")) {
                properties.setProperty("name", ReleaseInfo.DEFAULT_NAME);
            }
            if (!properties.containsKey("version")) {
                properties.setProperty("version", ReleaseInfo.DEFAULT_VERSION);
            }
            if (!properties.containsKey("sdk_version")) {
                properties.setProperty("sdk_version", ReleaseInfo.DEFAULT_VERSION);
            }
            if (!properties.containsKey("docker_image_default_repo_root")) {
                properties.setProperty("docker_image_default_repo_root", ReleaseInfo.DEFAULT_DOCKER_IMAGE_ROOT);
            }
            if (!properties.containsKey("docker_image_default_repo_prefix")) {
                properties.setProperty("docker_image_default_repo_prefix", ReleaseInfo.DEFAULT_DOCKER_IMAGE_PREFIX);
            }
            INSTANCE = new AutoValue_ReleaseInfo((Map<String, String>)ImmutableMap.copyOf((Map)properties));
        }
    }
}

