/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.ExposedByteArrayInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class StreamUtils {
    private static final @UnknownKeyFor @NonNull @Initialized int BUF_SIZE = 8192;
    private static @UnknownKeyFor @NonNull @Initialized ThreadLocal<@UnknownKeyFor @NonNull @Initialized SoftReference<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> threadLocalBuffer = new ThreadLocal();

    private StreamUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getBytesWithoutClosing(@UnknownKeyFor @NonNull @Initialized InputStream stream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int r;
        byte[] buffer;
        if (stream instanceof ExposedByteArrayInputStream) {
            return ((ExposedByteArrayInputStream)stream).readAll();
        }
        if (stream instanceof ByteArrayInputStream) {
            byte[] ret = new byte[stream.available()];
            stream.read(ret);
            return ret;
        }
        SoftReference<byte[]> refBuffer = threadLocalBuffer.get();
        byte[] byArray = buffer = refBuffer == null ? null : refBuffer.get();
        if (buffer == null) {
            buffer = new byte[8192];
            threadLocalBuffer.set(new SoftReference<byte[]>(buffer));
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        while ((r = stream.read(buffer)) != -1) {
            outStream.write(buffer, 0, r);
        }
        return outStream.toByteArray();
    }
}

