/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializerSnapshotData;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.LinkedOptionalMap;
import org.apache.flink.util.Preconditions;

@Internal
public class PojoSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    private static final int VERSION = 2;
    private PojoSerializerSnapshotData<T> snapshotData;

    public PojoSerializerSnapshot() {
    }

    PojoSerializerSnapshot(Class<T> pojoClass, Field[] fields, TypeSerializer<?>[] fieldSerializers, LinkedHashMap<Class<?>, TypeSerializer<?>> registeredSubclassSerializers, Map<Class<?>, TypeSerializer<?>> nonRegisteredSubclassSerializers) {
        this.snapshotData = PojoSerializerSnapshotData.createFrom(pojoClass, fields, fieldSerializers, registeredSubclassSerializers, nonRegisteredSubclassSerializers);
    }

    PojoSerializerSnapshot(Class<T> pojoClass, Field[] fields, TypeSerializerSnapshot<?>[] existingFieldSerializerSnapshots, LinkedHashMap<Class<?>, TypeSerializerSnapshot<?>> existingRegisteredSubclassSerializerSnapshots, Map<Class<?>, TypeSerializerSnapshot<?>> existingNonRegisteredSubclassSerializerSnapshots) {
        this.snapshotData = PojoSerializerSnapshotData.createFrom(pojoClass, fields, existingFieldSerializerSnapshots, existingRegisteredSubclassSerializerSnapshots, existingNonRegisteredSubclassSerializerSnapshots);
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        this.snapshotData.writeSnapshotData(out);
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        Preconditions.checkArgument(readVersion == 2, "unrecognized read version %s", readVersion);
        this.snapshotData = PojoSerializerSnapshotData.createFrom(in, userCodeClassLoader);
    }

    @Override
    public TypeSerializer<T> restoreSerializer() {
        int numFields = this.snapshotData.getFieldSerializerSnapshots().size();
        ArrayList restoredFields = new ArrayList(numFields);
        ArrayList restoredFieldSerializers = new ArrayList(numFields);
        this.snapshotData.getFieldSerializerSnapshots().forEach((fieldName, field, fieldSerializerSnapshot) -> {
            restoredFields.add(field);
            Preconditions.checkState(fieldSerializerSnapshot != null, "field serializer snapshots should be present.");
            restoredFieldSerializers.add(fieldSerializerSnapshot.restoreSerializer());
        });
        LinkedHashMap<Class<?>, TypeSerializer<?>> registeredSubclassSerializers = PojoSerializerSnapshot.restoreSerializers(this.snapshotData.getRegisteredSubclassSerializerSnapshots().unwrapOptionals());
        Tuple2<LinkedHashMap<Class<?>, Integer>, TypeSerializer<Object>[]> decomposedSubclassSerializerRegistry = PojoSerializerSnapshot.decomposeSubclassSerializerRegistry(registeredSubclassSerializers);
        LinkedHashMap<Class<?>, TypeSerializer<?>> nonRegisteredSubclassSerializers = PojoSerializerSnapshot.restoreSerializers(this.snapshotData.getNonRegisteredSubclassSerializerSnapshots().unwrapOptionals());
        return new PojoSerializer<T>(this.snapshotData.getPojoClass(), restoredFields.toArray(new Field[numFields]), restoredFieldSerializers.toArray(new TypeSerializer[numFields]), (LinkedHashMap)decomposedSubclassSerializerRegistry.f0, (TypeSerializer[])decomposedSubclassSerializerRegistry.f1, nonRegisteredSubclassSerializers, new ExecutionConfig());
    }

    @Override
    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
        if (newSerializer.getClass() != PojoSerializer.class) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        PojoSerializer newPojoSerializer = (PojoSerializer)newSerializer;
        Class<T> previousPojoClass = this.snapshotData.getPojoClass();
        LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots = this.snapshotData.getFieldSerializerSnapshots();
        LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots = this.snapshotData.getRegisteredSubclassSerializerSnapshots();
        LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots = this.snapshotData.getNonRegisteredSubclassSerializerSnapshots();
        if (previousPojoClass != newPojoSerializer.getPojoClass()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        if (registeredSubclassSerializerSnapshots.hasAbsentKeysOrValues()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        if (nonRegisteredSubclassSerializerSnapshots.hasAbsentKeysOrValues()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingFieldSerializersCompatibility = PojoSerializerSnapshot.getCompatibilityOfPreExistingFields(newPojoSerializer, fieldSerializerSnapshots);
        if (preExistingFieldSerializersCompatibility.isIncompatible()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingRegistrationsCompatibility = PojoSerializerSnapshot.getCompatibilityOfPreExistingRegisteredSubclasses(newPojoSerializer, registeredSubclassSerializerSnapshots);
        if (preExistingRegistrationsCompatibility.isIncompatible()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        if (PojoSerializerSnapshot.newPojoSerializerIsCompatibleAfterMigration(newPojoSerializer, preExistingFieldSerializersCompatibility, preExistingRegistrationsCompatibility, fieldSerializerSnapshots)) {
            return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
        }
        if (PojoSerializerSnapshot.newPojoSerializerIsCompatibleWithReconfiguredSerializer(newPojoSerializer, preExistingFieldSerializersCompatibility, preExistingRegistrationsCompatibility, registeredSubclassSerializerSnapshots, nonRegisteredSubclassSerializerSnapshots)) {
            return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer(PojoSerializerSnapshot.constructReconfiguredPojoSerializer(newPojoSerializer, preExistingFieldSerializersCompatibility, registeredSubclassSerializerSnapshots, preExistingRegistrationsCompatibility, nonRegisteredSubclassSerializerSnapshots));
        }
        return TypeSerializerSchemaCompatibility.compatibleAsIs();
    }

    private static <K> LinkedHashMap<K, TypeSerializer<?>> restoreSerializers(LinkedHashMap<K, TypeSerializerSnapshot<?>> snapshotsMap) {
        LinkedHashMap restoredSerializersMap = new LinkedHashMap(snapshotsMap.size());
        snapshotsMap.forEach((key, snapshot) -> restoredSerializersMap.put(key, snapshot.restoreSerializer()));
        return restoredSerializersMap;
    }

    private static Tuple2<LinkedHashMap<Class<?>, Integer>, TypeSerializer<Object>[]> decomposeSubclassSerializerRegistry(LinkedHashMap<Class<?>, TypeSerializer<?>> subclassSerializerRegistry) {
        LinkedHashMap subclassIds = new LinkedHashMap(subclassSerializerRegistry.size());
        TypeSerializer[] subclassSerializers = new TypeSerializer[subclassSerializerRegistry.size()];
        subclassSerializerRegistry.forEach((registeredSubclassClass, serializer) -> {
            int id = subclassIds.size();
            subclassIds.put(registeredSubclassClass, id);
            subclassSerializers[id] = serializer;
        });
        return Tuple2.of(subclassIds, subclassSerializers);
    }

    private static <T> CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> getCompatibilityOfPreExistingFields(PojoSerializer<T> newPojoSerializer, LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots) {
        Set<LinkedOptionalMap.KeyValue<Field, TypeSerializerSnapshot<?>>> presentFieldSnapshots = fieldSerializerSnapshots.getPresentEntries();
        ArrayList associatedFieldSerializerSnapshots = new ArrayList(presentFieldSnapshots.size());
        ArrayList associatedNewFieldSerializers = new ArrayList(presentFieldSnapshots.size());
        Map<Field, TypeSerializer<?>> newFieldSerializersIndex = PojoSerializerSnapshot.buildNewFieldSerializersIndex(newPojoSerializer);
        for (LinkedOptionalMap.KeyValue<Field, TypeSerializerSnapshot<?>> presentFieldEntry : presentFieldSnapshots) {
            TypeSerializer<?> associatedNewFieldSerializer = newFieldSerializersIndex.get(presentFieldEntry.getKey());
            Preconditions.checkState(associatedNewFieldSerializer != null, "a present field should have its associated new field serializer available.");
            associatedFieldSerializerSnapshots.add(presentFieldEntry.getValue());
            associatedNewFieldSerializers.add(associatedNewFieldSerializer);
        }
        return CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult(associatedNewFieldSerializers.toArray(new TypeSerializer[associatedNewFieldSerializers.size()]), associatedFieldSerializerSnapshots.toArray(new TypeSerializerSnapshot[associatedFieldSerializerSnapshots.size()]));
    }

    private static <T> Map<Field, TypeSerializer<?>> buildNewFieldSerializersIndex(PojoSerializer<T> newPojoSerializer) {
        TypeSerializer<?>[] newFieldSerializers;
        Field[] newFields = newPojoSerializer.getFields();
        Preconditions.checkState(newFields.length == (newFieldSerializers = newPojoSerializer.getFieldSerializers()).length);
        int numFields = newFields.length;
        HashMap index = new HashMap(numFields);
        for (int i = 0; i < numFields; ++i) {
            index.put(newFields[i], newFieldSerializers[i]);
        }
        return index;
    }

    private static <T> CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> getCompatibilityOfPreExistingRegisteredSubclasses(PojoSerializer<T> newPojoSerializer, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots) {
        LinkedHashMap<Class<?>, TypeSerializerSnapshot<?>> unwrappedSerializerSnapshots = registeredSubclassSerializerSnapshots.unwrapOptionals();
        ArrayList associatedSubclassSerializerSnapshots = new ArrayList();
        ArrayList associatedNewSubclassSerializers = new ArrayList();
        LinkedHashMap<Class<?>, TypeSerializer<?>> newSubclassSerializerRegistry = newPojoSerializer.getBundledSubclassSerializerRegistry();
        for (Map.Entry<Class<?>, TypeSerializerSnapshot<?>> entry : unwrappedSerializerSnapshots.entrySet()) {
            TypeSerializer<?> newRegisteredSerializer = newSubclassSerializerRegistry.get(entry.getKey());
            if (newRegisteredSerializer == null) continue;
            associatedSubclassSerializerSnapshots.add(entry.getValue());
            associatedNewSubclassSerializers.add(newRegisteredSerializer);
        }
        return CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult(associatedNewSubclassSerializers.toArray(new TypeSerializer[associatedNewSubclassSerializers.size()]), associatedSubclassSerializerSnapshots.toArray(new TypeSerializerSnapshot[associatedSubclassSerializerSnapshots.size()]));
    }

    private static <T> boolean newPojoSerializerIsCompatibleAfterMigration(PojoSerializer<T> newPojoSerializer, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> fieldSerializerCompatibility, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingRegistrationsCompatibility, LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots) {
        return PojoSerializerSnapshot.newPojoHasNewOrRemovedFields(fieldSerializerSnapshots, newPojoSerializer) || fieldSerializerCompatibility.isCompatibleAfterMigration() || preExistingRegistrationsCompatibility.isCompatibleAfterMigration();
    }

    private static <T> boolean newPojoSerializerIsCompatibleWithReconfiguredSerializer(PojoSerializer<T> newPojoSerializer, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> fieldSerializerCompatibility, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingRegistrationsCompatibility, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots) {
        return PojoSerializerSnapshot.newPojoHasDifferentSubclassRegistrationOrder(registeredSubclassSerializerSnapshots, newPojoSerializer) || PojoSerializerSnapshot.previousSerializerHasNonRegisteredSubclasses(nonRegisteredSubclassSerializerSnapshots) || fieldSerializerCompatibility.isCompatibleWithReconfiguredSerializer() || preExistingRegistrationsCompatibility.isCompatibleWithReconfiguredSerializer();
    }

    private static boolean newPojoHasNewOrRemovedFields(LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots, PojoSerializer<?> newPojoSerializer) {
        int numRemovedFields = fieldSerializerSnapshots.absentKeysOrValues().size();
        int numPreexistingFields = fieldSerializerSnapshots.size() - numRemovedFields;
        boolean hasRemovedFields = numRemovedFields > 0;
        boolean hasNewFields = newPojoSerializer.getFields().length - numPreexistingFields > 0;
        return hasRemovedFields || hasNewFields;
    }

    private static boolean newPojoHasDifferentSubclassRegistrationOrder(LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots, PojoSerializer<?> newPojoSerializer) {
        Set<Class<?>> newRegistrationOrder;
        Set<Class<?>> previousRegistrationOrder = registeredSubclassSerializerSnapshots.unwrapOptionals().keySet();
        return !PojoSerializerSnapshot.isPreviousRegistrationPrefixOfNewRegistration(previousRegistrationOrder, newRegistrationOrder = newPojoSerializer.getRegisteredClasses().keySet());
    }

    private static boolean isPreviousRegistrationPrefixOfNewRegistration(Set<Class<?>> previousRegistrationOrder, Set<Class<?>> newRegistrationOrder) {
        Iterator<Class<?>> newRegistrationItr = newRegistrationOrder.iterator();
        for (Class<?> previousRegisteredClass : previousRegistrationOrder) {
            if (!newRegistrationItr.hasNext()) {
                return false;
            }
            Class<?> newRegisteredClass = newRegistrationItr.next();
            if (previousRegisteredClass.equals(newRegisteredClass)) continue;
            return false;
        }
        return true;
    }

    private static boolean previousSerializerHasNonRegisteredSubclasses(LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots) {
        return nonRegisteredSubclassSerializerSnapshots.size() > 0;
    }

    private static <T> PojoSerializer<T> constructReconfiguredPojoSerializer(PojoSerializer<T> originalNewPojoSerializer, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> fieldSerializerCompatibility, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSerializerSnapshots, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<T> preExistingRegistrationsCompatibility, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots) {
        TypeSerializer[] reconfiguredFieldSerializers = PojoSerializerSnapshot.constructReconfiguredFieldSerializers(fieldSerializerCompatibility);
        Tuple2<LinkedHashMap<Class<?>, Integer>, TypeSerializer<Object>[]> reconfiguredSubclassRegistry = PojoSerializerSnapshot.constructReconfiguredSubclassRegistry(originalNewPojoSerializer.getBundledSubclassSerializerRegistry(), registeredSerializerSnapshots, preExistingRegistrationsCompatibility);
        return new PojoSerializer<T>(originalNewPojoSerializer.getPojoClass(), originalNewPojoSerializer.getFields(), reconfiguredFieldSerializers, (LinkedHashMap)reconfiguredSubclassRegistry.f0, (TypeSerializer[])reconfiguredSubclassRegistry.f1, PojoSerializerSnapshot.restoreSerializers(nonRegisteredSubclassSerializerSnapshots.unwrapOptionals()), originalNewPojoSerializer.getExecutionConfig());
    }

    private static TypeSerializer[] constructReconfiguredFieldSerializers(CompositeTypeSerializerUtil.IntermediateCompatibilityResult<?> fieldSerializerCompatibility) {
        Preconditions.checkArgument(!fieldSerializerCompatibility.isIncompatible() && !fieldSerializerCompatibility.isCompatibleAfterMigration());
        return fieldSerializerCompatibility.getNestedSerializers();
    }

    private static Tuple2<LinkedHashMap<Class<?>, Integer>, TypeSerializer<Object>[]> constructReconfiguredSubclassRegistry(LinkedHashMap<Class<?>, TypeSerializer<?>> newSubclassRegistrations, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSerializerSnapshots, CompositeTypeSerializerUtil.IntermediateCompatibilityResult<?> preExistingRegistrationsCompatibility) {
        Preconditions.checkArgument(!preExistingRegistrationsCompatibility.isIncompatible() && !preExistingRegistrationsCompatibility.isCompatibleAfterMigration());
        LinkedHashMap<Class<?>, TypeSerializer<?>> reconfiguredSubclassSerializerRegistry = PojoSerializerSnapshot.restoreSerializers(registeredSerializerSnapshots.unwrapOptionals());
        Iterator<TypeSerializer<?>> serializersForPreexistingRegistrations = Arrays.asList(preExistingRegistrationsCompatibility.getNestedSerializers()).iterator();
        for (Map.Entry<Class<?>, TypeSerializer<?>> oldRegistration : reconfiguredSubclassSerializerRegistry.entrySet()) {
            if (!newSubclassRegistrations.containsKey(oldRegistration.getKey())) continue;
            oldRegistration.setValue(serializersForPreexistingRegistrations.next());
        }
        for (Map.Entry<Class<?>, TypeSerializer<?>> newRegistration : newSubclassRegistrations.entrySet()) {
            TypeSerializer<?> oldRegistration = reconfiguredSubclassSerializerRegistry.get(newRegistration.getKey());
            if (oldRegistration != null) continue;
            reconfiguredSubclassSerializerRegistry.put(newRegistration.getKey(), newRegistration.getValue());
        }
        return PojoSerializerSnapshot.decomposeSubclassSerializerRegistry(reconfiguredSubclassSerializerRegistry);
    }
}

