/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.translation.GroupNonMergingWindowsFunctions;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.runners.spark.util.SparkSideInputReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.spark.api.java.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public class SparkCombineFn<InputT, ValueT, AccumT, OutputT>
implements Serializable {
    private final boolean globalCombine;
    private final SerializablePipelineOptions options;
    private final Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs;
    final WindowingStrategy<?, BoundedWindow> windowingStrategy;
    private final Function<InputT, ValueT> toValue;
    private final WindowedAccumulator.Type defaultNonMergingCombineStrategy;
    private final CombineWithContext.CombineFnWithContext<ValueT, AccumT, OutputT> combineFn;
    private final Comparator<BoundedWindow> windowComparator;
    private transient SparkCombineContext combineContext;

    @VisibleForTesting
    static <K, V, AccumT, OutputT> SparkCombineFn<KV<K, V>, V, AccumT, OutputT> keyed(CombineWithContext.CombineFnWithContext<V, AccumT, OutputT> combineFn, SerializablePipelineOptions options, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs, WindowingStrategy<?, ?> windowingStrategy, WindowedAccumulator.Type nonMergingStrategy) {
        return new SparkCombineFn(false, KV::getValue, combineFn, options, sideInputs, windowingStrategy, nonMergingStrategy);
    }

    public static <K, V, AccumT, OutputT> SparkCombineFn<KV<K, V>, V, AccumT, OutputT> keyed(CombineWithContext.CombineFnWithContext<V, AccumT, OutputT> combineFn, SerializablePipelineOptions options, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs, WindowingStrategy<?, ?> windowingStrategy) {
        return new SparkCombineFn(false, KV::getValue, combineFn, options, sideInputs, windowingStrategy);
    }

    public static <InputT, AccumT, OutputT> SparkCombineFn<InputT, InputT, AccumT, OutputT> globally(CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn, SerializablePipelineOptions options, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs, WindowingStrategy<?, ?> windowingStrategy) {
        return new SparkCombineFn<InputT, InputT, AccumT, OutputT>(true, (Function & Serializable)e -> e, combineFn, options, sideInputs, windowingStrategy);
    }

    private static <T> Map<BoundedWindow, WindowedValue<T>> asMap(Iterable<WindowedValue<T>> values, Map<BoundedWindow, WindowedValue<T>> res) {
        for (WindowedValue<T> v : values) {
            res.put(SparkCombineFn.getWindow(v), v);
        }
        return res;
    }

    private static Comparator<BoundedWindow> asWindowComparator(@Nullable TypeDescriptor<?> windowType) {
        Comparator<Object> comparator;
        if (windowType != null && StreamSupport.stream(windowType.getInterfaces().spliterator(), false).anyMatch(t -> t.isSubtypeOf(TypeDescriptor.of(Comparable.class)))) {
            comparator = Comparator.naturalOrder();
        } else {
            java.util.function.Function keyExtractor = BoundedWindow::maxTimestamp;
            comparator = Comparator.comparing(keyExtractor);
        }
        return comparator;
    }

    SparkCombineFn(boolean global, Function<InputT, ValueT> toValue, CombineWithContext.CombineFnWithContext<ValueT, AccumT, OutputT> combineFn, SerializablePipelineOptions options, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs, WindowingStrategy<?, ?> windowingStrategy) {
        this(global, toValue, combineFn, options, sideInputs, windowingStrategy, WindowedAccumulator.Type.EXPLODE_WINDOWS);
    }

    @VisibleForTesting
    SparkCombineFn(boolean global, Function<InputT, ValueT> toValue, CombineWithContext.CombineFnWithContext<ValueT, AccumT, OutputT> combineFn, SerializablePipelineOptions options, Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs, WindowingStrategy<?, ?> windowingStrategy, WindowedAccumulator.Type defaultNonMergingCombineStrategy) {
        this.globalCombine = global;
        this.options = options;
        this.sideInputs = sideInputs;
        WindowingStrategy<?, ?> castStrategy = windowingStrategy;
        this.windowingStrategy = castStrategy;
        this.toValue = toValue;
        this.defaultNonMergingCombineStrategy = defaultNonMergingCombineStrategy;
        this.combineFn = combineFn;
        TypeDescriptor untyped = windowingStrategy.getWindowFn().getWindowTypeDescriptor();
        this.windowComparator = SparkCombineFn.asWindowComparator(untyped);
    }

    WindowedAccumulator<InputT, ValueT, AccumT, ?> createCombiner() {
        return WindowedAccumulator.create(this, this.toValue, this.windowingStrategy, this.windowComparator);
    }

    WindowedAccumulator<InputT, ValueT, AccumT, ?> createCombiner(WindowedValue<InputT> value) {
        try {
            WindowedAccumulator accumulator = WindowedAccumulator.create(this, this.toValue, this.windowingStrategy, this.windowComparator);
            accumulator.add(value, this);
            return accumulator;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    WindowedAccumulator<InputT, ValueT, AccumT, ?> mergeValue(WindowedAccumulator<InputT, ValueT, AccumT, ?> accumulator, WindowedValue<InputT> value) {
        try {
            accumulator.add(value, this);
            return accumulator;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    WindowedAccumulator<InputT, ValueT, AccumT, ?> mergeCombiners(WindowedAccumulator ac1, WindowedAccumulator ac2) {
        try {
            ac1.merge(ac2, this);
            return ac1;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    Iterable<WindowedValue<OutputT>> extractOutput(WindowedAccumulator<?, ?, AccumT, ?> accumulator) {
        return this.extractOutputStream(accumulator).collect(Collectors.toList());
    }

    public Stream<WindowedValue<OutputT>> extractOutputStream(WindowedAccumulator<?, ?, AccumT, ?> accumulator) {
        return accumulator.extractOutput().stream().filter(Objects::nonNull).map(windowAcc -> windowAcc.withValue(this.combineFn.extractOutput(windowAcc.getValue(), (CombineWithContext.Context)this.ctxtForValue((WindowedValue<?>)windowAcc))));
    }

    WindowedAccumulatorCoder<InputT, ValueT, AccumT> accumulatorCoder(Coder<BoundedWindow> windowCoder, Coder<AccumT> accumulatorCoder, WindowingStrategy<?, ?> windowingStrategy) {
        return new WindowedAccumulatorCoder<InputT, ValueT, AccumT>(this.toValue, windowCoder, this.windowComparator, accumulatorCoder, this.getType(windowingStrategy));
    }

    CombineWithContext.CombineFnWithContext<ValueT, AccumT, OutputT> getCombineFn() {
        return this.combineFn;
    }

    boolean mustBringWindowToKey() {
        return !this.getType(this.windowingStrategy).isMapBased();
    }

    private WindowedAccumulator.Type getType(WindowingStrategy<?, ?> windowingStrategy) {
        if (!windowingStrategy.needsMerge()) {
            if (this.globalCombine) {
                return WindowedAccumulator.Type.NON_MERGING;
            }
            if (windowingStrategy.getWindowFn().assignsToOneWindow() && GroupNonMergingWindowsFunctions.isEligibleForGroupByWindow(windowingStrategy)) {
                return WindowedAccumulator.Type.SINGLE_WINDOW;
            }
            return this.defaultNonMergingCombineStrategy;
        }
        return WindowedAccumulator.Type.MERGING;
    }

    private static BoundedWindow getWindow(WindowedValue<?> value) {
        if (value.isSingleWindowedValue()) {
            return ((WindowedValue.SingleWindowedValue)value).getWindow();
        }
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)value.getWindows());
    }

    SparkCombineContext ctxtForValue(WindowedValue<?> input) {
        return this.ctxtForWindows(input.getWindows());
    }

    SparkCombineContext ctxtForWindows(Collection<BoundedWindow> windows) {
        if (this.combineContext == null) {
            this.combineContext = new SparkCombineContext(this.options.get(), new SparkSideInputReader(this.sideInputs));
        }
        return this.combineContext.forInput(windows);
    }

    static class SparkCombineContext
    extends CombineWithContext.Context {
        private final PipelineOptions pipelineOptions;
        private final SideInputReader sideInputReader;
        Collection<? extends BoundedWindow> windows = null;

        SparkCombineContext(PipelineOptions pipelineOptions, SideInputReader sideInputReader) {
            this.pipelineOptions = pipelineOptions;
            this.sideInputReader = sideInputReader;
        }

        SparkCombineContext forInput(Collection<? extends BoundedWindow> windows) {
            this.windows = Objects.requireNonNull(windows);
            return this;
        }

        public PipelineOptions getPipelineOptions() {
            return this.pipelineOptions;
        }

        public <T> T sideInput(PCollectionView<T> view) {
            Preconditions.checkState((this.windows.size() == 1 ? 1 : 0) != 0, (Object)"sideInput can only be called when the main input element is in exactly one window");
            return (T)this.sideInputReader.get(view, this.windows.iterator().next());
        }
    }

    static class WindowedAccumulatorCoder<InputT, ValueT, AccumT>
    extends Coder<WindowedAccumulator<InputT, ValueT, AccumT, ?>> {
        private final Function<InputT, ValueT> toValue;
        private final IterableCoder<WindowedValue<AccumT>> wrap;
        private final Coder<WindowedValue<AccumT>> accumCoder;
        private final Comparator<BoundedWindow> windowComparator;
        private final WindowedAccumulator.Type type;

        WindowedAccumulatorCoder(Function<InputT, ValueT> toValue, Coder<BoundedWindow> windowCoder, Comparator<BoundedWindow> windowComparator, Coder<AccumT> accumCoder, WindowedAccumulator.Type type) {
            this.toValue = toValue;
            this.accumCoder = WindowedValue.FullWindowedValueCoder.of(accumCoder, windowCoder);
            this.windowComparator = windowComparator;
            this.wrap = IterableCoder.of(this.accumCoder);
            this.type = type;
        }

        public void encode(WindowedAccumulator<InputT, ValueT, AccumT, ?> value, OutputStream outStream) throws CoderException, IOException {
            if (this.type.isMapBased()) {
                this.wrap.encode(((MapBasedWindowedAccumulator)value).map.values(), outStream);
            } else {
                SingleWindowWindowedAccumulator swwa = (SingleWindowWindowedAccumulator)value;
                if (swwa.isEmpty()) {
                    outStream.write(0);
                } else {
                    outStream.write(1);
                    this.accumCoder.encode((Object)WindowedValue.of(swwa.windowAccumulator, (Instant)swwa.accTimestamp, (BoundedWindow)swwa.accWindow, (PaneInfo)PaneInfo.NO_FIRING), outStream);
                }
            }
        }

        public WindowedAccumulator<InputT, ValueT, AccumT, ?> decode(InputStream inStream) throws CoderException, IOException {
            boolean empty;
            if (this.type.isMapBased()) {
                return WindowedAccumulator.create(this.toValue, this.type, this.wrap.decode(inStream), this.windowComparator);
            }
            boolean bl = empty = inStream.read() == 0;
            if (empty) {
                return WindowedAccumulator.create(this.toValue, this.type, this.windowComparator);
            }
            return WindowedAccumulator.create(this.toValue, this.type, Arrays.asList((WindowedValue)this.accumCoder.decode(inStream)), this.windowComparator);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return this.wrap.getComponents();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    }

    static class MergingWindowedAccumulator<InputT, ValueT, AccumT>
    extends MapBasedWindowedAccumulator<InputT, ValueT, AccumT, MergingWindowedAccumulator<InputT, ValueT, AccumT>> {
        static <InputT, ValueT, AccumT> MergingWindowedAccumulator<InputT, ValueT, AccumT> create(Function<InputT, ValueT> toValue, Comparator<BoundedWindow> windowComparator) {
            return new MergingWindowedAccumulator<InputT, ValueT, AccumT>(toValue, windowComparator);
        }

        static <InputT, ValueT, AccumT> MergingWindowedAccumulator<InputT, ValueT, AccumT> from(Function<InputT, ValueT> toValue, Iterable<WindowedValue<AccumT>> values, Comparator<BoundedWindow> windowComparator) {
            return new MergingWindowedAccumulator<InputT, ValueT, AccumT>(toValue, values, windowComparator);
        }

        private MergingWindowedAccumulator(Function<InputT, ValueT> toValue, Comparator<BoundedWindow> windowComparator) {
            super(toValue, new TreeMap(windowComparator));
        }

        private MergingWindowedAccumulator(Function<InputT, ValueT> toValue, Iterable<WindowedValue<AccumT>> values, Comparator<BoundedWindow> windowComparator) {
            super(toValue, SparkCombineFn.asMap(values, new TreeMap(windowComparator)));
        }

        @Override
        void mergeWindows(SparkCombineFn<?, ?, AccumT, ?> fn) throws Exception {
            SparkCombineContext ctx = fn.ctxtForWindows(this.map.keySet());
            WindowFn windowFn = fn.windowingStrategy.getWindowFn();
            windowFn.mergeWindows(this.asMergeContext((WindowFn<Object, BoundedWindow>)windowFn, (a, b) -> fn.combineFn.mergeAccumulators((Iterable)Lists.newArrayList((Object[])new Object[]{a, b}), (CombineWithContext.Context)ctx), (toBeMerged, mergeResult) -> {
                Instant mergedInstant = fn.windowingStrategy.getTimestampCombiner().merge((BoundedWindow)mergeResult.getKey(), (Iterable)toBeMerged.stream().map(w -> ((WindowedValue)this.map.get(w)).getTimestamp()).collect(Collectors.toList()));
                toBeMerged.forEach(this.map::remove);
                this.map.put((BoundedWindow)mergeResult.getKey(), WindowedValue.of((Object)mergeResult.getValue(), (Instant)mergedInstant, (BoundedWindow)((BoundedWindow)mergeResult.getKey()), (PaneInfo)PaneInfo.NO_FIRING));
            }, this.map));
        }

        private WindowFn.MergeContext asMergeContext(WindowFn<Object, BoundedWindow> windowFn, final BiFunction<AccumT, AccumT, AccumT> mergeFn, final BiConsumer<Collection<BoundedWindow>, KV<BoundedWindow, AccumT>> afterMerge, final Map<BoundedWindow, WindowedValue<AccumT>> map) {
            WindowFn<Object, BoundedWindow> windowFn2 = windowFn;
            Objects.requireNonNull(windowFn2);
            return new WindowFn.MergeContext(windowFn2){

                public Collection<BoundedWindow> windows() {
                    return map.keySet();
                }

                public void merge(Collection<BoundedWindow> toBeMerged, BoundedWindow mergeResult) {
                    Object accumulator = null;
                    for (BoundedWindow w : toBeMerged) {
                        WindowedValue windowAccumulator = Objects.requireNonNull((WindowedValue)map.get(w));
                        if (accumulator == null) {
                            accumulator = windowAccumulator.getValue();
                            continue;
                        }
                        accumulator = mergeFn.apply(accumulator, windowAccumulator.getValue());
                    }
                    afterMerge.accept(toBeMerged, KV.of((Object)mergeResult, accumulator));
                }
            };
        }

        public String toString() {
            return "MergingWindowedAccumulator(" + this.map + ")";
        }
    }

    static class NonMergingWindowedAccumulator<InputT, ValueT, AccumT>
    extends MapBasedWindowedAccumulator<InputT, ValueT, AccumT, NonMergingWindowedAccumulator<InputT, ValueT, AccumT>> {
        static <InputT, ValueT, AccumT> NonMergingWindowedAccumulator<InputT, ValueT, AccumT> create(Function<InputT, ValueT> toValue) {
            return new NonMergingWindowedAccumulator<InputT, ValueT, AccumT>(toValue);
        }

        static <InputT, ValueT, AccumT> NonMergingWindowedAccumulator<InputT, ValueT, AccumT> from(Function<InputT, ValueT> toValue, Iterable<WindowedValue<AccumT>> values) {
            return new NonMergingWindowedAccumulator<InputT, ValueT, AccumT>(toValue, values);
        }

        private NonMergingWindowedAccumulator(Function<InputT, ValueT> toValue) {
            super(toValue, new HashMap());
        }

        private NonMergingWindowedAccumulator(Function<InputT, ValueT> toValue, Iterable<WindowedValue<AccumT>> values) {
            super(toValue, SparkCombineFn.asMap(values, new HashMap()));
        }
    }

    static abstract class MapBasedWindowedAccumulator<InputT, ValueT, AccumT, ImplT extends MapBasedWindowedAccumulator<InputT, ValueT, AccumT, ImplT>>
    implements WindowedAccumulator<InputT, ValueT, AccumT, ImplT> {
        final Function<InputT, ValueT> toValue;
        final Map<BoundedWindow, WindowedValue<AccumT>> map;

        MapBasedWindowedAccumulator(Function<InputT, ValueT> toValue, Map<BoundedWindow, WindowedValue<AccumT>> map) {
            this.toValue = toValue;
            this.map = map;
        }

        @Override
        public void add(WindowedValue<InputT> value, SparkCombineFn<InputT, ValueT, AccumT, ?> context) throws Exception {
            for (WindowedValue v : value.explodeWindows()) {
                SparkCombineContext ctx = context.ctxtForValue(v);
                BoundedWindow window = SparkCombineFn.getWindow(v);
                TimestampCombiner combiner = context.windowingStrategy.getTimestampCombiner();
                Instant windowTimestamp = combiner.assign(window, v.getTimestamp());
                this.map.compute(window, (w, windowAccumulator) -> {
                    Instant timestamp;
                    Object acc;
                    if (windowAccumulator == null) {
                        acc = ((SparkCombineFn)context).combineFn.createAccumulator((CombineWithContext.Context)ctx);
                        timestamp = windowTimestamp;
                    } else {
                        acc = windowAccumulator.getValue();
                        timestamp = windowAccumulator.getTimestamp();
                    }
                    Object result = ((SparkCombineFn)context).combineFn.addInput(acc, this.toValue(v), (CombineWithContext.Context)ctx);
                    Instant timestampCombined = combiner.combine(new Instant[]{windowTimestamp, timestamp});
                    return WindowedValue.of((Object)result, (Instant)timestampCombined, (BoundedWindow)window, (PaneInfo)PaneInfo.NO_FIRING);
                });
            }
            this.mergeWindows(context);
        }

        @Override
        public void merge(ImplT other, SparkCombineFn<?, ?, AccumT, ?> context) throws Exception {
            ((MapBasedWindowedAccumulator)other).map.forEach((window, acc) -> {
                WindowedValue<AccumT> thisAcc = this.map.get(window);
                if (thisAcc == null) {
                    this.map.put((BoundedWindow)window, (WindowedValue<AccumT>)acc);
                } else {
                    this.map.put((BoundedWindow)window, (WindowedValue<AccumT>)WindowedValue.of((Object)((SparkCombineFn)context).combineFn.mergeAccumulators((Iterable)Lists.newArrayList((Object[])new Object[]{thisAcc.getValue(), acc.getValue()}), (CombineWithContext.Context)context.ctxtForValue((WindowedValue<?>)acc)), (Instant)context.windowingStrategy.getTimestampCombiner().combine(new Instant[]{acc.getTimestamp(), thisAcc.getTimestamp()}), (BoundedWindow)window, (PaneInfo)PaneInfo.NO_FIRING));
                }
            });
            this.mergeWindows(context);
        }

        @Override
        public Collection<WindowedValue<AccumT>> extractOutput() {
            return this.map.values();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        void mergeWindows(SparkCombineFn<?, ?, AccumT, ?> fn) throws Exception {
        }

        private ValueT toValue(WindowedValue<InputT> value) {
            try {
                return (ValueT)this.toValue.call(value.getValue());
            }
            catch (Exception ex) {
                throw UserCodeException.wrap((Throwable)ex);
            }
        }
    }

    static class SingleWindowWindowedAccumulator<InputT, ValueT, AccumT>
    implements WindowedAccumulator<InputT, ValueT, AccumT, SingleWindowWindowedAccumulator<InputT, ValueT, AccumT>> {
        final Function<InputT, ValueT> toValue;
        AccumT windowAccumulator = null;
        Instant accTimestamp = null;
        BoundedWindow accWindow = null;

        static <InputT, ValueT, AccumT> SingleWindowWindowedAccumulator<InputT, ValueT, AccumT> create(Function<InputT, ValueT> toValue) {
            return new SingleWindowWindowedAccumulator<InputT, ValueT, AccumT>(toValue);
        }

        static <InputT, ValueT, AccumT> WindowedAccumulator<InputT, ValueT, AccumT, ?> create(Function<InputT, ValueT> toValue, WindowedValue<AccumT> accumulator) {
            return new SingleWindowWindowedAccumulator<InputT, ValueT, AccumT>(toValue, accumulator);
        }

        SingleWindowWindowedAccumulator(Function<InputT, ValueT> toValue) {
            this.toValue = toValue;
        }

        SingleWindowWindowedAccumulator(Function<InputT, ValueT> toValue, WindowedValue<AccumT> accumulator) {
            this.toValue = toValue;
            this.windowAccumulator = accumulator.getValue();
            this.accTimestamp = accumulator.getTimestamp().equals((Object)BoundedWindow.TIMESTAMP_MIN_VALUE) ? null : accumulator.getTimestamp();
            this.accWindow = SparkCombineFn.getWindow(accumulator);
        }

        @Override
        public void add(WindowedValue<InputT> value, SparkCombineFn<InputT, ValueT, AccumT, ?> context) throws Exception {
            Instant timestamp;
            Object acc;
            BoundedWindow window = SparkCombineFn.getWindow(value);
            SparkCombineContext ctx = context.ctxtForValue(value);
            TimestampCombiner combiner = context.windowingStrategy.getTimestampCombiner();
            Instant windowTimestamp = combiner.assign(window, value.getTimestamp());
            if (this.windowAccumulator == null) {
                acc = ((SparkCombineFn)context).combineFn.createAccumulator((CombineWithContext.Context)ctx);
                timestamp = windowTimestamp;
            } else {
                acc = this.windowAccumulator;
                timestamp = this.accTimestamp;
            }
            Object result = ((SparkCombineFn)context).combineFn.addInput(acc, this.toValue(value), (CombineWithContext.Context)ctx);
            Instant timestampCombined = combiner.combine(new Instant[]{windowTimestamp, timestamp});
            this.windowAccumulator = result;
            this.accTimestamp = timestampCombined;
            this.accWindow = window;
        }

        @Override
        public void merge(SingleWindowWindowedAccumulator<InputT, ValueT, AccumT> other, SparkCombineFn<?, ?, AccumT, ?> context) {
            if (this.windowAccumulator != null && other.windowAccumulator != null) {
                List<Object> accumulators = Arrays.asList(this.windowAccumulator, other.windowAccumulator);
                Object merged = ((SparkCombineFn)context).combineFn.mergeAccumulators(accumulators, (CombineWithContext.Context)context.ctxtForWindows(Arrays.asList(this.accWindow)));
                Instant combined = context.windowingStrategy.getTimestampCombiner().combine(new Instant[]{this.accTimestamp, other.accTimestamp});
                this.windowAccumulator = merged;
                this.accTimestamp = combined;
            } else if (this.windowAccumulator == null) {
                this.windowAccumulator = other.windowAccumulator;
                this.accTimestamp = other.accTimestamp;
                this.accWindow = other.accWindow;
            }
        }

        @Override
        public Collection<WindowedValue<AccumT>> extractOutput() {
            if (this.windowAccumulator != null) {
                return Arrays.asList(WindowedValue.of(this.windowAccumulator, (Instant)this.accTimestamp, (BoundedWindow)this.accWindow, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING));
            }
            return Collections.emptyList();
        }

        private ValueT toValue(WindowedValue<InputT> input) {
            try {
                return (ValueT)this.toValue.call(input.getValue());
            }
            catch (Exception ex) {
                throw UserCodeException.wrap((Throwable)ex);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.windowAccumulator == null;
        }
    }

    public static interface WindowedAccumulator<InputT, ValueT, AccumT, ImplT extends WindowedAccumulator<InputT, ValueT, AccumT, ImplT>> {
        public boolean isEmpty();

        public void add(WindowedValue<InputT> var1, SparkCombineFn<InputT, ValueT, AccumT, ?> var2) throws Exception;

        public void merge(ImplT var1, SparkCombineFn<?, ?, AccumT, ?> var2) throws Exception;

        public Collection<WindowedValue<AccumT>> extractOutput();

        public static <InputT, ValueT, AccumT> WindowedAccumulator<InputT, ValueT, AccumT, ?> create(SparkCombineFn<InputT, ValueT, AccumT, ?> context, Function<InputT, ValueT> toValue, WindowingStrategy<?, ?> windowingStrategy, Comparator<BoundedWindow> windowComparator) {
            return WindowedAccumulator.create(toValue, ((SparkCombineFn)context).getType(windowingStrategy), windowComparator);
        }

        public static <InputT, ValueT, AccumT> WindowedAccumulator<InputT, ValueT, AccumT, ?> create(Function<InputT, ValueT> toValue, Type type, Comparator<BoundedWindow> windowComparator) {
            switch (type) {
                case MERGING: {
                    return MergingWindowedAccumulator.create(toValue, windowComparator);
                }
                case NON_MERGING: {
                    return NonMergingWindowedAccumulator.create(toValue);
                }
                case SINGLE_WINDOW: 
                case EXPLODE_WINDOWS: {
                    return SingleWindowWindowedAccumulator.create(toValue);
                }
            }
            throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
        }

        public static <InputT, ValueT, AccumT> WindowedAccumulator<InputT, ValueT, AccumT, ?> create(Function<InputT, ValueT> toValue, Type type, Iterable<WindowedValue<AccumT>> values, Comparator<BoundedWindow> windowComparator) {
            switch (type) {
                case MERGING: {
                    return MergingWindowedAccumulator.from(toValue, values, windowComparator);
                }
                case NON_MERGING: {
                    return NonMergingWindowedAccumulator.from(toValue, values);
                }
                case SINGLE_WINDOW: 
                case EXPLODE_WINDOWS: {
                    Iterator<WindowedValue<AccumT>> iter = values.iterator();
                    if (iter.hasNext()) {
                        return SingleWindowWindowedAccumulator.create(toValue, iter.next());
                    }
                    return SingleWindowWindowedAccumulator.create(toValue);
                }
            }
            throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
        }

        public static enum Type {
            MERGING,
            NON_MERGING,
            EXPLODE_WINDOWS,
            SINGLE_WINDOW;


            boolean isMapBased() {
                return this == NON_MERGING || this == MERGING;
            }
        }
    }
}

