/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.storage.model.Bucket;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.extensions.gcp.auth.GcpCredentialFactory;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.options.CloudResourceManagerOptions;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.options.GoogleApiDebugOptions;
import org.apache.beam.sdk.extensions.gcp.storage.PathValidator;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Options used to configure Google Cloud Platform project and credentials.")
public interface GcpOptions
extends GoogleApiDebugOptions,
PipelineOptions {
    public static final @UnknownKeyFor @NonNull @Initialized String STREAMING_ENGINE_EXPERIMENT = "enable_streaming_engine";
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String WINDMILL_SERVICE_EXPERIMENT = "enable_windmill_service";

    @Description(value="Project id. Required when using Google Cloud Platform services. See https://cloud.google.com/storage/docs/projects for further details.")
    @Default.InstanceFactory(value=DefaultProjectFactory.class)
    public @UnknownKeyFor @NonNull @Initialized String getProject();

    public void setProject(@UnknownKeyFor @NonNull @Initialized String var1);

    @Deprecated
    @Description(value="GCP availability zone for running GCP operations. and GCE availability zone for launching workers Default is up to the individual service. This option is deprecated, and will be replaced by workerZone.")
    public @UnknownKeyFor @NonNull @Initialized String getZone();

    @Deprecated
    public void setZone(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. \"us-west1\". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to same value as region.")
    public @UnknownKeyFor @NonNull @Initialized String getWorkerRegion();

    public void setWorkerRegion(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. \"us-west1-a\". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, the Dataflow service will choose a zone in region based on available capacity.")
    public @UnknownKeyFor @NonNull @Initialized String getWorkerZone();

    public void setWorkerZone(@UnknownKeyFor @NonNull @Initialized String var1);

    @Default.InstanceFactory(value=GcpOAuthScopesFactory.class)
    @Description(value="Controls the OAuth scopes that will be requested when creating credentials with the GcpCredentialFactory (which is the default credential factory). If the GCP credential or credential factory have been set then this property may do nothing.")
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getGcpOauthScopes();

    public void setGcpOauthScopes(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

    @Description(value="The class of the credential factory that should be created and used to create credentials. If gcpCredential has not been set explicitly, an instance of this class will be constructed and used as a credential factory.")
    @Default.Class(value=GcpCredentialFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CredentialFactory> getCredentialFactoryClass();

    public void setCredentialFactoryClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CredentialFactory> var1);

    @JsonIgnore
    @Description(value="The credential instance that should be used to authenticate against GCP services. If no credential has been set explicitly, the default is to use the instance factory that constructs a credential based upon the currently set credentialFactoryClass.")
    @Default.InstanceFactory(value=GcpUserCredentialsFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Credentials getGcpCredential();

    public void setGcpCredential(@UnknownKeyFor @NonNull @Initialized Credentials var1);

    @Description(value="All API requests will be made as the given service account or target service account in an impersonation delegation chain instead of the currently selected account. You can specify either a single service account as the impersonator, or a comma-separated list of service accounts to create an impersonation delegation chain.")
    @JsonIgnore
    public @Nullable @UnknownKeyFor @Initialized String getImpersonateServiceAccount();

    public void setImpersonateServiceAccount(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="If true will use Streaming Engine.  Defaults to false unless the experiments enable_streaming_engine or enable_windmill_service are set.")
    @Default.InstanceFactory(value=EnableStreamingEngineFactory.class)
    public @UnknownKeyFor @NonNull @Initialized boolean isEnableStreamingEngine();

    public void setEnableStreamingEngine(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="A GCS path for storing temporary files in GCP.")
    @Default.InstanceFactory(value=GcpTempLocationFactory.class)
    public @Nullable @UnknownKeyFor @Initialized String getGcpTempLocation();

    public void setGcpTempLocation(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="GCP Cloud KMS key for Dataflow pipelines. Also used by gcpTempLocation as the default key for new buckets. Key format is: projects/<project>/locations/<location>/keyRings/<keyring>/cryptoKeys/<key>")
    public @Nullable @UnknownKeyFor @Initialized String getDataflowKmsKey();

    public void setDataflowKmsKey(@UnknownKeyFor @NonNull @Initialized String var1);

    public static class GcpTempLocationFactory
    implements DefaultValueFactory<String> {
        private static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(Duration.millis((long)200L));
        static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_REGION = "us-central1";
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GcpTempLocationFactory.class);

        public @Nullable @UnknownKeyFor @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            String tempLocation = options.getTempLocation();
            if (Strings.isNullOrEmpty((String)tempLocation)) {
                tempLocation = GcpTempLocationFactory.tryCreateDefaultBucket(options, GcpTempLocationFactory.newCloudResourceManagerClient((CloudResourceManagerOptions)options.as(CloudResourceManagerOptions.class)).build());
                options.setTempLocation(tempLocation);
            } else {
                try {
                    PathValidator validator = ((GcsOptions)options.as(GcsOptions.class)).getPathValidator();
                    validator.validateOutputFilePrefixSupported(tempLocation);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Error constructing default value for gcpTempLocation: tempLocation is not a valid GCS path, %s. ", tempLocation), e);
                }
            }
            return tempLocation;
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized String tryCreateDefaultBucket(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized CloudResourceManager crmClient) {
            GcsOptions gcsOptions = (GcsOptions)options.as(GcsOptions.class);
            Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)gcsOptions.getDataflowKmsKey()), (Object)"Cannot create a default bucket when --dataflowKmsKey is set.");
            String projectId = gcsOptions.getProject();
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"--project is a required option.");
            long projectNumber = 0L;
            try {
                projectNumber = GcpTempLocationFactory.getProjectNumber(projectId, crmClient);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to verify project with ID " + projectId, e);
            }
            String region = DEFAULT_REGION;
            if (!Strings.isNullOrEmpty((String)gcsOptions.getZone())) {
                region = GcpTempLocationFactory.getRegionFromZone(gcsOptions.getZone());
            }
            String bucketName = "dataflow-staging-" + region + "-" + projectNumber;
            LOG.info("No tempLocation specified, attempting to use default bucket: {}", (Object)bucketName);
            Bucket bucket = new Bucket().setName(bucketName).setLocation(region);
            try {
                gcsOptions.getGcsUtil().createBucket(projectId, bucket);
            }
            catch (FileAlreadyExistsException e) {
                LOG.debug("Bucket '{}'' already exists, verifying access.", (Object)bucketName);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable create default bucket.", e);
            }
            try {
                long owner = gcsOptions.getGcsUtil().bucketOwner(GcsPath.fromComponents(bucketName, ""));
                Preconditions.checkArgument((owner == projectNumber ? 1 : 0) != 0, (String)"Bucket owner does not match the project from --project: %s vs. %s", (long)owner, (long)projectNumber);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to determine the owner of the default bucket at gs://" + bucketName, e);
            }
            return "gs://" + bucketName + "/temp/";
        }

        private static @UnknownKeyFor @NonNull @Initialized long getProjectNumber(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized CloudResourceManager crmClient) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return GcpTempLocationFactory.getProjectNumber(projectId, crmClient, BackOffAdapter.toGcpBackOff(BACKOFF_FACTORY.backoff()), Sleeper.DEFAULT);
        }

        private static @UnknownKeyFor @NonNull @Initialized long getProjectNumber(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized CloudResourceManager crmClient, @UnknownKeyFor @NonNull @Initialized BackOff backoff, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) throws @UnknownKeyFor @NonNull @Initialized IOException {
            CloudResourceManager.Projects.Get getProject = crmClient.projects().get(projectId);
            try {
                Project project = (Project)ResilientOperation.retry(() -> ((CloudResourceManager.Projects.Get)getProject).execute(), (BackOff)backoff, (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class, (Sleeper)sleeper);
                return project.getProjectNumber();
            }
            catch (Exception e) {
                throw new IOException("Unable to get project number", e);
            }
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized String getRegionFromZone(@UnknownKeyFor @NonNull @Initialized String zone) {
            String[] zoneParts = zone.split("-", -1);
            Preconditions.checkArgument((zoneParts.length >= 2 ? 1 : 0) != 0, (String)"Invalid zone provided: %s", (Object)zone);
            return zoneParts[0] + "-" + zoneParts[1];
        }

        @VisibleForTesting
        static // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized CloudResourceManager.Builder newCloudResourceManagerClient(@UnknownKeyFor @NonNull @Initialized CloudResourceManagerOptions options) {
            Credentials credentials = options.getGcpCredential();
            if (credentials == null) {
                NullCredentialInitializer.throwNullCredentialException();
            }
            return new CloudResourceManager.Builder(Transport.getTransport(), Transport.getJsonFactory(), GcpTempLocationFactory.chainHttpRequestInitializer(credentials, new RetryHttpRequestInitializer((Collection<Integer>)ImmutableList.of((Object)404)))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
        }

        private static @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer chainHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized Credentials credential, @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer httpRequestInitializer) {
            if (credential == null) {
                return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new NullCredentialInitializer(), httpRequestInitializer});
            }
            return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
        }
    }

    public static class EnableStreamingEngineFactory
    implements DefaultValueFactory<Boolean> {
        public @UnknownKeyFor @NonNull @Initialized Boolean create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)GcpOptions.STREAMING_ENGINE_EXPERIMENT) || ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)GcpOptions.WINDMILL_SERVICE_EXPERIMENT);
        }
    }

    public static class GcpUserCredentialsFactory
    implements DefaultValueFactory<Credentials> {
        public @UnknownKeyFor @NonNull @Initialized Credentials create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            GcpOptions gcpOptions = (GcpOptions)options.as(GcpOptions.class);
            try {
                CredentialFactory factory = (CredentialFactory)InstanceBuilder.ofType(CredentialFactory.class).fromClass(gcpOptions.getCredentialFactoryClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, (Object)options).build();
                return factory.getCredential();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Unable to obtain credential", e);
            }
        }
    }

    public static class DefaultProjectFactory
    implements DefaultValueFactory<String> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DefaultProjectFactory.class);

        public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                File configFile;
                if (this.getEnvironment().containsKey("CLOUDSDK_CONFIG")) {
                    configFile = new File(this.getEnvironment().get("CLOUDSDK_CONFIG"), "properties");
                } else if (DefaultProjectFactory.isWindows() && this.getEnvironment().containsKey("APPDATA")) {
                    configFile = new File(this.getEnvironment().get("APPDATA"), "gcloud/properties");
                } else {
                    configFile = new File(System.getProperty("user.home"), ".config/gcloud/configurations/config_default");
                    if (!configFile.exists()) {
                        configFile = new File(System.getProperty("user.home"), ".config/gcloud/properties");
                    }
                }
                String section = null;
                Pattern projectPattern = Pattern.compile("^project\\s*=\\s*(.*)$");
                Pattern sectionPattern = Pattern.compile("^\\[(.*)\\]$");
                for (String line : Files.readLines((File)configFile, (Charset)StandardCharsets.UTF_8)) {
                    if ((line = line.trim()).isEmpty() || line.startsWith(";")) continue;
                    Matcher matcher = sectionPattern.matcher(line);
                    if (matcher.matches()) {
                        section = matcher.group(1);
                        continue;
                    }
                    if (section != null && !"core".equals(section) || !(matcher = projectPattern.matcher(line)).matches()) continue;
                    String project = matcher.group(1).trim();
                    LOG.info("Inferred default GCP project '{}' from gcloud. If this is the incorrect project, please cancel this Pipeline and specify the command-line argument --project.", (Object)project);
                    return project;
                }
            }
            catch (IOException expected) {
                LOG.debug("Failed to find default project.", (Throwable)expected);
            }
            return null;
        }

        private static @UnknownKeyFor @NonNull @Initialized boolean isWindows() {
            return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getEnvironment() {
            return System.getenv();
        }
    }

    public static class GcpOAuthScopesFactory
    implements DefaultValueFactory<List<String>> {
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return Arrays.asList("https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/devstorage.full_control", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/datastore", "https://www.googleapis.com/auth/bigquery", "https://www.googleapis.com/auth/bigquery.insertdata", "https://www.googleapis.com/auth/pubsub");
        }
    }
}

