/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.BatchOptions;
import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventDataBatch;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubClientOptions;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.EventHubRuntimeInformation;
import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventhubs.ITokenProvider;
import com.microsoft.azure.eventhubs.OperationCancelledException;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.PartitionRuntimeInformation;
import com.microsoft.azure.eventhubs.PartitionSender;
import com.microsoft.azure.eventhubs.ProxyConfiguration;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.impl.AmqpException;
import com.microsoft.azure.eventhubs.impl.ClientConstants;
import com.microsoft.azure.eventhubs.impl.ClientEntity;
import com.microsoft.azure.eventhubs.impl.EventDataBatchImpl;
import com.microsoft.azure.eventhubs.impl.EventDataImpl;
import com.microsoft.azure.eventhubs.impl.EventDataUtil;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.IteratorUtil;
import com.microsoft.azure.eventhubs.impl.MessageSender;
import com.microsoft.azure.eventhubs.impl.MessagingFactory;
import com.microsoft.azure.eventhubs.impl.PartitionReceiverImpl;
import com.microsoft.azure.eventhubs.impl.PartitionSenderImpl;
import com.microsoft.azure.eventhubs.impl.SchedulerProvider;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.eventhubs.impl.TimeoutTracker;
import com.microsoft.azure.eventhubs.impl.Timer;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;

public final class EventHubClientImpl
extends ClientEntity
implements EventHubClient {
    public static String USER_AGENT = null;
    private final String eventHubName;
    private final Object senderCreateSync;
    private volatile boolean isSenderCreateStarted;
    private volatile MessagingFactory underlyingFactory;
    private volatile MessageSender sender;
    private volatile Timer timer;
    private CompletableFuture<Void> createSender;

    private EventHubClientImpl(String eventHubName, ScheduledExecutorService executor) {
        super(StringUtil.getRandomString("EC"), null, executor);
        this.eventHubName = eventHubName;
        this.senderCreateSync = new Object();
    }

    public static CompletableFuture<EventHubClient> create(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ProxyConfiguration proxyConfiguration) throws IOException {
        return EventHubClientImpl.create(connectionString, retryPolicy, executor, proxyConfiguration, EventHubClientOptions.SILENT_OFF);
    }

    public static CompletableFuture<EventHubClient> create(String connectionString, RetryPolicy retryPolicy, ScheduledExecutorService executor, ProxyConfiguration proxyConfiguration, Duration watchdogTriggerTime) throws IOException {
        if (StringUtil.isNullOrWhiteSpace(connectionString)) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        Objects.requireNonNull(executor, "Executor cannot be null.");
        ConnectionStringBuilder connStr = new ConnectionStringBuilder(connectionString);
        final EventHubClientImpl eventHubClient = new EventHubClientImpl(connStr.getEventHubName(), executor);
        return MessagingFactory.createFromConnectionString(connectionString, retryPolicy, executor, proxyConfiguration, watchdogTriggerTime).thenApplyAsync(new Function<MessagingFactory, EventHubClient>(){

            @Override
            public EventHubClient apply(MessagingFactory factory) {
                eventHubClient.underlyingFactory = factory;
                eventHubClient.timer = new Timer(factory);
                return eventHubClient;
            }
        }, (Executor)executor);
    }

    public static CompletableFuture<EventHubClient> create(URI endpoint, String eventHubName, ITokenProvider tokenProvider, ScheduledExecutorService executor, EventHubClientOptions options) throws IOException {
        if (StringUtil.isNullOrWhiteSpace(endpoint.getHost())) {
            throw new IllegalArgumentException("Endpoint must contain a hostname");
        }
        if (StringUtil.isNullOrWhiteSpace(eventHubName)) {
            throw new IllegalArgumentException("Event hub name cannot be null or empty");
        }
        Objects.requireNonNull(tokenProvider, "Token provider cannot be null.");
        MessagingFactory.MessagingFactoryBuilder builder = new MessagingFactory.MessagingFactoryBuilder(endpoint.getHost(), tokenProvider, executor);
        if (options != null) {
            builder.setOperationTimeout(options.getOperationTimeout()).setTransportType(options.getTransportType()).setRetryPolicy(options.getRetryPolicy()).setProxyConfiguration(options.getProxyConfiguration()).setWatchdogTriggerTime(options.getMaximumSilentTime());
        }
        return EventHubClientImpl.create(eventHubName, executor, builder.build());
    }

    static CompletableFuture<EventHubClient> create(String eventHubName, ScheduledExecutorService executor, CompletableFuture<MessagingFactory> messagingFactory) {
        if (StringUtil.isNullOrWhiteSpace(eventHubName)) {
            throw new IllegalArgumentException("Event hub name cannot be null or empty");
        }
        return messagingFactory.thenApplyAsync(factory -> {
            EventHubClientImpl eventHubClient = new EventHubClientImpl(eventHubName, executor);
            eventHubClient.underlyingFactory = factory;
            eventHubClient.timer = new Timer((SchedulerProvider)factory);
            return eventHubClient;
        }, (Executor)executor);
    }

    @Override
    public String getEventHubName() {
        return this.eventHubName;
    }

    @Override
    public EventDataBatch createBatch(BatchOptions options) throws EventHubException {
        return ExceptionUtil.sync(() -> {
            int maxSize = (Integer)((CompletableFuture)this.createInternalSender().thenApplyAsync(aVoid -> this.sender.getMaxMessageSize(), (Executor)this.executor)).get();
            if (options.maxMessageSize == null) {
                return new EventDataBatchImpl(maxSize, options.partitionKey);
            }
            if (options.maxMessageSize > maxSize) {
                throw new IllegalArgumentException("The maxMessageSize set in BatchOptions is too large. You set a maxMessageSize of " + options.maxMessageSize + ". The maximum allowed size is " + maxSize + ".");
            }
            return new EventDataBatchImpl(options.maxMessageSize, options.partitionKey);
        });
    }

    @Override
    public CompletableFuture<Void> send(final EventData data) {
        if (data == null) {
            throw new IllegalArgumentException("EventData cannot be empty.");
        }
        return this.createInternalSender().thenCompose(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClientImpl.this.sender.send(((EventDataImpl)data).toAmqpMessage());
            }
        });
    }

    @Override
    public CompletableFuture<Void> send(final Iterable<EventData> eventDatas) {
        if (eventDatas == null || IteratorUtil.sizeEquals(eventDatas, 0)) {
            throw new IllegalArgumentException("Empty batch of EventData cannot be sent.");
        }
        return this.createInternalSender().thenCompose(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClientImpl.this.sender.send(EventDataUtil.toAmqpMessages(eventDatas));
            }
        });
    }

    @Override
    public CompletableFuture<Void> send(EventDataBatch eventDatas) {
        if (eventDatas == null || Integer.compare(eventDatas.getSize(), 0) == 0) {
            throw new IllegalArgumentException("Empty batch of EventData cannot be sent.");
        }
        EventDataBatchImpl eventDataBatch = (EventDataBatchImpl)eventDatas;
        return eventDataBatch.getPartitionKey() != null ? this.send(eventDataBatch.getInternalIterable(), eventDataBatch.getPartitionKey()) : this.send(eventDataBatch.getInternalIterable());
    }

    @Override
    public CompletableFuture<Void> send(final EventData eventData, final String partitionKey) {
        if (eventData == null) {
            throw new IllegalArgumentException("EventData cannot be null.");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey cannot be null.");
        }
        return this.createInternalSender().thenCompose(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClientImpl.this.sender.send(((EventDataImpl)eventData).toAmqpMessage(partitionKey));
            }
        });
    }

    @Override
    public CompletableFuture<Void> send(final Iterable<EventData> eventDatas, final String partitionKey) {
        if (eventDatas == null || IteratorUtil.sizeEquals(eventDatas, 0)) {
            throw new IllegalArgumentException("Empty batch of EventData cannot be sent.");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey cannot be null.");
        }
        if (partitionKey.length() > 128) {
            throw new IllegalArgumentException(String.format(Locale.US, "PartitionKey exceeds the maximum allowed length of partitionKey: %s", 128));
        }
        return this.createInternalSender().thenCompose(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClientImpl.this.sender.send(EventDataUtil.toAmqpMessages(eventDatas, partitionKey));
            }
        });
    }

    @Override
    public CompletableFuture<PartitionSender> createPartitionSender(String partitionId) throws EventHubException {
        return PartitionSenderImpl.create(this.underlyingFactory, this.eventHubName, partitionId, this.executor);
    }

    @Override
    public CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, EventPosition eventPosition) throws EventHubException {
        return this.createReceiver(consumerGroupName, partitionId, eventPosition, null);
    }

    @Override
    public CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, EventPosition eventPosition, ReceiverOptions receiverOptions) throws EventHubException {
        return PartitionReceiverImpl.create(this.underlyingFactory, this.eventHubName, consumerGroupName, partitionId, eventPosition, 0L, false, receiverOptions, this.executor);
    }

    @Override
    public CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, EventPosition eventPosition, long epoch) throws EventHubException {
        return this.createEpochReceiver(consumerGroupName, partitionId, eventPosition, epoch, null);
    }

    @Override
    public CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, EventPosition eventPosition, long epoch, ReceiverOptions receiverOptions) throws EventHubException {
        return PartitionReceiverImpl.create(this.underlyingFactory, this.eventHubName, consumerGroupName, partitionId, eventPosition, epoch, true, receiverOptions, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> onClose() {
        if (this.underlyingFactory != null) {
            Object object = this.senderCreateSync;
            synchronized (object) {
                CompletableFuture<Void> internalSenderClose = this.sender != null ? this.sender.close().thenCompose(new Function<Void, CompletableFuture<Void>>(){

                    @Override
                    public CompletableFuture<Void> apply(Void voidArg) {
                        return EventHubClientImpl.this.underlyingFactory.close();
                    }
                }) : this.underlyingFactory.close();
                return internalSenderClose;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> createInternalSender() {
        if (!this.isSenderCreateStarted) {
            Object object = this.senderCreateSync;
            synchronized (object) {
                if (!this.isSenderCreateStarted) {
                    String senderName = StringUtil.getRandomString("EC").concat("_" + this.underlyingFactory.getClientId()).concat("-InternalSender");
                    this.createSender = MessageSender.create(this.underlyingFactory, senderName, this.eventHubName).thenAcceptAsync((Consumer)new Consumer<MessageSender>(){

                        @Override
                        public void accept(MessageSender a) {
                            EventHubClientImpl.this.sender = a;
                        }
                    }, (Executor)this.executor);
                    this.isSenderCreateStarted = true;
                }
            }
        }
        return this.createSender;
    }

    @Override
    public CompletableFuture<EventHubRuntimeInformation> getRuntimeInformation() {
        this.throwIfClosed();
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("type", "com.microsoft:eventhub");
        request.put("name", this.eventHubName);
        request.put("operation", "READ");
        return ((CompletableFuture)this.addManagementToken(request).thenCompose(requestWithToken -> this.managementWithRetry((Map<String, Object>)requestWithToken))).thenApplyAsync(rawdata -> new EventHubRuntimeInformation((String)rawdata.get("name"), ((Date)rawdata.get("created_at")).toInstant(), (Integer)rawdata.get("partition_count"), (String[])rawdata.get("partition_ids")), (Executor)this.executor);
    }

    @Override
    public CompletableFuture<PartitionRuntimeInformation> getPartitionRuntimeInformation(String partitionId) {
        this.throwIfClosed();
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("type", "com.microsoft:partition");
        request.put("name", this.eventHubName);
        request.put("partition", partitionId);
        request.put("operation", "READ");
        return ((CompletableFuture)this.addManagementToken(request).thenCompose(requestWithToken -> this.managementWithRetry((Map<String, Object>)requestWithToken))).thenApplyAsync(rawdata -> new PartitionRuntimeInformation((String)rawdata.get("name"), (String)rawdata.get("partition"), (Long)rawdata.get("begin_sequence_number"), (Long)rawdata.get("last_enqueued_sequence_number"), (String)rawdata.get("last_enqueued_offset"), ((Date)rawdata.get("last_enqueued_time_utc")).toInstant(), (Boolean)rawdata.get("is_partition_empty")), (Executor)this.executor);
    }

    private CompletableFuture<Map<String, Object>> addManagementToken(Map<String, Object> request) {
        String audience = String.format(Locale.US, "amqp://%s/%s", this.underlyingFactory.getHostName(), this.eventHubName);
        return this.underlyingFactory.getTokenProvider().getToken(audience, ClientConstants.TOKEN_REFRESH_INTERVAL).thenApplyAsync(securityToken -> {
            request.put("security_token", securityToken.getToken());
            return request;
        }, (Executor)this.executor);
    }

    private CompletableFuture<Map<String, Object>> managementWithRetry(Map<String, Object> request) {
        CompletableFuture<Map<String, Object>> rawdataFuture = new CompletableFuture<Map<String, Object>>();
        ManagementRetry retrier = new ManagementRetry(rawdataFuture, new TimeoutTracker(this.underlyingFactory.getOperationTimeout(), true), this.underlyingFactory, request);
        CompletableFuture<?> scheduledTask = this.timer.schedule(retrier, Duration.ZERO);
        if (scheduledTask.isCompletedExceptionally()) {
            rawdataFuture.completeExceptionally(ExceptionUtil.getExceptionFromCompletedFuture(scheduledTask));
        }
        return rawdataFuture;
    }

    private class ManagementRetry
    implements Runnable {
        private final CompletableFuture<Map<String, Object>> finalFuture;
        private final TimeoutTracker timeoutTracker;
        private final MessagingFactory mf;
        private final Map<String, Object> request;

        ManagementRetry(CompletableFuture<Map<String, Object>> future, TimeoutTracker timeoutTracker, MessagingFactory mf, Map<String, Object> request) {
            this.finalFuture = future;
            this.timeoutTracker = timeoutTracker;
            this.mf = mf;
            this.request = request;
        }

        @Override
        public void run() {
            long timeLeft = this.timeoutTracker.remaining().toMillis();
            CompletableFuture<Map<String, Object>> intermediateFuture = this.mf.getManagementChannel().request(this.mf.getReactorDispatcher(), this.request, timeLeft > 0L ? timeLeft : 0L);
            intermediateFuture.whenComplete((result, error) -> {
                if (result != null && error == null) {
                    this.finalFuture.complete((Map<String, Object>)result);
                } else {
                    Throwable completeWith;
                    Exception lastException;
                    if (error == null) {
                        lastException = new EventHubException(true, "timed out");
                        completeWith = null;
                    } else if (error instanceof Exception) {
                        lastException = error instanceof EventHubException ? (EventHubException)error : (error instanceof AmqpException ? ExceptionUtil.toException(((AmqpException)error).getError()) : (error instanceof CompletionException || error instanceof ExecutionException ? ExceptionUtil.stripOuterException((Exception)error) : (Exception)error));
                        completeWith = lastException;
                    } else {
                        lastException = new Exception("got a throwable: " + error.toString());
                        completeWith = error;
                    }
                    if (this.mf.getIsClosingOrClosed()) {
                        this.finalFuture.completeExceptionally(new OperationCancelledException("OperationCancelled as the underlying client instance was closed.", (Throwable)lastException));
                    } else {
                        Duration waitTime = this.mf.getRetryPolicy().getNextRetryInterval(this.mf.getClientId(), lastException, this.timeoutTracker.remaining());
                        if (waitTime == null) {
                            if (completeWith == null) {
                                this.finalFuture.complete(null);
                            } else {
                                this.finalFuture.completeExceptionally(completeWith);
                            }
                        } else {
                            ManagementRetry retrier = new ManagementRetry(this.finalFuture, this.timeoutTracker, this.mf, this.request);
                            EventHubClientImpl.this.timer.schedule(retrier, waitTime);
                        }
                    }
                }
            });
        }
    }
}

