/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.api.resource.ResourceDiscoveryPlugin;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ResourceAllocation;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceRequest;
import org.apache.spark.resource.ResourceRequirement;
import org.apache.spark.resource.TaskResourceRequest;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.util.Utils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class ResourceUtils$
implements Logging {
    public static ResourceUtils$ MODULE$;
    private final String DISCOVERY_SCRIPT;
    private final String VENDOR;
    private final String AMOUNT;
    private final String GPU;
    private final String FPGA;
    private final String RESOURCE_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String DISCOVERY_SCRIPT() {
        return this.DISCOVERY_SCRIPT;
    }

    public String VENDOR() {
        return this.VENDOR;
    }

    public String AMOUNT() {
        return this.AMOUNT;
    }

    public ResourceRequest parseResourceRequest(SparkConf sparkConf, ResourceID resourceId) {
        Map settings = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(resourceId.confPrefix()))).toMap(Predef$.MODULE$.$conforms());
        int amount = new StringOps(Predef$.MODULE$.augmentString((String)settings.getOrElse((Object)this.AMOUNT(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(31).append("You must specify an amount for ").append(resourceId.resourceName()).toString());
        }))).toInt();
        Optional<Object> discoveryScript = Optional.ofNullable(settings.get((Object)this.DISCOVERY_SCRIPT()).orNull(Predef$.MODULE$.$conforms()));
        Optional<Object> vendor = Optional.ofNullable(settings.get((Object)this.VENDOR()).orNull(Predef$.MODULE$.$conforms()));
        return new ResourceRequest(resourceId, amount, discoveryScript, vendor);
    }

    public Seq<ResourceID> listResourceIds(SparkConf sparkConf, String componentName) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(new StringBuilder(2).append(componentName).append(".").append(this.RESOURCE_PREFIX()).append(".").toString()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                int index = key.indexOf(46);
                if (index < 0) {
                    throw new SparkException(new StringBuilder(59).append("You must specify an amount config for resource: ").append(key).append(" ").append("config: ").append(componentName).append(".").append(MODULE$.RESOURCE_PREFIX()).append(".").append(key).toString());
                }
                return key.substring(0, index);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct())).map((Function1 & Serializable & scala.Serializable)name -> new ResourceID(componentName, (String)name), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<ResourceRequest> parseAllResourceRequests(SparkConf sparkConf, String componentName) {
        return (Seq)((TraversableLike)this.listResourceIds(sparkConf, componentName).map((Function1 & Serializable & scala.Serializable)id -> MODULE$.parseResourceRequest(sparkConf, (ResourceID)id), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$parseAllResourceRequests$2(x$1)));
    }

    public Tuple2<Object, Object> calculateAmountAndPartsForFraction(double doubleAmount) {
        int n;
        if (doubleAmount <= 0.5) {
            n = (int)Math.floor(1.0 / doubleAmount);
        } else {
            if (doubleAmount % 1.0 != 0.0) {
                throw new SparkException(new StringBuilder(62).append("The resource amount ").append(doubleAmount).append(" must be either <= 0.5, or a whole number.").toString());
            }
            n = 1;
        }
        int parts = n;
        return new Tuple2.mcII.sp((int)Math.ceil(doubleAmount), parts);
    }

    public void addTaskResourceRequests(SparkConf sparkConf, TaskResourceRequests treqs) {
        this.listResourceIds(sparkConf, org.apache.spark.internal.config.package$.MODULE$.SPARK_TASK_PREFIX()).map((Function1 & Serializable & scala.Serializable)resourceId -> {
            Map settings = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(resourceId.confPrefix()))).toMap(Predef$.MODULE$.$conforms());
            double amountDouble = new StringOps(Predef$.MODULE$.augmentString((String)settings.getOrElse((Object)MODULE$.AMOUNT(), (Function0 & Serializable & scala.Serializable)() -> {
                throw new SparkException(new StringBuilder(31).append("You must specify an amount for ").append(resourceId.resourceName()).toString());
            }))).toDouble();
            return treqs.resource(resourceId.resourceName(), amountDouble);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<ResourceRequirement> parseResourceRequirements(SparkConf sparkConf, String componentName) {
        Seq<ResourceID> resourceIds = this.listResourceIds(sparkConf, componentName);
        Seq rnamesAndAmounts = (Seq)resourceIds.map((Function1 & Serializable & scala.Serializable)resourceId -> {
            Map settings = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(resourceId.confPrefix()))).toMap(Predef$.MODULE$.$conforms());
            double amountDouble = new StringOps(Predef$.MODULE$.augmentString((String)settings.getOrElse((Object)MODULE$.AMOUNT(), (Function0 & Serializable & scala.Serializable)() -> {
                throw new SparkException(new StringBuilder(31).append("You must specify an amount for ").append(resourceId.resourceName()).toString());
            }))).toDouble();
            return new Tuple2((Object)resourceId.resourceName(), (Object)BoxesRunTime.boxToDouble((double)amountDouble));
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)rnamesAndAmounts.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$parseResourceRequirements$3(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2.mcII.sp sp2;
                Tuple2.mcII.sp sp3;
                String rName = (String)tuple2._1();
                double amountDouble = tuple2._2$mcD$sp();
                if (componentName.equalsIgnoreCase(org.apache.spark.internal.config.package$.MODULE$.SPARK_TASK_PREFIX())) {
                    sp3 = MODULE$.calculateAmountAndPartsForFraction(amountDouble);
                } else {
                    if (amountDouble % 1.0 != 0.0) {
                        throw new SparkException(new StringBuilder(68).append("Only tasks support fractional resources, please check your ").append(componentName).append(" settings").toString());
                    }
                    sp3 = sp2 = new Tuple2.mcII.sp((int)amountDouble, 1);
                }
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                int amount = sp2._1$mcI$sp();
                int parts = sp2._2$mcI$sp();
                Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(amount, parts);
                int amount2 = sp4._1$mcI$sp();
                int parts2 = sp4._2$mcI$sp();
                return new ResourceRequirement(rName, amount2, parts2);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<ResourceRequirement> executorResourceRequestToRequirement(Seq<ExecutorResourceRequest> resourceRequest) {
        return (Seq)resourceRequest.map((Function1 & Serializable & scala.Serializable)request -> new ResourceRequirement(request.resourceName(), (int)request.amount(), 1), Seq$.MODULE$.canBuildFrom());
    }

    public boolean resourcesMeetRequirements(Map<String, Object> resourcesFree, Seq<ResourceRequirement> resourceRequirements) {
        return resourceRequirements.forall((Function1 & Serializable & scala.Serializable)req -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$resourcesMeetRequirements$1(resourcesFree, req)));
    }

    public <T> Seq<T> withResourcesJson(String resourcesFile, Function1<String, Seq<T>> extract) {
        Seq seq;
        String json = new String(Files.readAllBytes(Paths.get(resourcesFile, new String[0])));
        try {
            seq = (Seq)extract.apply((Object)json);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new SparkException(new StringBuilder(29).append("Error parsing resources file ").append(resourcesFile).toString(), e);
            }
            throw throwable;
        }
        return seq;
    }

    public Seq<ResourceAllocation> parseAllocatedFromJsonFile(String resourcesFile) {
        return this.withResourcesJson(resourcesFile, (Function1 & Serializable & scala.Serializable)json -> {
            DefaultFormats$ formats = DefaultFormats$.MODULE$;
            return (Seq)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(ResourceAllocation.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        });
    }

    public Seq<ResourceAllocation> parseAllocated(Option<String> resourcesFileOpt, String componentName) {
        return (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(resourcesFileOpt).toSeq().flatMap((Function1 & Serializable & scala.Serializable)resourcesFile -> MODULE$.parseAllocatedFromJsonFile((String)resourcesFile), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$parseAllocated$2(componentName, x$3)));
    }

    private Seq<ResourceAllocation> parseAllocatedOrDiscoverResources(SparkConf sparkConf, String componentName, Option<String> resourcesFileOpt) {
        Seq<ResourceAllocation> allocated = this.parseAllocated(resourcesFileOpt, componentName);
        Seq otherResourceIds = (Seq)this.listResourceIds(sparkConf, componentName).diff((GenSeq)allocated.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.id(), Seq$.MODULE$.canBuildFrom()));
        Seq otherResources = (Seq)otherResourceIds.flatMap((Function1 & Serializable & scala.Serializable)id -> {
            ResourceRequest request = MODULE$.parseResourceRequest(sparkConf, (ResourceID)id);
            if (request.amount() > 0L) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new ResourceAllocation((ResourceID)id, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])MODULE$.discoverResource(sparkConf, request).addresses()))));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)allocated.$plus$plus((GenTraversableOnce)otherResources, Seq$.MODULE$.canBuildFrom());
    }

    private void assertResourceAllocationMeetsRequest(ResourceAllocation allocation, ResourceRequest request) {
        ResourceID resourceID = allocation.id();
        ResourceID resourceID2 = request.id();
        Predef$.MODULE$.require(!(resourceID != null ? !((Object)resourceID).equals(resourceID2) : resourceID2 != null) && (long)allocation.addresses().size() >= request.amount(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Resource: ").append(allocation.id().resourceName()).append(", with addresses: ").append(allocation.addresses().mkString(",")).append(" ").append("is less than what the user requested: ").append(request.amount()).append(")").toString());
    }

    private void assertAllResourceAllocationsMeetRequests(Seq<ResourceAllocation> allocations, Seq<ResourceRequest> requests) {
        Map allocated = ((TraversableOnce)allocations.map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.id()), x), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        requests.foreach((Function1 & Serializable & scala.Serializable)r -> {
            ResourceUtils$.MODULE$.assertResourceAllocationMeetsRequest((ResourceAllocation)allocated.apply((Object)r.id()), r);
            return BoxedUnit.UNIT;
        });
    }

    private void assertAllResourceAllocationsMatchResourceProfile(Map<String, ResourceInformation> allocations, Map<String, ExecutorResourceRequest> execReqs) {
        execReqs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResourceUtils$.$anonfun$assertAllResourceAllocationsMatchResourceProfile$1(allocations, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, ResourceInformation> getOrDiscoverAllResources(SparkConf sparkConf, String componentName, Option<String> resourcesFileOpt) {
        Seq<ResourceRequest> requests = this.parseAllResourceRequests(sparkConf, componentName);
        Seq<ResourceAllocation> allocations = this.parseAllocatedOrDiscoverResources(sparkConf, componentName, resourcesFileOpt);
        this.assertAllResourceAllocationsMeetRequests(allocations, requests);
        Map resourceInfoMap = ((TraversableOnce)allocations.map((Function1 & Serializable & scala.Serializable)a -> new Tuple2((Object)a.id().resourceName(), (Object)a.toResourceInformation()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return resourceInfoMap;
    }

    private Optional<String> emptyStringToOptional(String optStr) {
        if (optStr.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(optStr);
    }

    public Map<String, ResourceInformation> getOrDiscoverAllResourcesForResourceProfile(Option<String> resourcesFileOpt, String componentName, ResourceProfile resourceProfile, SparkConf sparkConf) {
        Seq<ResourceAllocation> fileAllocated = this.parseAllocated(resourcesFileOpt, componentName);
        Map fileAllocResMap = ((TraversableOnce)fileAllocated.map((Function1 & Serializable & scala.Serializable)a -> new Tuple2((Object)a.id().resourceName(), (Object)a.toResourceInformation()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map<String, ExecutorResourceRequest> execReq = resourceProfile.getCustomExecutorResources();
        Map filteredExecreq = (Map)execReq.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceUtils$.$anonfun$getOrDiscoverAllResourcesForResourceProfile$2(fileAllocResMap, x0$1)));
        Map rpAllocations = (Map)filteredExecreq.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                ExecutorResourceRequest execRequest = (ExecutorResourceRequest)tuple2._2();
                ResourceID resourceId = new ResourceID(componentName, rName);
                Optional<String> scriptOpt = MODULE$.emptyStringToOptional(execRequest.discoveryScript());
                Optional<String> vendorOpt = MODULE$.emptyStringToOptional(execRequest.vendor());
                ResourceRequest resourceReq = new ResourceRequest(resourceId, execRequest.amount(), scriptOpt, vendorOpt);
                String[] addrs = MODULE$.discoverResource(sparkConf, resourceReq).addresses();
                return new Tuple2((Object)rName, (Object)new ResourceInformation(rName, addrs));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        Map allAllocations = fileAllocResMap.$plus$plus((GenTraversableOnce)rpAllocations);
        this.assertAllResourceAllocationsMatchResourceProfile((Map<String, ResourceInformation>)allAllocations, execReq);
        return allAllocations;
    }

    public void logResourceInfo(String componentName, Map<String, ResourceInformation> resources) {
        String resourceInfo = resources.isEmpty() ? new StringBuilder(36).append("No custom resources configured for ").append(componentName).append(".").toString() : new StringBuilder(23).append("Custom resources for ").append(componentName).append(":\n").append(resources.mkString("\n")).toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "==============================================================");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> resourceInfo);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "==============================================================");
    }

    public ResourceInformation discoverResource(SparkConf sparkConf, ResourceRequest resourceRequest) {
        Object object = new Object();
        try {
            String discoveryScriptPlugin = "org.apache.spark.resource.ResourceDiscoveryScriptPlugin";
            Seq pluginClasses = (Seq)((SeqLike)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.RESOURCES_DISCOVERY_PLUGIN())).$colon$plus((Object)discoveryScriptPlugin, Seq$.MODULE$.canBuildFrom());
            Seq<ResourceDiscoveryPlugin> resourcePlugins = Utils$.MODULE$.loadExtensions(ResourceDiscoveryPlugin.class, (Seq<String>)pluginClasses, sparkConf);
            resourcePlugins.foreach((Function1 & Serializable & scala.Serializable)plugin -> {
                ResourceUtils$.$anonfun$discoverResource$1(resourceRequest, sparkConf, object, plugin);
                return BoxedUnit.UNIT;
            });
            throw new SparkException(new StringBuilder(63).append("None of the discovery plugins returned ResourceInformation for ").append(resourceRequest.id().resourceName()).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (ResourceInformation)ex.value();
        }
    }

    public boolean validateTaskCpusLargeEnough(SparkConf sparkConf, int execCores, int taskCpus) {
        if (execCores < taskCpus) {
            throw new SparkException(new StringBuilder(81).append("The number of cores per executor (=").append(execCores).append(") has to be >= ").append("the number of cpus per task = ").append(taskCpus).append(".").toString());
        }
        return true;
    }

    public void warnOnWastedResources(ResourceProfile rp, SparkConf sparkConf, Option<Object> execCores) {
        int n;
        boolean coresKnown = rp.isCoresLimitKnown();
        ObjectRef limitingResource = ObjectRef.create((Object)rp.limitingResource(sparkConf));
        IntRef maxTaskPerExec = IntRef.create((int)rp.maxTasksPerExecutor(sparkConf));
        int taskCpus = ResourceProfile$.MODULE$.getTaskCpusOrDefaultForProfile(rp, sparkConf);
        if (execCores.isDefined()) {
            n = BoxesRunTime.unboxToInt((Object)execCores.get());
        } else if (coresKnown) {
            n = BoxesRunTime.unboxToInt((Object)rp.getExecutorCores().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES()))));
        } else {
            return;
        }
        int cores = n;
        if (!coresKnown) {
            int numTasksPerExecCores = cores / taskCpus;
            int numTasksPerExecCustomResource = rp.maxTasksPerExecutor(sparkConf);
            if (((String)limitingResource.elem).isEmpty() || new StringOps(Predef$.MODULE$.augmentString((String)limitingResource.elem)).nonEmpty() && numTasksPerExecCores < numTasksPerExecCustomResource) {
                limitingResource.elem = ResourceProfile$.MODULE$.CPUS();
                maxTaskPerExec.elem = numTasksPerExecCores;
            }
        }
        Map<String, TaskResourceRequest> taskReq = rp.getCustomTaskResources();
        Map<String, ExecutorResourceRequest> execReq = rp.getCustomExecutorResources();
        if (new StringOps(Predef$.MODULE$.augmentString((String)limitingResource.elem)).nonEmpty() && !((String)limitingResource.elem).equals(ResourceProfile$.MODULE$.CPUS()) && taskCpus * maxTaskPerExec.elem < cores) {
            int resourceNumSlots = (int)Math.floor(cores / taskCpus);
            String message = new StringBuilder(203).append("The configuration of cores (exec = ").append(cores).append(" ").append("task = ").append(taskCpus).append(", runnable tasks = ").append(resourceNumSlots).append(") will ").append("result in wasted resources due to resource ").append((String)limitingResource.elem).append(" limiting the ").append("number of runnable tasks per executor to: ").append(maxTaskPerExec.elem).append(". Please adjust ").append("your configuration.").toString();
            if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(Tests$.MODULE$.RESOURCES_WARNING_TESTING()))) {
                throw new SparkException(message);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
        }
        taskReq.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResourceUtils$.$anonfun$warnOnWastedResources$3(execReq, rp, sparkConf, maxTaskPerExec, limitingResource, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> warnOnWastedResources$default$3() {
        return None$.MODULE$;
    }

    public final String GPU() {
        return this.GPU;
    }

    public final String FPGA() {
        return this.FPGA;
    }

    public final String RESOURCE_PREFIX() {
        return this.RESOURCE_PREFIX;
    }

    public static final /* synthetic */ boolean $anonfun$parseAllResourceRequests$2(ResourceRequest x$1) {
        return x$1.amount() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$parseResourceRequirements$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double amount = tuple2._2$mcD$sp();
            return amount > 0.0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$resourcesMeetRequirements$1(Map resourcesFree$1, ResourceRequirement req) {
        return BoxesRunTime.unboxToInt((Object)resourcesFree$1.getOrElse((Object)req.resourceName(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) >= req.amount();
    }

    public static final /* synthetic */ boolean $anonfun$parseAllocated$2(String componentName$3, ResourceAllocation x$3) {
        String string = x$3.id().componentName();
        String string2 = componentName$3;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$assertAllResourceAllocationsMatchResourceProfile$1(Map allocations$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rName = (String)tuple2._1();
            ExecutorResourceRequest req = (ExecutorResourceRequest)tuple2._2();
            Predef$.MODULE$.require(allocations$1.contains((Object)rName) && (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ResourceInformation)allocations$1.apply((Object)rName)).addresses())).size() >= req.amount(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Resource: ").append(rName).append(", with addresses: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ResourceInformation)allocations$1.apply((Object)rName)).addresses())).mkString(",")).append(" ").append("is less than what the user requested: ").append(req.amount()).append(")").toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getOrDiscoverAllResourcesForResourceProfile$2(Map fileAllocResMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rname = (String)tuple2._1();
            return fileAllocResMap$1.contains((Object)rname);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$discoverResource$1(ResourceRequest resourceRequest$1, SparkConf sparkConf$6, Object nonLocalReturnKey1$1, ResourceDiscoveryPlugin plugin) {
        Optional<ResourceInformation> riOption = plugin.discoverResource(resourceRequest$1, sparkConf$6);
        if (riOption.isPresent()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)riOption.get());
        }
    }

    public static final /* synthetic */ void $anonfun$warnOnWastedResources$3(Map execReq$1, ResourceProfile rp$1, SparkConf sparkConf$7, IntRef maxTaskPerExec$1, ObjectRef limitingResource$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rName = (String)tuple2._1();
            TaskResourceRequest treq = (TaskResourceRequest)tuple2._2();
            long execAmount = ((ExecutorResourceRequest)execReq$1.apply((Object)rName)).amount();
            int taskAmount = rp$1.getSchedulerTaskResourceAmount(rName);
            int numParts = rp$1.getNumSlotsPerAddress(rName, sparkConf$7);
            if ((long)maxTaskPerExec$1.elem < execAmount * (long)numParts / (long)taskAmount) {
                double origTaskAmount = treq.amount();
                String taskReqStr = new StringBuilder(1).append(origTaskAmount).append("/").append(numParts).toString();
                int resourceNumSlots = (int)Math.floor(execAmount * (long)numParts / (long)taskAmount);
                String message = new StringBuilder(209).append("The configuration of resource: ").append(treq.resourceName()).append(" ").append("(exec = ").append(execAmount).append(", task = ").append(taskReqStr).append(", ").append("runnable tasks = ").append(resourceNumSlots).append(") will ").append("result in wasted resources due to resource ").append((String)limitingResource$1.elem).append(" limiting the ").append("number of runnable tasks per executor to: ").append(maxTaskPerExec$1.elem).append(". Please adjust ").append("your configuration.").toString();
                if (BoxesRunTime.unboxToBoolean((Object)sparkConf$7.get(Tests$.MODULE$.RESOURCES_WARNING_TESTING()))) {
                    throw new SparkException(message);
                }
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ResourceUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.DISCOVERY_SCRIPT = "discoveryScript";
        this.VENDOR = "vendor";
        this.AMOUNT = "amount";
        this.GPU = "gpu";
        this.FPGA = "fpga";
        this.RESOURCE_PREFIX = "resource";
    }
}

