/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.Trace;

class IFSWriteReq
extends IFSDataStreamReq {
    private static final int HEADER_LENGTH = 20;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int BASE_OFFSET_OFFSET = 26;
    private static final int RELATIVE_OFFSET_OFFSET = 30;
    private static final int DATA_FLAGS_OFFSET = 34;
    private static final int CCSID_OFFSET = 36;
    private static final int LARGE_BASE_OFFSET_OFFSET = 38;
    private static final int LARGE_RELATIVE_OFFSET_OFFSET = 46;

    IFSWriteReq(int fileHandle, long fileOffset, byte[] data, int dataOffset, int dataLength, int dataCCSID, boolean forceToStorage, int datastreamLevel) {
        super(20 + IFSWriteReq.getTemplateLength(datastreamLevel) + 6 + dataLength);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSWriteReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(4);
        this.set32bit(fileHandle, 22);
        this.setOffsetFields(fileOffset, datastreamLevel);
        this.set16bit(forceToStorage ? 3 : 2, 34);
        this.set16bit(dataCCSID, 36);
        this.set32bit(dataLength + 6, IFSWriteReq.getFileDataLLOffset(datastreamLevel));
        this.set16bit(32, IFSWriteReq.getFileDataCPOffset(datastreamLevel));
        System.arraycopy(data, dataOffset, this.data_, IFSWriteReq.getFileDataOffset(datastreamLevel), dataLength);
    }

    private static final int getTemplateLength(int datastreamLevel) {
        return datastreamLevel < 16 ? 18 : 34;
    }

    private static final int getFileDataLLOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 38 : 54;
    }

    private static final int getFileDataCPOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 42 : 58;
    }

    private static final int getFileDataOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 44 : 60;
    }

    private final void setOffsetFields(long fileOffset, int datastreamLevel) {
        if (datastreamLevel < 16) {
            if (fileOffset > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified fileOffset value (" + fileOffset + ") exceeds maximum file length supported by system.");
                }
                fileOffset = Integer.MAX_VALUE;
            }
            this.set32bit(0, 26);
            this.set32bit((int)fileOffset, 30);
        } else {
            this.set32bit(0, 26);
            this.set32bit(0, 30);
            this.set64bit(0L, 38);
            this.set64bit(fileOffset, 46);
        }
    }
}

