/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class SecureAS400
extends AS400 {
    static final long serialVersionUID = 4L;
    public static final int CLIENT_TO_PROXY_SERVER = 1;
    public static final int PROXY_SERVER_TO_SERVER = 2;
    public static final int CLINT_TO_SERVER = 3;
    public static final int CLIENT_TO_SERVER = 3;
    public static boolean changeCipherSuites = false;
    public static String[] newCipherSuites;

    private void construct() {
        if (Trace.traceOn_) {
            Trace.log(1, "Turning SSL connections on.");
        }
        this.useSSLConnection_ = new SSLOptions();
        String prop = SystemProperties.getProperty("com.ibm.as400.access.SecureAS400.proxyEncryptionMode");
        if (prop != null && (prop.equals("1") || prop.equals("2"))) {
            this.useSSLConnection_.proxyEncryptionMode_ = Integer.parseInt(prop);
        }
    }

    public SecureAS400() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String systemName) {
        super(systemName);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String systemName, String userId) {
        super(systemName, userId);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String systemName, ProfileTokenCredential profileToken) {
        super(systemName, profileToken);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String systemName, String userId, String password) {
        super(systemName, userId, password);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String systemName, String userId, char[] password) {
        super(systemName, userId, password);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String systemName, String userId, char[] password, char[] additionalAuthenticationFactor) throws IOException, AS400SecurityException {
        super(systemName, userId, password, additionalAuthenticationFactor);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String systemName, String userId, String password, String proxyServer) {
        super(systemName, userId, password, proxyServer);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(String systemName, String userId, char[] password, String proxyServer) {
        super(systemName, userId, password, proxyServer);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
    }

    public SecureAS400(AS400 system) {
        super(system);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SecureAS400 object.");
        }
        this.construct();
        if (system.useSSLConnection_ != null) {
            this.useSSLConnection_.proxyEncryptionMode_ = system.useSSLConnection_.proxyEncryptionMode_;
        }
    }

    public static void addPasswordCacheEntry(String systemName, String userId, String password) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + systemName + "' user ID: '" + userId + "'");
        }
        SecureAS400.addPasswordCacheEntry(new SecureAS400(systemName, userId, password));
    }

    public static void addPasswordCacheEntry(String systemName, String userId, char[] password) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + systemName + "' user ID: '" + userId + "'");
        }
        SecureAS400.addPasswordCacheEntry(new SecureAS400(systemName, userId, password));
    }

    public static void addPasswordCacheEntry(String systemName, String userId, String password, String proxyServer) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + systemName + "' user ID: '" + userId + "' proxy server: '" + proxyServer + "'");
        }
        SecureAS400.addPasswordCacheEntry(new SecureAS400(systemName, userId, password, proxyServer));
    }

    public static void addPasswordCacheEntry(String systemName, String userId, char[] password, String proxyServer) throws AS400SecurityException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding password cache entry, system name: '" + systemName + "' user ID: '" + userId + "' proxy server: '" + proxyServer + "'");
        }
        SecureAS400.addPasswordCacheEntry(new SecureAS400(systemName, userId, password, proxyServer));
    }

    public static boolean isAdditionalAuthenticationFactorAccepted(String systemName) throws IOException, AS400SecurityException {
        byte indicator = AS400ImplRemote.getAdditionalAuthenticationIndicator(systemName, true);
        return indicator > 0;
    }

    public String getKeyRingName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting key ring name: null");
        }
        return null;
    }

    public int getProxyEncryptionMode() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting proxy encryption mode:", this.useSSLConnection_.proxyEncryptionMode_);
        }
        return this.useSSLConnection_.proxyEncryptionMode_;
    }

    public void setKeyRingName(String keyRingName) throws PropertyVetoException {
        Trace.log(2, "Cannot set key ring class name  -- no sslight support ");
        throw new ExtendedIllegalStateException("keyRingName", 11);
    }

    public void setKeyRingName(String keyRingName, String keyRingPassword) throws PropertyVetoException {
        Trace.log(2, "Cannot set key ring class name  -- no sslight support ");
        throw new ExtendedIllegalStateException("keyRingName", 11);
    }

    public void setKeyRingPassword(String keyRingPassword) {
        Trace.log(2, "Cannot set key ring class password.");
        throw new ExtendedIllegalStateException("keyRingPassword", 5);
    }

    public void setProxyEncryptionMode(int proxyEncryptionMode) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting proxy encryption mode:", proxyEncryptionMode);
        }
        if (proxyEncryptionMode < 1 || proxyEncryptionMode > 3) {
            Trace.log(2, "Value of parameter 'proxyEncryptionMode' is not valid:", proxyEncryptionMode);
            throw new ExtendedIllegalArgumentException("proxyEncryptionMode (" + proxyEncryptionMode + ")", 2);
        }
        if (this.propertiesFrozen_) {
            Trace.log(2, "Cannot set proxy encryption mode after connection has been made.");
            throw new ExtendedIllegalStateException("proxyEncryptionMode", 5);
        }
        Integer oldValue = this.useSSLConnection_.proxyEncryptionMode_;
        Integer newValue = proxyEncryptionMode;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("proxyEncryptionMode", oldValue, newValue);
        }
        this.useSSLConnection_.proxyEncryptionMode_ = proxyEncryptionMode;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("proxyEncryptionMode", oldValue, newValue);
        }
    }

    public void setEnabledCipherSuites(String[] suites) {
        if (suites != null && suites.length > 0) {
            changeCipherSuites = true;
            newCipherSuites = suites;
        }
    }
}

