/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import com.ibm.as400.util.html.HTMLTree;
import com.ibm.as400.util.html.HTMLVector;
import com.ibm.as400.util.html.ResourceBundleLoader_h;
import com.ibm.as400.util.html.URLEncoder;
import com.ibm.as400.util.html.URLParser;
import com.ibm.as400.util.servlet.ServletHyperlink;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Collator;
import java.util.Properties;
import java.util.Vector;

public class HTMLTreeElement
implements HTMLTagElement,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final long serialVersionUID = -2067619739727758210L;
    private HTMLVector branches_;
    private boolean expanded_ = false;
    private HTMLHyperlink textUrl_ = null;
    private HTMLHyperlink iconUrl_ = null;
    private HTMLTagElement elementData_ = null;
    private boolean sort_ = true;
    private transient Collator collator_;
    private static String expandedGif_ = null;
    private static String collapsedGif_ = null;
    private static String docGif_ = null;
    private static final String std = "<td>\n";
    private static final String etd = "</td>\n";
    transient PropertyChangeSupport changes_;
    private transient Vector elementListeners_;

    public HTMLTreeElement() {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception e) {
            this.collator_ = null;
        }
        this.branches_ = new HTMLVector();
    }

    public HTMLTreeElement(String text) {
        this();
        this.setText(text);
    }

    public HTMLTreeElement(HTMLTagElement text) {
        this();
        this.setText(text);
    }

    public HTMLTreeElement(HTMLHyperlink textUrl) {
        this();
        this.setTextUrl(textUrl);
    }

    public void addElement(HTMLTreeElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.branches_.addElement(element);
        if (this.elementListeners_ != null) {
            this.fireElementEvent(0);
        }
    }

    public void addElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ == null) {
            this.elementListeners_ = new Vector();
        }
        this.elementListeners_.addElement(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    private void fireElementEvent(int evt) {
        Vector targets = (Vector)this.elementListeners_.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getCollapsedGif() {
        return collapsedGif_;
    }

    public String getDocGif() {
        return docGif_;
    }

    public String getExpandedGif() {
        return expandedGif_;
    }

    public HTMLHyperlink getIconUrl() {
        return this.iconUrl_;
    }

    public HTMLTagElement getText() {
        return this.elementData_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLTreeElement was here -->";
    }

    @Override
    public String getTag() {
        if (this.iconUrl_ == null) {
            throw new ExtendedIllegalStateException("iconUrl", 4);
        }
        this.setIconUrl(this.iconUrl_);
        if (this.elementData_ == null) {
            throw new ExtendedIllegalStateException("text", 4);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<tr>\n");
        if (this.isLeaf()) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Element is a leaf.");
            }
            buf.append(std);
            if (docGif_ != null) {
                buf.append("<img src=\"");
                buf.append(docGif_);
                buf.append("\" border=\"0\" width=\"9\" height=\"14\" vspace=\"3\" alt=\"");
                buf.append(ResourceBundleLoader_h.getText("PROP_NAME_WORK"));
                buf.append("\" />\n");
            } else {
                buf.append(">");
            }
            buf.append(etd);
            buf.append(std);
            buf.append(this.elementData_.getTag());
            buf.append("\n");
            buf.append(etd);
            buf.append("</tr>\n");
        } else {
            String hcStr = URLEncoder.encode(Integer.toString(this.hashCode()));
            buf.append(std);
            StringBuffer iconTag = new StringBuffer();
            if (this.isExpanded()) {
                if (expandedGif_ != null) {
                    iconTag.append("<img src=\"");
                    iconTag.append(expandedGif_);
                    iconTag.append("\" border=\"0\" width=\"9\" height=\"14\" vspace=\"3\" alt=\"");
                    iconTag.append(ResourceBundleLoader_h.getText("PROP_NAME_COMPRESS"));
                    iconTag.append("\" />");
                } else {
                    iconTag.append("-");
                }
            } else if (collapsedGif_ != null) {
                iconTag.append("<img src=\"");
                iconTag.append(collapsedGif_);
                iconTag.append("\" border=\"0\" width=\"9\" height=\"14\" vspace=\"3\" alt=\"");
                iconTag.append(ResourceBundleLoader_h.getText("PROP_NAME_EXPAND"));
                iconTag.append("\" />");
            } else {
                iconTag.append("+");
            }
            if (this.iconUrl_ != null) {
                try {
                    this.iconUrl_.setName(hcStr);
                    Properties iconProp = this.iconUrl_.getProperties();
                    if (iconProp == null) {
                        iconProp = new Properties();
                    }
                    iconProp.put("hashcode", hcStr);
                    if (this.expanded_) {
                        iconProp.put("action", "contract");
                    } else {
                        iconProp.put("action", "expand");
                    }
                    this.iconUrl_.setProperties(iconProp);
                    URLParser parser = new URLParser(this.iconUrl_.getLink());
                    this.iconUrl_.setLink(parser.getURI());
                    this.iconUrl_.setText(iconTag.toString());
                    this.iconUrl_.setLocation(hcStr);
                }
                catch (PropertyVetoException iconProp) {
                    // empty catch block
                }
                buf.append(this.iconUrl_.getTag());
            } else {
                buf.append(iconTag);
            }
            buf.append("\n");
            buf.append(etd);
            buf.append(std);
            if (this.textUrl_ != null) {
                try {
                    if (this.textUrl_.getText() == null) {
                        this.textUrl_.setText(this.elementData_.getTag() + "\n");
                    }
                }
                catch (PropertyVetoException iconProp) {
                    // empty catch block
                }
                buf.append(this.textUrl_.getTag());
            } else {
                buf.append(this.elementData_.getTag());
                buf.append("\n");
            }
            buf.append(etd);
            buf.append("</tr>\n");
            if (this.isExpanded()) {
                buf.append("<tr><td>&nbsp;</td><td>\n<table cellpadding=\"0\" cellspacing=\"3\">\n");
                if (this.sort_) {
                    HTMLTree.sort(this.collator_, this.branches_);
                }
                int size = this.branches_.getCount();
                Object[] data = this.branches_.getData();
                for (int i = 0; i < size; ++i) {
                    HTMLTreeElement node = (HTMLTreeElement)data[i];
                    buf.append(node.getTag());
                }
                buf.append("</table>\n</tr>\n");
            }
        }
        return buf.toString();
    }

    public HTMLHyperlink getTextUrl() {
        return this.textUrl_;
    }

    public boolean isExpanded() {
        return this.expanded_;
    }

    public boolean isLeaf() {
        return this.branches_.isEmpty();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception e) {
            this.collator_ = null;
        }
        in.defaultReadObject();
    }

    public void removeElement(HTMLTreeElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (this.branches_.removeElement(element) && this.elementListeners_ != null) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ != null) {
            this.elementListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void selected(int hashcode) {
        if (!this.isLeaf()) {
            if (this.hashCode() == hashcode) {
                boolean old = this.expanded_;
                boolean bl = this.expanded_ = !this.expanded_;
                if (this.changes_ != null) {
                    this.changes_.firePropertyChange("selected", (Object)old, (Object)this.expanded_);
                }
            } else {
                int size = this.branches_.getCount();
                Object[] data = this.branches_.getData();
                for (int i = 0; i < size; ++i) {
                    HTMLTreeElement node = (HTMLTreeElement)data[i];
                    node.selected(hashcode);
                }
            }
        }
    }

    public static void setCollapsedGif(String gifUrl) {
        if (gifUrl == null) {
            throw new NullPointerException("gifUrl");
        }
        collapsedGif_ = gifUrl;
    }

    public static void setDocGif(String gifUrl) {
        if (gifUrl == null) {
            throw new NullPointerException("gifUrl");
        }
        docGif_ = gifUrl;
    }

    public static void setExpandedGif(String gifUrl) {
        if (gifUrl == null) {
            throw new NullPointerException("gifUrl");
        }
        expandedGif_ = gifUrl;
    }

    public void setExpanded(boolean expanded) {
        boolean old = this.expanded_;
        this.expanded_ = expanded;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("expanded", (Object)old, (Object)this.expanded_);
        }
    }

    public void setIconUrl(HTMLHyperlink iconUrl) {
        if (iconUrl == null) {
            throw new NullPointerException("iconUrl");
        }
        HTMLHyperlink old = this.iconUrl_;
        this.iconUrl_ = iconUrl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("url", old, iconUrl);
        }
        int size = this.branches_.getCount();
        Object[] data = this.branches_.getData();
        for (int i = 0; i < size; ++i) {
            HTMLHyperlink l = null;
            HTMLTreeElement node = (HTMLTreeElement)data[i];
            l = iconUrl instanceof ServletHyperlink ? (ServletHyperlink)iconUrl.clone() : (HTMLHyperlink)iconUrl.clone();
            node.setIconUrl(l);
        }
    }

    public void setText(HTMLTagElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        HTMLTagElement old = this.elementData_;
        this.elementData_ = element;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("element", old, this.elementData_);
        }
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        HTMLTagElement old = this.elementData_;
        this.elementData_ = new HTMLText(text);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", old, this.elementData_);
        }
    }

    public void setTextUrl(HTMLHyperlink textUrl) {
        if (textUrl == null) {
            throw new NullPointerException("textUrl");
        }
        HTMLHyperlink old = this.textUrl_;
        this.textUrl_ = textUrl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("url", old, textUrl);
        }
        this.setText(textUrl);
    }

    public void sort(boolean sort) {
        this.sort_ = sort;
    }
}

