/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ExecutionFailure;
import org.apache.cassandra.concurrent.LocalAwareExecutorPlus;
import org.apache.cassandra.utils.Closeable;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.WithResources;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ImmediateFuture;

@Shared(scope={Shared.Scope.SIMULATION})
public class ImmediateExecutor
implements LocalAwareExecutorPlus {
    public static final ImmediateExecutor INSTANCE = new ImmediateExecutor();

    private ImmediateExecutor() {
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            return ImmediateFuture.success(task.call());
        }
        catch (Throwable t) {
            ExecutionFailure.handle(t);
            return ImmediateFuture.failure(t);
        }
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        try {
            task.run();
            return ImmediateFuture.success(result);
        }
        catch (Throwable t) {
            ExecutionFailure.handle(t);
            return ImmediateFuture.failure(t);
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            task.run();
            return ImmediateFuture.success(null);
        }
        catch (Throwable t) {
            ExecutionFailure.handle(t);
            return ImmediateFuture.failure(t);
        }
    }

    @Override
    public void execute(WithResources withResources, Runnable task) {
        try (Closeable ignored = withResources.get();){
            task.run();
        }
        catch (Throwable t) {
            ExecutionFailure.handle(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Future<T> submit(WithResources withResources, Callable<T> task) {
        try (Closeable ignored = withResources.get();){
            ImmediateFuture<T> immediateFuture = ImmediateFuture.success(task.call());
            return immediateFuture;
        }
        catch (Throwable t) {
            ExecutionFailure.handle(t);
            return ImmediateFuture.failure(t);
        }
    }

    @Override
    public Future<?> submit(WithResources withResources, Runnable task) {
        return this.submit(withResources, task, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Future<T> submit(WithResources withResources, Runnable task, T result) {
        try (Closeable ignored = withResources.get();){
            task.run();
            ImmediateFuture<T> immediateFuture = ImmediateFuture.success(result);
            return immediateFuture;
        }
        catch (Throwable t) {
            ExecutionFailure.handle(t);
            return ImmediateFuture.failure(t);
        }
    }

    @Override
    public boolean inExecutor() {
        return true;
    }

    @Override
    public void execute(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable t) {
            ExecutionFailure.handle(t);
        }
    }

    @Override
    public int getActiveTaskCount() {
        return 0;
    }

    @Override
    public long getCompletedTaskCount() {
        return 0L;
    }

    @Override
    public int getPendingTaskCount() {
        return 0;
    }

    @Override
    public int getCorePoolSize() {
        return 0;
    }

    @Override
    public int getMaximumPoolSize() {
        return 0;
    }

    @Override
    public void setCorePoolSize(int newCorePoolSize) {
        throw new IllegalArgumentException("Cannot resize ImmediateExecutor");
    }

    @Override
    public void setMaximumPoolSize(int newMaximumPoolSize) {
        throw new IllegalArgumentException("Cannot resize ImmediateExecutor");
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return true;
    }
}

