/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.signature;

import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.SSHSignature;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class RSASHA1Verify
implements SSHSignature {
    private static final Logger log = Logger.getLogger(RSASHA1Verify.class);
    public static final String ID_SSH_RSA = "ssh-rsa";

    private RSASHA1Verify() {
    }

    public static RSASHA1Verify get() {
        return InstanceHolder.sInstance;
    }

    @Override
    public String getKeyFormat() {
        return ID_SSH_RSA;
    }

    @Override
    public PublicKey decodePublicKey(byte[] key) throws IOException {
        TypesReader tr = new TypesReader(key);
        String key_format = tr.readString();
        if (!key_format.equals(ID_SSH_RSA)) {
            throw new IllegalArgumentException("This is not a ssh-rsa public key");
        }
        BigInteger e = tr.readMPINT();
        BigInteger n = tr.readMPINT();
        if (tr.remain() != 0) {
            throw new IOException("Padding in RSA public key!");
        }
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(n, e);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException nsae) {
            throw new IOException("No RSA KeyFactory available", nsae);
        }
    }

    @Override
    public byte[] encodePublicKey(PublicKey pk) throws IOException {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)pk;
        TypesWriter tw = new TypesWriter();
        tw.writeString(ID_SSH_RSA);
        tw.writeMPInt(rsaPublicKey.getPublicExponent());
        tw.writeMPInt(rsaPublicKey.getModulus());
        return tw.getBytes();
    }

    private static byte[] decodeSignature(byte[] sig) throws IOException {
        TypesReader tr = new TypesReader(sig);
        String sig_format = tr.readString();
        if (!sig_format.equals(ID_SSH_RSA)) {
            throw new IOException("Peer sent wrong signature format");
        }
        byte[] s = tr.readByteString();
        if (s.length == 0) {
            throw new IOException("Error in RSA signature, S is empty.");
        }
        if (log.isEnabled()) {
            log.log(80, "Decoding ssh-rsa signature string (length: " + s.length + ")");
        }
        if (tr.remain() != 0) {
            throw new IOException("Padding in RSA signature!");
        }
        return s;
    }

    private static byte[] encodeSignature(byte[] s) throws IOException {
        TypesWriter tw = new TypesWriter();
        tw.writeString(ID_SSH_RSA);
        if (s.length > 1 && s[0] == 0) {
            tw.writeString(s, 1, s.length - 1);
        } else {
            tw.writeString(s, 0, s.length);
        }
        return tw.getBytes();
    }

    @Override
    public byte[] generateSignature(byte[] message, PrivateKey pk, SecureRandom secureRandom) throws IOException {
        try {
            Signature s = Signature.getInstance("SHA1withRSA");
            s.initSign(pk, secureRandom);
            s.update(message);
            return RSASHA1Verify.encodeSignature(s.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] sshSig, PublicKey dpk) throws IOException {
        byte[] javaSig = RSASHA1Verify.decodeSignature(sshSig);
        try {
            Signature s = Signature.getInstance("SHA1withRSA");
            s.initVerify(dpk);
            s.update(message);
            return s.verify(javaSig);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IOException(e);
        }
    }

    private static class InstanceHolder {
        private static RSASHA1Verify sInstance = new RSASHA1Verify();

        private InstanceHolder() {
        }
    }
}

