/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.resource;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.IXml;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.resource.IResourceExport;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.SequenceResourceNaming;
import org.apache.hop.resource.TopLevelResource;

public class ResourceUtil {
    private static final Class<?> PKG = ResourceUtil.class;

    public static final TopLevelResource serializeResourceExportInterface(String zipFilename, IResourceExport resourceExportInterface, IVariables variables, IHopMetadataProvider metadataProvider, IXml executionConfiguration, String injectFilename, String sourceResourceFolderMapping, String targetResourceFolderMapping, Map<String, String> variablesMap) throws HopException {
        ZipOutputStream out;
        block15: {
            TopLevelResource topLevelResource;
            block16: {
                out = null;
                HashMap<String, ResourceDefinition> definitions = new HashMap<String, ResourceDefinition>();
                SequenceResourceNaming namingInterface = new SequenceResourceNaming();
                String topLevelResource2 = resourceExportInterface.exportResources(variables, definitions, namingInterface, metadataProvider);
                if (topLevelResource2 == null || definitions.isEmpty()) break block15;
                Map<String, String> dirMap = namingInterface.getDirectoryMap();
                if (StringUtils.isNotEmpty((String)sourceResourceFolderMapping) && StringUtils.isNotEmpty((String)targetResourceFolderMapping)) {
                    FileObject sourceReference = HopVfs.getFileObject((String)variables.resolve(sourceResourceFolderMapping));
                    for (String sourceDirectory : dirMap.keySet()) {
                        FileObject source = HopVfs.getFileObject((String)variables.resolve(sourceDirectory));
                        String relativePath = sourceReference.getName().getRelativeName(source.getName());
                        Object targetDirectory = targetResourceFolderMapping;
                        if (!((String)targetDirectory).endsWith("/")) {
                            targetDirectory = (String)targetDirectory + "/";
                        }
                        targetDirectory = (String)targetDirectory + relativePath;
                        String parameter = dirMap.get(sourceDirectory);
                        variablesMap.put(parameter, (String)targetDirectory);
                    }
                }
                if (executionConfiguration != null) {
                    String encoding = "UTF-8";
                    ResourceDefinition resourceDefinition = new ResourceDefinition(injectFilename, XmlHandler.getXmlHeader((String)encoding) + executionConfiguration.getXml(variables));
                    definitions.put(injectFilename, resourceDefinition);
                }
                FileObject fileObject = HopVfs.getFileObject((String)zipFilename);
                out = new ZipOutputStream(HopVfs.getOutputStream((FileObject)fileObject, (boolean)false));
                for (String filename : definitions.keySet()) {
                    ResourceDefinition resourceDefinition = (ResourceDefinition)definitions.get(filename);
                    ZipEntry zipEntry = new ZipEntry(resourceDefinition.getFilename());
                    String comment = BaseMessages.getString(PKG, (String)"ResourceUtil.SerializeResourceExportInterface.ZipEntryComment.OriginatingFile", (String[])new String[]{filename, Const.NVL((String)resourceDefinition.getOrigin(), (String)"-")});
                    zipEntry.setComment(comment);
                    out.putNextEntry(zipEntry);
                    out.write(resourceDefinition.getContent().getBytes());
                    out.closeEntry();
                }
                ZipEntry jsonEntry = new ZipEntry("metadata.json");
                jsonEntry.setComment("Export of the client metadata");
                out.putNextEntry(jsonEntry);
                out.write(new SerializableMetadataProvider(metadataProvider).toJson().getBytes(StandardCharsets.UTF_8));
                out.closeEntry();
                String zipURL = fileObject.getName().toString();
                topLevelResource = new TopLevelResource(topLevelResource2, zipURL, "zip:" + zipURL + "!" + topLevelResource2);
                if (out == null) break block16;
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ResourceUtil.Exception.ErrorClosingZipStream", (String[])new String[]{zipFilename}));
                }
            }
            return topLevelResource;
        }
        try {
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"ResourceUtil.Exception.NoResourcesFoundToExport", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ResourceUtil.Exception.ErrorSerializingExportInterface", (String[])new String[]{resourceExportInterface.toString()}), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ResourceUtil.Exception.ErrorClosingZipStream", (String[])new String[]{zipFilename}));
                }
            }
            throw throwable;
        }
    }

    public static String getExplanation(String zipFilename, String launchFile, IResourceExport resourceExportInterface) {
        Object commandString = "";
        commandString = Const.isWindows() ? (resourceExportInterface instanceof PipelineMeta ? (String)commandString + "Pan.bat /file:\"" : (String)commandString + "Kitchen.bat /file:\"") : (resourceExportInterface instanceof PipelineMeta ? (String)commandString + "sh pan.sh -file='" : (String)commandString + "sh kitchen.sh -file='");
        commandString = (String)commandString + launchFile;
        commandString = Const.isWindows() ? (String)commandString + "\"" : (String)commandString + "'";
        String message = BaseMessages.getString(PKG, (String)"ResourceUtil.ExportResourcesExplanation", (String[])new String[]{zipFilename, commandString, launchFile, Const.CR});
        return message;
    }
}

