/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannelFileWriter;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.FileUtil;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.apache.hop.www.AddPipelineServlet;
import org.apache.hop.www.BodyHttpServlet;
import org.json.simple.parser.ParseException;

public abstract class BaseWorkflowServlet
extends BodyHttpServlet {
    private static final long serialVersionUID = 8523062215275251356L;

    protected IWorkflowEngine<WorkflowMeta> createWorkflow(WorkflowConfiguration workflowConfiguration) throws HopException, HopException, ParseException {
        WorkflowExecutionConfiguration workflowExecutionConfiguration = workflowConfiguration.getWorkflowExecutionConfiguration();
        MultiMetadataProvider metadataProvider = new MultiMetadataProvider(this.variables, new IHopMetadataProvider[]{this.getServerConfig().getMetadataProvider(), workflowConfiguration.getMetadataProvider()});
        WorkflowMeta workflowMeta = workflowConfiguration.getWorkflowMeta();
        String serverObjectId = UUID.randomUUID().toString();
        SimpleLoggingObject servletLoggingObject = this.getServletLogging(serverObjectId, workflowExecutionConfiguration.getLogLevel());
        String runConfigurationName = this.variables.resolve(workflowExecutionConfiguration.getRunConfiguration());
        IWorkflowEngine<WorkflowMeta> workflow = WorkflowEngineFactory.createWorkflowEngine(this.variables, runConfigurationName, (IHopMetadataProvider)metadataProvider, workflowMeta, (ILoggingObject)servletLoggingObject);
        workflow.initializeFrom(null);
        workflow.getWorkflowMeta().setMetadataProvider((IHopMetadataProvider)metadataProvider);
        workflow.getWorkflowMeta().setInternalHopVariables(workflow);
        workflow.setVariables(workflowConfiguration.getWorkflowExecutionConfiguration().getVariablesMap());
        this.copyWorkflowParameters(workflow, workflowExecutionConfiguration.getParametersMap());
        String startActionName = workflowExecutionConfiguration.getStartActionName();
        if (startActionName != null && !startActionName.isEmpty()) {
            ActionMeta startActionMeta = workflowMeta.findAction(startActionName);
            workflow.setStartActionMeta(startActionMeta);
        }
        this.getWorkflowMap().addWorkflow(workflow.getWorkflowName(), serverObjectId, workflow, workflowConfiguration);
        workflow.setContainerId(serverObjectId);
        return workflow;
    }

    protected IPipelineEngine<PipelineMeta> createPipeline(PipelineConfiguration pipelineConfiguration) throws HopException, HopException, ParseException {
        PipelineMeta pipelineMeta = pipelineConfiguration.getPipelineMeta();
        PipelineExecutionConfiguration pipelineExecutionConfiguration = pipelineConfiguration.getPipelineExecutionConfiguration();
        MultiMetadataProvider metadataProvider = new MultiMetadataProvider(this.variables, new IHopMetadataProvider[]{this.getServerConfig().getMetadataProvider(), pipelineConfiguration.getMetadataProvider()});
        String serverObjectId = UUID.randomUUID().toString();
        SimpleLoggingObject servletLoggingObject = this.getServletLogging(serverObjectId, pipelineExecutionConfiguration.getLogLevel());
        String runConfigurationName = pipelineConfiguration.getPipelineExecutionConfiguration().getRunConfiguration();
        IPipelineEngine<PipelineMeta> pipeline = PipelineEngineFactory.createPipelineEngine(this.variables, this.variables.resolve(runConfigurationName), (IHopMetadataProvider)metadataProvider, pipelineMeta);
        pipeline.setParent((ILoggingObject)servletLoggingObject);
        pipeline.setMetadataProvider((IHopMetadataProvider)metadataProvider);
        this.copyParameters(pipeline, pipelineExecutionConfiguration.getParametersMap());
        if (pipelineExecutionConfiguration.isSetLogfile()) {
            String realLogFilename = pipelineExecutionConfiguration.getLogFileName();
            try {
                FileUtil.createParentFolder(AddPipelineServlet.class, realLogFilename, pipelineExecutionConfiguration.isCreateParentFolder(), pipeline.getLogChannel());
                LogChannelFileWriter logChannelFileWriter = new LogChannelFileWriter(servletLoggingObject.getLogChannelId(), HopVfs.getFileObject((String)realLogFilename), pipelineExecutionConfiguration.isSetAppendLogfile());
                logChannelFileWriter.startLogging();
                pipeline.addExecutionFinishedListener(pipelineEngine -> {
                    if (logChannelFileWriter != null) {
                        logChannelFileWriter.stopLogging();
                    }
                });
            }
            catch (HopException e) {
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        pipeline.setContainerId(serverObjectId);
        this.getPipelineMap().addPipeline(pipelineMeta.getName(), serverObjectId, pipeline, pipelineConfiguration);
        return pipeline;
    }

    private void copyParameters(INamedParameters namedParameters, Map<String, String> params) throws UnknownParamException {
        for (String parameterName : params.keySet()) {
            String thisValue = params.get(parameterName);
            if (StringUtils.isBlank((String)thisValue)) continue;
            namedParameters.setParameterValue(parameterName, thisValue);
        }
    }

    private void copyWorkflowParameters(IWorkflowEngine<WorkflowMeta> workflow, Map<String, String> params) throws UnknownParamException {
        String[] parameterNames;
        WorkflowMeta workflowMeta = workflow.getWorkflowMeta();
        workflow.copyParametersFromDefinitions(workflowMeta);
        workflow.clearParameterValues();
        for (String parameterName : parameterNames = workflow.listParameters()) {
            String thisValue = params.get(parameterName);
            if (StringUtils.isBlank((String)thisValue)) continue;
            workflow.setParameterValue(parameterName, thisValue);
        }
        workflow.activateParameters(workflow);
    }

    private SimpleLoggingObject getServletLogging(String serverObjectId, LogLevel level) {
        SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getContextPath(), LoggingObjectType.HOP_SERVER, null);
        servletLoggingObject.setContainerObjectId(serverObjectId);
        servletLoggingObject.setLogLevel(level);
        return servletLoggingObject;
    }
}

