/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.spark.util.GlobalWatermarkHolder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

class WatermarkSyncedDStream<@UnknownKeyFor T>
extends InputDStream<WindowedValue<T>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger((String)(WatermarkSyncedDStream.class.getCanonicalName() + "#compute"));
    private static final @UnknownKeyFor @NonNull @Initialized int SLEEP_DURATION_MILLIS = 10;
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>>> rdds;
    private final @UnknownKeyFor @NonNull @Initialized Long batchDuration;
    private volatile @UnknownKeyFor @NonNull @Initialized boolean isFirst = true;

    public WatermarkSyncedDStream(@UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>>> rdds, @UnknownKeyFor @NonNull @Initialized Long batchDuration, @UnknownKeyFor @NonNull @Initialized StreamingContext ssc) {
        super(ssc, JavaSparkContext$.MODULE$.fakeClassTag());
        this.rdds = rdds;
        this.batchDuration = batchDuration;
    }

    private void awaitWatermarkSyncWith(@UnknownKeyFor @NonNull @Initialized long batchTime) {
        while (!this.isFirstBatch() && this.watermarkOutOfSync(batchTime)) {
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Preconditions.checkState((this.isFirstBatch() || this.watermarkIsOneBatchBehind(batchTime) ? 1 : 0) != 0, (Object)String.format("Watermark batch time:[%d] should be exactly one batch behind current batch time:[%d]", GlobalWatermarkHolder.getLastWatermarkedBatchTime(), batchTime));
    }

    private @UnknownKeyFor @NonNull @Initialized boolean watermarkOutOfSync(@UnknownKeyFor @NonNull @Initialized long batchTime) {
        return batchTime - GlobalWatermarkHolder.getLastWatermarkedBatchTime() > this.batchDuration;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isFirstBatch() {
        return this.isFirst;
    }

    private @UnknownKeyFor @NonNull @Initialized RDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> generateRdd() {
        return this.rdds.size() > 0 ? this.rdds.poll().rdd() : this.ssc().sparkContext().emptyRDD(JavaSparkContext$.MODULE$.fakeClassTag());
    }

    private @UnknownKeyFor @NonNull @Initialized boolean watermarkIsOneBatchBehind(@UnknownKeyFor @NonNull @Initialized long batchTime) {
        return GlobalWatermarkHolder.getLastWatermarkedBatchTime() == batchTime - this.batchDuration;
    }

    public @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized RDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>>> compute(@UnknownKeyFor @NonNull @Initialized Time validTime) {
        long batchTime = validTime.milliseconds();
        LOG.trace("BEFORE waiting for watermark sync, LastWatermarkedBatchTime: {}, current batch time: {}", (Object)GlobalWatermarkHolder.getLastWatermarkedBatchTime(), (Object)batchTime);
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.awaitWatermarkSyncWith(batchTime);
        stopwatch.stop();
        LOG.info("Waited {} millis for watermarks to sync up with the current batch ({})", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)batchTime);
        LOG.info("Watermarks are now: {}", GlobalWatermarkHolder.get(this.batchDuration));
        LOG.trace("AFTER waiting for watermark sync, LastWatermarkedBatchTime: {}, current batch time: {}", (Object)GlobalWatermarkHolder.getLastWatermarkedBatchTime(), (Object)batchTime);
        RDD<WindowedValue<T>> rdd = this.generateRdd();
        this.isFirst = false;
        return Option.apply(rdd);
    }

    public void start() {
    }

    public void stop() {
    }
}

