/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.valuemapper;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapperMeta;
import org.apache.hop.pipeline.transforms.valuemapper.Values;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ValueMapperDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ValueMapperMeta.class;
    private Text wTransformName;
    private CCombo wFieldName;
    private Text wTargetFieldName;
    private TextVar wNonMatchDefault;
    private TableView wFields;
    private final ValueMapperMeta input;
    private boolean gotPreviousFields = false;

    public ValueMapperDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ValueMapperMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Label wlFieldname = new Label((Composite)this.shell, 131072);
        wlFieldname.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.FieldnameToUser.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFieldname);
        FormData fdlFieldname = new FormData();
        fdlFieldname.left = new FormAttachment(0, 0);
        fdlFieldname.right = new FormAttachment(middle, -margin);
        fdlFieldname.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFieldname.setLayoutData((Object)fdlFieldname);
        this.wFieldName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wFieldName);
        this.wFieldName.addModifyListener(lsMod);
        FormData fdFieldname = new FormData();
        fdFieldname.left = new FormAttachment(middle, 0);
        fdFieldname.top = new FormAttachment((Control)this.wTransformName, margin);
        fdFieldname.right = new FormAttachment(100, 0);
        this.wFieldName.setLayoutData((Object)fdFieldname);
        this.wFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ValueMapperDialog.this.shell.getDisplay(), 1);
                ValueMapperDialog.this.shell.setCursor(busy);
                ValueMapperDialog.this.getFields();
                ValueMapperDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlTargetFieldname = new Label((Composite)this.shell, 131072);
        wlTargetFieldname.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.TargetFieldname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetFieldname);
        FormData fdlTargetFieldname = new FormData();
        fdlTargetFieldname.left = new FormAttachment(0, 0);
        fdlTargetFieldname.right = new FormAttachment(middle, -margin);
        fdlTargetFieldname.top = new FormAttachment((Control)this.wFieldName, margin);
        wlTargetFieldname.setLayoutData((Object)fdlTargetFieldname);
        this.wTargetFieldName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTargetFieldName);
        this.wTargetFieldName.addModifyListener(lsMod);
        FormData fdTargetFieldname = new FormData();
        fdTargetFieldname.left = new FormAttachment(middle, 0);
        fdTargetFieldname.top = new FormAttachment((Control)this.wFieldName, margin);
        fdTargetFieldname.right = new FormAttachment(100, 0);
        this.wTargetFieldName.setLayoutData((Object)fdTargetFieldname);
        Label wlNonMatchDefault = new Label((Composite)this.shell, 131072);
        wlNonMatchDefault.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.NonMatchDefault.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNonMatchDefault);
        FormData fdlNonMatchDefault = new FormData();
        fdlNonMatchDefault.left = new FormAttachment(0, 0);
        fdlNonMatchDefault.right = new FormAttachment(middle, -margin);
        fdlNonMatchDefault.top = new FormAttachment((Control)this.wTargetFieldName, margin);
        wlNonMatchDefault.setLayoutData((Object)fdlNonMatchDefault);
        this.wNonMatchDefault = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wNonMatchDefault);
        this.wNonMatchDefault.addModifyListener(lsMod);
        FormData fdNonMatchDefault = new FormData();
        fdNonMatchDefault.left = new FormAttachment(middle, 0);
        fdNonMatchDefault.top = new FormAttachment((Control)this.wTargetFieldName, margin);
        fdNonMatchDefault.right = new FormAttachment(100, 0);
        this.wNonMatchDefault.setLayoutData((Object)fdNonMatchDefault);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wNonMatchDefault, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 2;
        int FieldsRows = this.input.getValues().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ValueMapperDialog.Fields.Column.SourceValue", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ValueMapperDialog.Fields.Column.TargetValue", (String[])new String[0]), 1, false)};
        colinf[1].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String fieldname = this.wFieldName.getText();
                this.wFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wFieldName.setItems(r.getFieldNames());
                    if (fieldname != null) {
                        this.wFieldName.setText(fieldname);
                    }
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ValueMapperDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ValueMapperDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        if (this.input.getFieldToUse() != null) {
            this.wFieldName.setText(this.input.getFieldToUse());
        }
        if (this.input.getTargetField() != null) {
            this.wTargetFieldName.setText(this.input.getTargetField());
        }
        if (this.input.getNonMatchDefault() != null) {
            this.wNonMatchDefault.setText(this.input.getNonMatchDefault());
        }
        int i = 0;
        for (Values v : this.input.getValues()) {
            TableItem item = this.wFields.table.getItem(i++);
            String src = v.getSource();
            String tgt = v.getTarget();
            if (src != null) {
                item.setText(1, src);
            }
            if (tgt == null) continue;
            item.setText(2, tgt);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setFieldToUse(this.wFieldName.getText());
        this.input.setTargetField(this.wTargetFieldName.getText());
        this.input.setNonMatchDefault(this.wNonMatchDefault.getText());
        this.input.getValues().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            Values v = new Values();
            v.setSource(Utils.isEmpty((CharSequence)item.getText(1)) ? null : item.getText(1));
            v.setTarget(item.getText(2));
            this.input.getValues().add(v);
        }
        this.dispose();
    }
}

