/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.caching;

import io.netty.util.concurrent.FastThreadLocal;

public class TinyThreadLocalPool<V>
extends FastThreadLocal<TinyPool<V>> {
    protected TinyPool<V> initialValue() {
        return new TinyPool();
    }

    public void offer(V value) {
        ((TinyPool)this.get()).offer(value);
    }

    public V poll() {
        return ((TinyPool)this.get()).poll();
    }

    public static class TinyPool<V> {
        final Thread thread = Thread.currentThread();
        Object val1;
        Object val2;
        Object val3;

        public void offer(V value) {
            if (Thread.currentThread() == this.thread) {
                this.offerSafe(value);
            }
        }

        private void offerSafe(V value) {
            if (this.val1 == null) {
                this.val1 = value;
            } else if (this.val2 == null) {
                this.val2 = value;
            } else if (this.val3 == null) {
                this.val3 = value;
            }
        }

        public V poll() {
            Object result;
            if (this.val1 != null) {
                result = this.val1;
                this.val1 = null;
            } else if (this.val2 != null) {
                result = this.val2;
                this.val2 = null;
            } else if (this.val3 != null) {
                result = this.val3;
                this.val3 = null;
            } else {
                result = null;
            }
            return (V)result;
        }
    }
}

