/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.sdk.schemas.AutoValue_Schema_Field;
import org.apache.beam.sdk.schemas.AutoValue_Schema_FieldType;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.SchemaVerification;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashBiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class Schema
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized BiMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> fieldIndices = HashBiMap.create();
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> encodingPositions = Maps.newHashMap();
    private @UnknownKeyFor @NonNull @Initialized boolean encodingPositionsOverridden = false;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> fields;
    private final @UnknownKeyFor @NonNull @Initialized int hashCode;
    private @Nullable @UnknownKeyFor @Initialized UUID uuid = null;
    private final @UnknownKeyFor @NonNull @Initialized Options options;

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new Builder();
    }

    public Schema(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> fields) {
        this(fields, Options.none());
    }

    public Schema(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> fields, @UnknownKeyFor @NonNull @Initialized Options options) {
        this.fields = fields;
        int index = 0;
        for (Field field : fields) {
            Preconditions.checkArgument((this.fieldIndices.get((Object)field.getName()) == null ? 1 : 0) != 0, (Object)("Duplicate field " + field.getName() + " added to schema"));
            this.encodingPositions.put(field.getName(), index);
            this.fieldIndices.put((Object)field.getName(), (Object)index++);
        }
        this.hashCode = Objects.hash(this.fieldIndices, fields);
        this.options = options;
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema of(Field ... fields) {
        return Schema.builder().addFields(fields).build();
    }

    public @UnknownKeyFor @NonNull @Initialized Schema sorted() {
        Schema sortedSchema = this.fields.stream().sorted(Comparator.comparing(Field::getName)).collect(Schema.toSchema()).withOptions(this.getOptions());
        sortedSchema.setUUID(this.getUUID());
        return sortedSchema;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema withOptions(@UnknownKeyFor @NonNull @Initialized Options options) {
        return new Schema(this.fields, this.getOptions().toBuilder().addOptions(options).build());
    }

    public @UnknownKeyFor @NonNull @Initialized Schema withOptions(@UnknownKeyFor @NonNull @Initialized Options.Builder optionsBuilder) {
        return this.withOptions(optionsBuilder.build());
    }

    public void setUUID(@UnknownKeyFor @NonNull @Initialized UUID uuid) {
        this.uuid = uuid;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> getEncodingPositions() {
        return this.encodingPositions;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEncodingPositionsOverridden() {
        return this.encodingPositionsOverridden;
    }

    public void setEncodingPositions(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> encodingPositions) {
        this.encodingPositions = encodingPositions;
        this.encodingPositionsOverridden = true;
    }

    public @Nullable @UnknownKeyFor @Initialized UUID getUUID() {
        return this.uuid;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema other = (Schema)o;
        if (this.uuid != null && other.uuid != null && Objects.equals(this.uuid, other.uuid)) {
            return true;
        }
        return Objects.equals(this.fieldIndices, other.fieldIndices) && Objects.equals(this.getFields(), other.getFields()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean typesEqual(@UnknownKeyFor @NonNull @Initialized Schema other) {
        if (this.uuid != null && other.uuid != null && Objects.equals(this.uuid, other.uuid)) {
            return true;
        }
        if (this.getFieldCount() != other.getFieldCount()) {
            return false;
        }
        if (!Objects.equals(this.fieldIndices.values(), other.fieldIndices.values())) {
            return false;
        }
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (this.getField(i).typesEqual(other.getField(i))) continue;
            return false;
        }
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean equivalent(@UnknownKeyFor @NonNull @Initialized Schema other) {
        return this.equivalent(other, EquivalenceNullablePolicy.SAME);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean assignableTo(@UnknownKeyFor @NonNull @Initialized Schema other) {
        return this.equivalent(other, EquivalenceNullablePolicy.WEAKEN);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean assignableToIgnoreNullable(@UnknownKeyFor @NonNull @Initialized Schema other) {
        return this.equivalent(other, EquivalenceNullablePolicy.IGNORE);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean equivalent(@UnknownKeyFor @NonNull @Initialized Schema other, @UnknownKeyFor @NonNull @Initialized EquivalenceNullablePolicy nullablePolicy) {
        if (other.getFieldCount() != this.getFieldCount()) {
            return false;
        }
        List otherFields = other.getFields().stream().sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
        List actualFields = this.getFields().stream().sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
        for (int i = 0; i < otherFields.size(); ++i) {
            Field otherField = (Field)otherFields.get(i);
            Field actualField = (Field)actualFields.get(i);
            if (actualField.equivalent(otherField, nullablePolicy)) continue;
            return false;
        }
        return true;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Fields:");
        builder.append(System.lineSeparator());
        for (Field field : this.fields) {
            builder.append(field);
            builder.append(System.lineSeparator());
        }
        builder.append("Encoding positions:");
        builder.append(System.lineSeparator());
        builder.append(this.encodingPositions);
        builder.append(System.lineSeparator());
        builder.append("Options:");
        builder.append(this.options);
        builder.append("UUID: " + this.uuid);
        return builder.toString();
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.hashCode;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> getFields() {
        return this.fields;
    }

    public static @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized Field, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field>, @UnknownKeyFor @NonNull @Initialized Schema> toSchema() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Schema::fromFields, new Collector.Characteristics[0]);
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema fromFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> fields) {
        return new Schema(fields);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getFieldNames() {
        return this.getFields().stream().map(Field::getName).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized Field getField(@UnknownKeyFor @NonNull @Initialized int index) {
        return this.getFields().get(index);
    }

    public @UnknownKeyFor @NonNull @Initialized Field getField(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.getFields().get(this.indexOf(name));
    }

    public @UnknownKeyFor @NonNull @Initialized int indexOf(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        Integer index = (Integer)this.fieldIndices.get((Object)fieldName);
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (String)"Cannot find field %s in schema %s", (Object)fieldName, (Object)this);
        return index;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasField(@UnknownKeyFor @NonNull @Initialized String fieldName) {
        return this.fieldIndices.containsKey((Object)fieldName);
    }

    public @UnknownKeyFor @NonNull @Initialized String nameOf(@UnknownKeyFor @NonNull @Initialized int fieldIndex) {
        String name = (String)this.fieldIndices.inverse().get((Object)fieldIndex);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Cannot find field %s", (int)fieldIndex);
        return name;
    }

    public @UnknownKeyFor @NonNull @Initialized int getFieldCount() {
        return this.getFields().size();
    }

    public @UnknownKeyFor @NonNull @Initialized Options getOptions() {
        return this.options;
    }

    public static class Options
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Option> options;

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            TreeMap<String, Option> sorted = new TreeMap<String, Option>(this.options);
            return "{" + sorted + '}';
        }

        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Option> getAllOptions() {
            return this.options;
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getOptionNames() {
            return this.options.keySet();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasOptions() {
            return this.options.size() > 0;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasOption(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.options.containsKey(name);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Options options1 = (Options)o;
            if (!this.options.keySet().equals(options1.options.keySet())) {
                return false;
            }
            for (Map.Entry<String, Option> optionEntry : this.options.entrySet()) {
                Option otherOption;
                Option thisOption = optionEntry.getValue();
                if (thisOption.equals(otherOption = options1.options.get(optionEntry.getKey()))) continue;
                return false;
            }
            return true;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.options);
        }

        Options(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Option> options) {
            this.options = options;
        }

        Options() {
            this.options = new HashMap<String, Option>();
        }

        @UnknownKeyFor @NonNull @Initialized Builder toBuilder() {
            return new Builder(new HashMap<String, Option>(this.options));
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new Builder();
        }

        public static @UnknownKeyFor @NonNull @Initialized Options none() {
            return new Options();
        }

        public <T> T getValue(@UnknownKeyFor @NonNull @Initialized String optionName) {
            Option option = this.options.get(optionName);
            if (option != null) {
                return option.getValue();
            }
            throw new IllegalArgumentException(String.format("No option found with name %s.", optionName));
        }

        public <T> T getValue(@UnknownKeyFor @NonNull @Initialized String optionName, @UnknownKeyFor @NonNull @Initialized Class<T> valueClass) {
            return this.getValue(optionName);
        }

        public <T> T getValueOrDefault(@UnknownKeyFor @NonNull @Initialized String optionName, T defaultValue) {
            Option option = this.options.get(optionName);
            if (option != null) {
                return option.getValue();
            }
            return defaultValue;
        }

        public @UnknownKeyFor @NonNull @Initialized FieldType getType(@UnknownKeyFor @NonNull @Initialized String optionName) {
            Option option = this.options.get(optionName);
            if (option != null) {
                return option.getType();
            }
            throw new IllegalArgumentException(String.format("No option found with name %s.", optionName));
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder setOption(@UnknownKeyFor @NonNull @Initialized String optionName, @UnknownKeyFor @NonNull @Initialized FieldType fieldType, @UnknownKeyFor @NonNull @Initialized Object value) {
            return Options.builder().setOption(optionName, fieldType, value);
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder setOption(@UnknownKeyFor @NonNull @Initialized String optionName, @UnknownKeyFor @NonNull @Initialized Row value) {
            return Options.builder().setOption(optionName, value);
        }

        public static class Builder {
            private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Option> options;

            Builder(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Option> init) {
                this.options = new HashMap<String, Option>(init);
            }

            Builder() {
                this(new HashMap<String, Option>());
            }

            public @UnknownKeyFor @NonNull @Initialized Builder setOption(@UnknownKeyFor @NonNull @Initialized String optionName, @UnknownKeyFor @NonNull @Initialized Row value) {
                this.setOption(optionName, FieldType.row(value.getSchema()), value);
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public @UnknownKeyFor @NonNull @Initialized Builder setOption(@UnknownKeyFor @NonNull @Initialized String optionName, @UnknownKeyFor @NonNull @Initialized FieldType fieldType, @UnknownKeyFor @NonNull @Initialized Object value) {
                if (value == null) {
                    if (!fieldType.getNullable().booleanValue()) throw new IllegalArgumentException(String.format("Option %s is not nullable", optionName));
                    this.options.put(optionName, new Option(fieldType, null));
                    return this;
                } else {
                    this.options.put(optionName, new Option(fieldType, SchemaVerification.verifyFieldValue(value, fieldType, optionName)));
                }
                return this;
            }

            public @UnknownKeyFor @NonNull @Initialized Options build() {
                return new Options(this.options);
            }

            public @UnknownKeyFor @NonNull @Initialized Builder addOptions(@UnknownKeyFor @NonNull @Initialized Options options) {
                this.options.putAll(options.options);
                return this;
            }
        }

        static class Option
        implements Serializable {
            private @UnknownKeyFor @NonNull @Initialized FieldType type;
            private @UnknownKeyFor @NonNull @Initialized Object value;

            Option(@UnknownKeyFor @NonNull @Initialized FieldType type, @UnknownKeyFor @NonNull @Initialized Object value) {
                this.type = type;
                this.value = value;
            }

            <T> T getValue() {
                return (T)this.value;
            }

            @UnknownKeyFor @NonNull @Initialized FieldType getType() {
                return this.type;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return "Option{type=" + this.type + ", value=" + this.value + '}';
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Option option = (Option)o;
                return Objects.equals(this.type, option.type) && Row.Equals.deepEquals(this.value, option.value, this.type);
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return Row.Equals.deepHashCode(this.value, this.type);
            }
        }
    }

    @AutoValue
    public static abstract class Field
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized String getName();

        public abstract @UnknownKeyFor @NonNull @Initialized String getDescription();

        public abstract @UnknownKeyFor @NonNull @Initialized FieldType getType();

        public abstract @UnknownKeyFor @NonNull @Initialized Options getOptions();

        public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public static @UnknownKeyFor @NonNull @Initialized Field of(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType fieldType) {
            return new AutoValue_Schema_Field.Builder().setName(name).setDescription("").setType(fieldType).setOptions(Options.none()).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized Field nullable(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType fieldType) {
            return new AutoValue_Schema_Field.Builder().setName(name).setDescription("").setType(fieldType.withNullable(true)).setOptions(Options.none()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Field withName(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.toBuilder().setName(name).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Field withDescription(@UnknownKeyFor @NonNull @Initialized String description) {
            return this.toBuilder().setDescription(description).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Field withType(@UnknownKeyFor @NonNull @Initialized FieldType fieldType) {
            return this.toBuilder().setType(fieldType).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Field withNullable(@UnknownKeyFor @NonNull @Initialized boolean isNullable) {
            return this.toBuilder().setType(this.getType().withNullable(isNullable)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Field withOptions(@UnknownKeyFor @NonNull @Initialized Options options) {
            return this.toBuilder().setOptions(this.getOptions().toBuilder().addOptions(options).build()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Field withOptions(@UnknownKeyFor @NonNull @Initialized Options.Builder optionsBuilder) {
            return this.withOptions(optionsBuilder.build());
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public final @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.getOptions(), other.getOptions());
        }

        public @UnknownKeyFor @NonNull @Initialized boolean typesEqual(@UnknownKeyFor @NonNull @Initialized Field other) {
            return this.getType().typesEqual(other.getType());
        }

        private @UnknownKeyFor @NonNull @Initialized boolean equivalent(@UnknownKeyFor @NonNull @Initialized Field otherField, @UnknownKeyFor @NonNull @Initialized EquivalenceNullablePolicy nullablePolicy) {
            return this.getName().equals(otherField.getName()) && this.getType().equivalent(otherField.getType(), nullablePolicy);
        }

        @Pure
        public final @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getName(), this.getDescription(), this.getType());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDescription(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setType(@UnknownKeyFor @NonNull @Initialized FieldType var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setOptions(@UnknownKeyFor @NonNull @Initialized Options var1);

            public @UnknownKeyFor @NonNull @Initialized Builder setOptions(@UnknownKeyFor @NonNull @Initialized Options.Builder optionsBuilder) {
                this.setOptions(optionsBuilder.build());
                return this;
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Field build();
        }
    }

    @AutoValue
    @Immutable
    public static abstract class FieldType
    implements Serializable {
        public static final @UnknownKeyFor @NonNull @Initialized FieldType STRING = FieldType.of(TypeName.STRING);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType BYTE = FieldType.of(TypeName.BYTE);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType BYTES = FieldType.of(TypeName.BYTES);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType INT16 = FieldType.of(TypeName.INT16);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType INT32 = FieldType.of(TypeName.INT32);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType INT64 = FieldType.of(TypeName.INT64);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType FLOAT = FieldType.of(TypeName.FLOAT);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType DOUBLE = FieldType.of(TypeName.DOUBLE);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType DECIMAL = FieldType.of(TypeName.DECIMAL);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType BOOLEAN = FieldType.of(TypeName.BOOLEAN);
        public static final @UnknownKeyFor @NonNull @Initialized FieldType DATETIME = FieldType.of(TypeName.DATETIME);

        public abstract @UnknownKeyFor @NonNull @Initialized TypeName getTypeName();

        public abstract @UnknownKeyFor @NonNull @Initialized Boolean getNullable();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized LogicalType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getLogicalType();

        public abstract @Nullable @UnknownKeyFor @Initialized FieldType getCollectionElementType();

        public abstract @Nullable @UnknownKeyFor @Initialized FieldType getMapKeyType();

        public abstract @Nullable @UnknownKeyFor @Initialized FieldType getMapValueType();

        public abstract @Nullable @UnknownKeyFor @Initialized Schema getRowSchema();

        @Deprecated
        abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteArrayWrapper> getMetadata();

        public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized boolean isLogicalType(@UnknownKeyFor @NonNull @Initialized String logicalTypeIdentifier) {
            return this.getTypeName().isLogicalType() && this.getLogicalType().getIdentifier().equals(logicalTypeIdentifier);
        }

        public <InputT, BaseT, LogicalTypeT extends LogicalType<InputT, BaseT>> LogicalTypeT getLogicalType(@UnknownKeyFor @NonNull @Initialized Class<LogicalTypeT> logicalTypeClass) {
            return (LogicalTypeT)((LogicalType)logicalTypeClass.cast(this.getLogicalType()));
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder forTypeName(@UnknownKeyFor @NonNull @Initialized TypeName typeName) {
            return new AutoValue_Schema_FieldType.Builder().setTypeName(typeName).setNullable(false).setMetadata(Collections.emptyMap());
        }

        public static @UnknownKeyFor @NonNull @Initialized FieldType of(@UnknownKeyFor @NonNull @Initialized TypeName typeName) {
            return FieldType.forTypeName(typeName).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized FieldType array(@UnknownKeyFor @NonNull @Initialized FieldType elementType) {
            return FieldType.forTypeName(TypeName.ARRAY).setCollectionElementType(elementType).build();
        }

        @Deprecated
        public static @UnknownKeyFor @NonNull @Initialized FieldType array(@UnknownKeyFor @NonNull @Initialized FieldType elementType, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
            return FieldType.forTypeName(TypeName.ARRAY).setCollectionElementType(elementType.withNullable(nullable)).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized FieldType iterable(@UnknownKeyFor @NonNull @Initialized FieldType elementType) {
            return FieldType.forTypeName(TypeName.ITERABLE).setCollectionElementType(elementType).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized FieldType map(@UnknownKeyFor @NonNull @Initialized FieldType keyType, @UnknownKeyFor @NonNull @Initialized FieldType valueType) {
            return FieldType.forTypeName(TypeName.MAP).setMapKeyType(keyType).setMapValueType(valueType).build();
        }

        @Deprecated
        public static @UnknownKeyFor @NonNull @Initialized FieldType map(@UnknownKeyFor @NonNull @Initialized FieldType keyType, @UnknownKeyFor @NonNull @Initialized FieldType valueType, @UnknownKeyFor @NonNull @Initialized boolean valueTypeNullable) {
            return FieldType.forTypeName(TypeName.MAP).setMapKeyType(keyType).setMapValueType(valueType.withNullable(valueTypeNullable)).build();
        }

        public static @UnknownKeyFor @NonNull @Initialized FieldType row(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            return FieldType.forTypeName(TypeName.ROW).setRowSchema(schema).build();
        }

        public static <InputT, BaseT> @UnknownKeyFor @NonNull @Initialized FieldType logicalType(@UnknownKeyFor @NonNull @Initialized LogicalType<InputT, BaseT> logicalType) {
            return FieldType.forTypeName(TypeName.LOGICAL_TYPE).setLogicalType(logicalType).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized FieldType withMetadata(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> metadata) {
            Map<String, ByteArrayWrapper> wrapped = metadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ByteArrayWrapper.wrap((byte[])e.getValue())));
            return this.toBuilder().setMetadata(wrapped).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized FieldType withMetadata(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] metadata) {
            ImmutableMap newMetadata = ImmutableMap.builder().putAll(this.getMetadata()).put((Object)key, (Object)ByteArrayWrapper.wrap(metadata)).build();
            return this.toBuilder().setMetadata((Map<String, ByteArrayWrapper>)newMetadata).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized FieldType withMetadata(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized String metadata) {
            return this.withMetadata(key, metadata.getBytes(StandardCharsets.UTF_8));
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getAllMetadata() {
            return this.getMetadata().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ByteArrayWrapper)e.getValue()).array));
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getMetadata(@UnknownKeyFor @NonNull @Initialized String key) {
            ByteArrayWrapper metadata = this.getMetadata().get(key);
            return metadata != null ? metadata.array : null;
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized String getMetadataString(@UnknownKeyFor @NonNull @Initialized String key) {
            ByteArrayWrapper metadata = this.getMetadata().get(key);
            if (metadata != null) {
                return new String(metadata.array, StandardCharsets.UTF_8);
            }
            return "";
        }

        public @UnknownKeyFor @NonNull @Initialized FieldType withNullable(@UnknownKeyFor @NonNull @Initialized boolean nullable) {
            return this.toBuilder().setNullable(nullable).build();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public final @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (!(o instanceof FieldType)) {
                return false;
            }
            FieldType other = (FieldType)o;
            if (this.getTypeName().isLogicalType()) {
                if (!other.getTypeName().isLogicalType()) {
                    return false;
                }
                if (!Objects.equals(this.getLogicalType().getIdentifier(), other.getLogicalType().getIdentifier())) {
                    return false;
                }
                if (this.getLogicalType().getArgument() == null) {
                    if (other.getLogicalType().getArgument() != null) {
                        return false;
                    }
                } else {
                    if (!this.getLogicalType().getArgumentType().equals(other.getLogicalType().getArgumentType())) {
                        return false;
                    }
                    if (!Row.Equals.deepEquals(this.getLogicalType().getArgument(), other.getLogicalType().getArgument(), this.getLogicalType().getArgumentType())) {
                        return false;
                    }
                }
            }
            return Objects.equals((Object)this.getTypeName(), (Object)other.getTypeName()) && Objects.equals(this.getNullable(), other.getNullable()) && Objects.equals(this.getCollectionElementType(), other.getCollectionElementType()) && Objects.equals(this.getMapKeyType(), other.getMapKeyType()) && Objects.equals(this.getMapValueType(), other.getMapValueType()) && Objects.equals(this.getRowSchema(), other.getRowSchema()) && Objects.equals(this.getMetadata(), other.getMetadata());
        }

        public @UnknownKeyFor @NonNull @Initialized boolean typesEqual(@UnknownKeyFor @NonNull @Initialized FieldType other) {
            if (!Objects.equals((Object)this.getTypeName(), (Object)other.getTypeName())) {
                return false;
            }
            if (this.getTypeName().isLogicalType()) {
                if (!other.getTypeName().isLogicalType()) {
                    return false;
                }
                if (!Objects.equals(this.getLogicalType().getIdentifier(), other.getLogicalType().getIdentifier())) {
                    return false;
                }
                if (!this.getLogicalType().getArgumentType().equals(other.getLogicalType().getArgumentType())) {
                    return false;
                }
                if (!Row.Equals.deepEquals(this.getLogicalType().getArgument(), other.getLogicalType().getArgument(), this.getLogicalType().getArgumentType())) {
                    return false;
                }
            }
            if (!Objects.equals(this.getNullable(), other.getNullable())) {
                return false;
            }
            if (!Objects.equals(this.getMetadata(), other.getMetadata())) {
                return false;
            }
            if (this.getTypeName().isCollectionType() && !this.getCollectionElementType().typesEqual(other.getCollectionElementType())) {
                return false;
            }
            if (!(this.getTypeName() != TypeName.MAP || this.getMapValueType().typesEqual(other.getMapValueType()) && this.getMapKeyType().typesEqual(other.getMapKeyType()))) {
                return false;
            }
            return this.getTypeName() != TypeName.ROW || this.getRowSchema().typesEqual(other.getRowSchema());
        }

        public @UnknownKeyFor @NonNull @Initialized boolean equivalent(@UnknownKeyFor @NonNull @Initialized FieldType other, @UnknownKeyFor @NonNull @Initialized EquivalenceNullablePolicy nullablePolicy) {
            if (nullablePolicy == EquivalenceNullablePolicy.SAME && !other.getNullable().equals(this.getNullable())) {
                return false;
            }
            if (nullablePolicy == EquivalenceNullablePolicy.WEAKEN && this.getNullable().booleanValue() && !other.getNullable().booleanValue()) {
                return false;
            }
            if (!this.getTypeName().equals((Object)other.getTypeName())) {
                return false;
            }
            switch (this.getTypeName()) {
                case ROW: {
                    if (this.getRowSchema().equivalent(other.getRowSchema(), nullablePolicy)) break;
                    return false;
                }
                case ARRAY: 
                case ITERABLE: {
                    if (this.getCollectionElementType().equivalent(other.getCollectionElementType(), nullablePolicy)) break;
                    return false;
                }
                case MAP: {
                    if (this.getMapKeyType().equivalent(other.getMapKeyType(), nullablePolicy) && this.getMapValueType().equivalent(other.getMapValueType(), nullablePolicy)) break;
                    return false;
                }
                default: {
                    return true;
                }
            }
            return true;
        }

        @Pure
        public final @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Arrays.deepHashCode(new Object[]{this.getTypeName(), this.getNullable(), this.getCollectionElementType(), this.getMapKeyType(), this.getMapValueType(), this.getRowSchema(), this.getMetadata()});
        }

        @SideEffectFree
        public final @UnknownKeyFor @NonNull @Initialized String toString() {
            StringBuilder builder = new StringBuilder();
            switch (this.getTypeName()) {
                case ROW: {
                    builder.append("ROW<");
                    ImmutableList.Builder fieldEntries = ImmutableList.builder();
                    for (Field field : this.getRowSchema().getFields()) {
                        fieldEntries.add((Object)(field.getName() + " " + field.getType().toString()));
                    }
                    builder.append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)fieldEntries.build()));
                    builder.append(">");
                    break;
                }
                case ARRAY: {
                    builder.append("ARRAY<");
                    builder.append(this.getCollectionElementType().toString());
                    builder.append(">");
                    break;
                }
                case MAP: {
                    builder.append("MAP<");
                    builder.append(this.getMapKeyType().toString());
                    builder.append(", ");
                    builder.append(this.getMapValueType().toString());
                    builder.append(">");
                    break;
                }
                case LOGICAL_TYPE: {
                    builder.append("LOGICAL_TYPE<");
                    if (this.getLogicalType() != null) {
                        builder.append(this.getLogicalType().getIdentifier());
                    }
                    builder.append(">");
                    break;
                }
                default: {
                    builder.append(this.getTypeName().toString());
                }
            }
            if (!this.getNullable().booleanValue()) {
                builder.append(" NOT NULL");
            }
            return builder.toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTypeName(@UnknownKeyFor @NonNull @Initialized TypeName var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setLogicalType(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized LogicalType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCollectionElementType(@Nullable @UnknownKeyFor @Initialized FieldType var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setNullable(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMapKeyType(@Nullable @UnknownKeyFor @Initialized FieldType var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMapValueType(@Nullable @UnknownKeyFor @Initialized FieldType var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRowSchema(@Nullable @UnknownKeyFor @Initialized Schema var1);

            @Deprecated
            abstract @UnknownKeyFor @NonNull @Initialized Builder setMetadata(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteArrayWrapper> var1);

            abstract @UnknownKeyFor @NonNull @Initialized FieldType build();
        }
    }

    public static interface LogicalType<@UnknownKeyFor InputT, @UnknownKeyFor BaseT>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized String getIdentifier();

        public @Nullable @UnknownKeyFor @Initialized FieldType getArgumentType();

        default public <T> @Nullable T getArgument() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized FieldType getBaseType();

        public @NonNull BaseT toBaseType(@NonNull InputT var1);

        public @NonNull InputT toInputType(@NonNull BaseT var1);
    }

    public static enum TypeName {
        BYTE,
        INT16,
        INT32,
        INT64,
        DECIMAL,
        FLOAT,
        DOUBLE,
        STRING,
        DATETIME,
        BOOLEAN,
        BYTES,
        ARRAY,
        ITERABLE,
        MAP,
        ROW,
        LOGICAL_TYPE;

        public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeName> NUMERIC_TYPES;
        public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeName> STRING_TYPES;
        public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeName> DATE_TYPES;
        public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeName> COLLECTION_TYPES;
        public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeName> MAP_TYPES;
        public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TypeName> COMPOSITE_TYPES;

        public @UnknownKeyFor @NonNull @Initialized boolean isPrimitiveType() {
            return !this.isCollectionType() && !this.isMapType() && !this.isCompositeType() && !this.isLogicalType();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isNumericType() {
            return NUMERIC_TYPES.contains((Object)this);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isStringType() {
            return STRING_TYPES.contains((Object)this);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isDateType() {
            return DATE_TYPES.contains((Object)this);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isCollectionType() {
            return COLLECTION_TYPES.contains((Object)this);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isMapType() {
            return MAP_TYPES.contains((Object)this);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isCompositeType() {
            return COMPOSITE_TYPES.contains((Object)this);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isLogicalType() {
            return this.equals((Object)LOGICAL_TYPE);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isSubtypeOf(@UnknownKeyFor @NonNull @Initialized TypeName other) {
            return other.isSupertypeOf(this);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isSupertypeOf(@UnknownKeyFor @NonNull @Initialized TypeName other) {
            if (this == other) {
                return true;
            }
            if (!this.isNumericType() || !other.isNumericType()) {
                return false;
            }
            switch (this) {
                case BYTE: {
                    return false;
                }
                case INT16: {
                    return other == BYTE;
                }
                case INT32: {
                    return other == BYTE || other == INT16;
                }
                case INT64: {
                    return other == BYTE || other == INT16 || other == INT32;
                }
                case FLOAT: {
                    return false;
                }
                case DOUBLE: {
                    return other == FLOAT;
                }
                case DECIMAL: {
                    return other == FLOAT || other == DOUBLE;
                }
            }
            throw new AssertionError((Object)("Unexpected numeric type: " + (Object)((Object)this)));
        }

        static {
            NUMERIC_TYPES = ImmutableSet.of((Object)((Object)BYTE), (Object)((Object)INT16), (Object)((Object)INT32), (Object)((Object)INT64), (Object)((Object)DECIMAL), (Object)((Object)FLOAT), (Object[])new TypeName[]{DOUBLE});
            STRING_TYPES = ImmutableSet.of((Object)((Object)STRING));
            DATE_TYPES = ImmutableSet.of((Object)((Object)DATETIME));
            COLLECTION_TYPES = ImmutableSet.of((Object)((Object)ARRAY), (Object)((Object)ITERABLE));
            MAP_TYPES = ImmutableSet.of((Object)((Object)MAP));
            COMPOSITE_TYPES = ImmutableSet.of((Object)((Object)ROW));
        }
    }

    public static enum EquivalenceNullablePolicy {
        SAME,
        WEAKEN,
        IGNORE;

    }

    public static class Builder {
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> fields;
        @UnknownKeyFor @NonNull @Initialized Options options = Options.none();

        public Builder() {
            this.fields = Lists.newArrayList();
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Field> fields) {
            this.fields.addAll(fields);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addFields(Field ... fields) {
            return this.addFields(Arrays.asList(fields));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addField(@UnknownKeyFor @NonNull @Initialized Field field) {
            this.fields.add(field);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType type) {
            this.fields.add(Field.of(name, type));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType type) {
            this.fields.add(Field.nullable(name, type));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addByteField(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.BYTE));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableByteField(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.BYTE);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addByteArrayField(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.BYTES));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableByteArrayField(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.BYTES);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addInt16Field(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.INT16));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableInt16Field(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.INT16);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addInt32Field(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.INT32));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableInt32Field(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.INT32);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addInt64Field(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.INT64));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableInt64Field(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.INT64);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addDecimalField(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.DECIMAL));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableDecimalField(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.DECIMAL);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addFloatField(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.FLOAT));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableFloatField(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.FLOAT);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addDoubleField(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.DOUBLE));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableDoubleField(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.DOUBLE);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addStringField(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.STRING));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableStringField(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.STRING);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addDateTimeField(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.DATETIME));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableDateTimeField(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.DATETIME);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addBooleanField(@UnknownKeyFor @NonNull @Initialized String name) {
            this.fields.add(Field.of(name, FieldType.BOOLEAN));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableBooleanField(@UnknownKeyFor @NonNull @Initialized String name) {
            return this.addNullableField(name, FieldType.BOOLEAN);
        }

        public <InputT, BaseT> @UnknownKeyFor @NonNull @Initialized Builder addLogicalTypeField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized LogicalType<InputT, BaseT> logicalType) {
            this.fields.add(Field.of(name, FieldType.logicalType(logicalType)));
            return this;
        }

        public <InputT, BaseT> @UnknownKeyFor @NonNull @Initialized Builder addNullableLogicalTypeField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized LogicalType<InputT, BaseT> logicalType) {
            return this.addNullableField(name, FieldType.logicalType(logicalType));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addArrayField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType collectionElementType) {
            this.fields.add(Field.of(name, FieldType.array(collectionElementType)));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableArrayField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType collectionElementType) {
            return this.addNullableField(name, FieldType.array(collectionElementType));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addIterableField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType collectionElementType) {
            this.fields.add(Field.of(name, FieldType.iterable(collectionElementType)));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableIterableField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType collectionElementType) {
            return this.addNullableField(name, FieldType.iterable(collectionElementType));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addRowField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema fieldSchema) {
            this.fields.add(Field.of(name, FieldType.row(fieldSchema)));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableRowField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Schema fieldSchema) {
            return this.addNullableField(name, FieldType.row(fieldSchema));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addMapField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType keyType, @UnknownKeyFor @NonNull @Initialized FieldType valueType) {
            this.fields.add(Field.of(name, FieldType.map(keyType, valueType)));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder addNullableMapField(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized FieldType keyType, @UnknownKeyFor @NonNull @Initialized FieldType valueType) {
            return this.addNullableField(name, FieldType.map(keyType, valueType));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setOptions(@UnknownKeyFor @NonNull @Initialized Options options) {
            this.options = options;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder setOptions(@UnknownKeyFor @NonNull @Initialized Options.Builder optionsBuilder) {
            this.options = optionsBuilder.build();
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized int getLastFieldId() {
            return this.fields.size() - 1;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema build() {
            return new Schema(this.fields, this.options);
        }
    }

    static class ByteArrayWrapper
    implements Serializable {
        final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] array;

        private ByteArrayWrapper(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] array) {
            this.array = array;
        }

        static @UnknownKeyFor @NonNull @Initialized ByteArrayWrapper wrap(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] array) {
            return new ByteArrayWrapper(array);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (!(other instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.array, ((ByteArrayWrapper)other).array);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return Arrays.toString(this.array);
        }
    }
}

