/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AS400DecFloat
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int digits;
    private static final long defaultValue = 0L;
    static final boolean HIGH_NIBBLE = true;
    static final boolean LOW_NIBBLE = false;
    private static final int DEC_FLOAT_16_BIAS = 398;
    private static final long DEC_FLOAT_16_SIGNAL_MASK = 0x200000000000000L;
    private static final long DEC_FLOAT_16_SIGN_MASK = Long.MIN_VALUE;
    private static final long DEC_FLOAT_16_COMBINATION_MASK = 0x7C00000000000000L;
    private static final long DEC_FLOAT_16_EXPONENT_CONTINUATION_MASK = 287104476244869120L;
    private static final long DEC_FLOAT_16_COEFFICIENT_CONTINUATION_MASK = 0x3FFFFFFFFFFFFL;
    private static final int DEC_FLOAT_34_BIAS = 6176;
    private static final long DEC_FLOAT_34_SIGNAL_MASK = 0x200000000000000L;
    private static final long DEC_FLOAT_34_SIGN_MASK = Long.MIN_VALUE;
    private static final long DEC_FLOAT_34_COMBINATION_MASK = 0x7C00000000000000L;
    private static final long DEC_FLOAT_34_EXPONENT_CONTINUATION_MASK = 288160007407534080L;
    static final long DEC_FLOAT_34_COEFFICIENT_CONTINUATION_MASK = 0x3FFFFFFFFFFFL;
    private static final int[][] tenRadixMagnitude = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};

    public AS400DecFloat(int numDigits) {
        if (numDigits != 16 && numDigits != 34) {
            throw new ExtendedIllegalArgumentException("numDigits (" + String.valueOf(numDigits) + ")", 4);
        }
        this.digits = numDigits;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return this.digits == 16 ? 8 : 16;
    }

    @Override
    public Object getDefaultValue() {
        return BigDecimal.valueOf(0L);
    }

    @Override
    public int getInstanceType() {
        return 13;
    }

    @Override
    public Class getJavaType() {
        return BigDecimal.class;
    }

    public int getNumberOfDigits() {
        return this.digits;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[this.getByteLength()];
        this.toBytes(javaValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        long combination;
        int decDigits;
        int indx;
        long specialCombination = 0L;
        int signalingNaN = -1;
        if (javaValue instanceof String) {
            if (javaValue.equals("NaN")) {
                javaValue = new BigDecimal("1");
                specialCombination = 31L;
                signalingNaN = 0;
            } else if (javaValue.equals("-NaN")) {
                javaValue = new BigDecimal("-1");
                specialCombination = 31L;
                signalingNaN = 0;
            } else if (javaValue.equals("SNaN")) {
                javaValue = new BigDecimal("1");
                specialCombination = 31L;
                signalingNaN = 1;
            } else if (javaValue.equals("-SNaN")) {
                javaValue = new BigDecimal("-1");
                specialCombination = 31L;
                signalingNaN = 1;
            } else if (javaValue.equals("Infinity")) {
                javaValue = new BigDecimal("1");
                specialCombination = 30L;
            } else if (javaValue.equals("-Infinity")) {
                javaValue = new BigDecimal("-1");
                specialCombination = 30L;
            }
        }
        BigDecimal inValue = (BigDecimal)javaValue;
        int sign = inValue.signum();
        long exponent = inValue.scale() * -1;
        String bdUnscaledStr = inValue.abs().unscaledValue().toString();
        if (this.digits == 16) {
            long combination2;
            int bdPrecision = SQLDataFactory.getPrecisionForTruncation(inValue, 16)[0];
            int zeros = 0;
            if (exponent > 368L && bdUnscaledStr.length() < 16) {
                zeros = 16 - bdUnscaledStr.length();
                bdUnscaledStr = bdUnscaledStr + "0000000000000000";
                bdUnscaledStr = bdUnscaledStr.substring(0, 16);
                bdPrecision += zeros;
                exponent -= (long)zeros;
            }
            if (bdUnscaledStr.length() > bdPrecision) {
                exponent = bdUnscaledStr.length() - bdPrecision;
            }
            if (exponent + (long)(bdPrecision - 1) > 384L) {
                throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(exponent + (long)(bdPrecision - 1)) + ")", 4);
            }
            if (exponent + (long)(bdPrecision - 1) < -383L) {
                throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(exponent + (long)(bdPrecision - 1)) + ")", 4);
            }
            int[] coefficientDigits = new int[16];
            int zeroBase = 48;
            for (int indx2 = 0; indx2 < bdPrecision; ++indx2) {
                coefficientDigits[16 - bdPrecision + indx2] = bdUnscaledStr.charAt(indx2) - zeroBase;
            }
            long decFloat16Bits = 0L;
            for (int indx3 = 1; indx3 < 16; indx3 += 3) {
                decFloat16Bits <<= 10;
                int decDigits2 = AS400DecFloat.packDenselyPackedDecimal(coefficientDigits, indx3);
                decFloat16Bits |= (long)decDigits2;
            }
            decFloat16Bits |= ((exponent += 398L) & 0xFFL) << 50;
            if (specialCombination != 0L) {
                combination2 = specialCombination;
            } else if (coefficientDigits[0] >= 8) {
                combination2 = 24L;
                combination2 |= (exponent & 0x300L) >> 7;
                combination2 |= (long)(coefficientDigits[0] & 1);
            } else {
                combination2 = 0L;
                combination2 |= (exponent & 0x300L) >> 5;
                combination2 |= (long)coefficientDigits[0];
            }
            decFloat16Bits |= combination2 << 58;
            if (sign == -1) {
                decFloat16Bits |= Long.MIN_VALUE;
            }
            as400Value[offset] = (byte)(decFloat16Bits >> 56 & 0xFFL);
            as400Value[offset + 1] = (byte)(decFloat16Bits >> 48 & 0xFFL);
            as400Value[offset + 2] = (byte)(decFloat16Bits >> 40 & 0xFFL);
            as400Value[offset + 3] = (byte)(decFloat16Bits >> 32 & 0xFFL);
            as400Value[offset + 4] = (byte)(decFloat16Bits >> 24 & 0xFFL);
            as400Value[offset + 5] = (byte)(decFloat16Bits >> 16 & 0xFFL);
            as400Value[offset + 6] = (byte)(decFloat16Bits >> 8 & 0xFFL);
            as400Value[offset + 7] = (byte)(decFloat16Bits & 0xFFL);
            if (signalingNaN == 0) {
                int n = offset;
                as400Value[n] = (byte)(as400Value[n] & 0xFD);
            } else if (signalingNaN == 1) {
                int n = offset;
                as400Value[n] = (byte)(as400Value[n] | 2);
            }
            return 8;
        }
        int bdPrecision = SQLDataFactory.getPrecisionForTruncation(inValue, 34)[0];
        int zeros = 0;
        if (exponent > 6110L && bdUnscaledStr.length() < 34) {
            zeros = 34 - bdUnscaledStr.length();
            bdUnscaledStr = bdUnscaledStr + "00000000000000000000000000000000";
            bdUnscaledStr = bdUnscaledStr.substring(0, 34);
            bdPrecision += zeros;
            exponent -= (long)zeros;
        }
        if (bdUnscaledStr.length() > bdPrecision) {
            exponent = bdUnscaledStr.length() - bdPrecision;
        }
        if (exponent + (long)(bdPrecision - 1) > 6144L) {
            throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(exponent + (long)(bdPrecision - 1)) + ")", 4);
        }
        if (exponent + (long)(bdPrecision - 1) < -6143L) {
            throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(exponent + (long)(bdPrecision - 1)) + ")", 4);
        }
        int[] coefficientDigits = new int[34];
        int zeroBase = 48;
        for (int indx4 = 0; indx4 < bdPrecision; ++indx4) {
            coefficientDigits[34 - bdPrecision + indx4] = bdUnscaledStr.charAt(indx4) - zeroBase;
        }
        long decFloat34BitsHi = 0L;
        long decFloat34BitsLo = 0L;
        for (indx = 1; indx < 13; indx += 3) {
            decFloat34BitsHi <<= 10;
            decDigits = AS400DecFloat.packDenselyPackedDecimal(coefficientDigits, indx);
            decFloat34BitsHi |= (long)decDigits;
        }
        decDigits = AS400DecFloat.packDenselyPackedDecimal(coefficientDigits, indx);
        decFloat34BitsHi <<= 6;
        decFloat34BitsHi |= (long)((decDigits & 0x3F0) >> 4);
        decFloat34BitsLo |= (long)(decDigits & 0xF);
        indx += 3;
        while (indx < 34) {
            decFloat34BitsLo <<= 10;
            decDigits = AS400DecFloat.packDenselyPackedDecimal(coefficientDigits, indx);
            decFloat34BitsLo |= (long)decDigits;
            indx += 3;
        }
        decFloat34BitsHi |= ((exponent += 6176L) & 0xFFFL) << 46;
        if (specialCombination != 0L) {
            combination = specialCombination;
        } else if (coefficientDigits[0] >= 8) {
            combination = 24L;
            combination |= (exponent & 0x3000L) >> 11;
            combination |= (long)(coefficientDigits[0] & 1);
        } else {
            combination = 0L;
            combination |= (exponent & 0x3000L) >> 9;
            combination |= (long)coefficientDigits[0];
        }
        decFloat34BitsHi |= combination << 58;
        if (sign == -1) {
            decFloat34BitsHi |= Long.MIN_VALUE;
        }
        as400Value[offset] = (byte)(decFloat34BitsHi >> 56 & 0xFFL);
        as400Value[offset + 1] = (byte)(decFloat34BitsHi >> 48 & 0xFFL);
        as400Value[offset + 2] = (byte)(decFloat34BitsHi >> 40 & 0xFFL);
        as400Value[offset + 3] = (byte)(decFloat34BitsHi >> 32 & 0xFFL);
        as400Value[offset + 4] = (byte)(decFloat34BitsHi >> 24 & 0xFFL);
        as400Value[offset + 5] = (byte)(decFloat34BitsHi >> 16 & 0xFFL);
        as400Value[offset + 6] = (byte)(decFloat34BitsHi >> 8 & 0xFFL);
        as400Value[offset + 7] = (byte)(decFloat34BitsHi & 0xFFL);
        as400Value[offset + 8] = (byte)(decFloat34BitsLo >> 56 & 0xFFL);
        as400Value[offset + 9] = (byte)(decFloat34BitsLo >> 48 & 0xFFL);
        as400Value[offset + 10] = (byte)(decFloat34BitsLo >> 40 & 0xFFL);
        as400Value[offset + 11] = (byte)(decFloat34BitsLo >> 32 & 0xFFL);
        as400Value[offset + 12] = (byte)(decFloat34BitsLo >> 24 & 0xFFL);
        as400Value[offset + 13] = (byte)(decFloat34BitsLo >> 16 & 0xFFL);
        as400Value[offset + 14] = (byte)(decFloat34BitsLo >> 8 & 0xFFL);
        as400Value[offset + 15] = (byte)(decFloat34BitsLo & 0xFFL);
        if (signalingNaN == 0) {
            int n = offset;
            as400Value[n] = (byte)(as400Value[n] & 0xFD);
        } else if (signalingNaN == 1) {
            int n = offset;
            as400Value[n] = (byte)(as400Value[n] | 2);
        }
        return 16;
    }

    public byte[] toBytes(double doubleValue) {
        byte[] as400Value = new byte[this.digits == 16 ? 64 : 128];
        this.toBytes(doubleValue, as400Value, 0);
        return as400Value;
    }

    public int toBytes(double doubleValue, byte[] as400Value) {
        return this.toBytes(doubleValue, as400Value, 0);
    }

    public int toBytes(double doubleValue, byte[] as400Value, int offset) {
        BigDecimal bd = new BigDecimal(doubleValue);
        return this.toBytes(bd, as400Value, offset);
    }

    public double toDouble(byte[] as400Value) {
        return this.toDouble(as400Value, 0);
    }

    public double toDouble(byte[] as400Value, int offset) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(offset));
        }
        BigDecimal bd = (BigDecimal)this.toObject(as400Value, offset);
        return bd.doubleValue();
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return this.toObject(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        long coefficientMSD;
        int exponentMSD;
        int sign;
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(offset));
        }
        if (this.digits == 16) {
            long coefficientMSD2;
            int exponentMSD2;
            int sign2;
            long decFloat16Bits = BinaryConverter.byteArrayToLong(as400Value, offset);
            long combination = (decFloat16Bits & 0x7C00000000000000L) >> 58;
            int n = sign2 = (decFloat16Bits & Long.MIN_VALUE) == Long.MIN_VALUE ? -1 : 1;
            if (combination == 31L && sign2 == 1) {
                long nanSignal = (decFloat16Bits & 0x200000000000000L) >> 57;
                if (nanSignal == 1L) {
                    throw new ExtendedIllegalArgumentException("SNaN", 2);
                }
                throw new ExtendedIllegalArgumentException("NaN", 2);
            }
            if (combination == 31L && sign2 == -1) {
                long nanSignal = (decFloat16Bits & 0x200000000000000L) >> 57;
                if (nanSignal == 1L) {
                    throw new ExtendedIllegalArgumentException("-SNaN", 2);
                }
                throw new ExtendedIllegalArgumentException("-NaN", 2);
            }
            if (combination == 30L && sign2 == 1) {
                throw new ExtendedIllegalArgumentException("Infinity", 2);
            }
            if (combination == 30L && sign2 == -1) {
                throw new ExtendedIllegalArgumentException("-Infinity", 2);
            }
            if ((combination & 0x18L) == 24L) {
                exponentMSD2 = (int)((combination & 6L) >> 1);
                coefficientMSD2 = 8L + (combination & 1L);
            } else {
                exponentMSD2 = (int)((combination & 0x18L) >> 3);
                coefficientMSD2 = combination & 7L;
            }
            int exponent = (int)((decFloat16Bits & 0x3FC000000000000L) >> 50);
            exponent |= exponentMSD2 << 8;
            exponent -= 398;
            long coefficientContinuation = decFloat16Bits & 0x3FFFFFFFFFFFFL;
            int coefficientLo = AS400DecFloat.decFloatBitsToDigits((int)(coefficientContinuation & 0x3FFFFFFFL));
            int coefficientHi = AS400DecFloat.decFloatBitsToDigits((int)(coefficientContinuation >> 30 & 0xFFFFFL));
            coefficientHi = (int)((long)coefficientHi + coefficientMSD2 * 1000000L);
            int[] value = AS400DecFloat.computeMagnitude(new int[]{coefficientHi, coefficientLo});
            byte[] magnitude = new byte[]{(byte)(value[0] >>> 24), (byte)(value[0] >>> 16), (byte)(value[0] >>> 8), (byte)value[0], (byte)(value[1] >>> 24), (byte)(value[1] >>> 16), (byte)(value[1] >>> 8), (byte)value[1]};
            BigInteger bigInt = new BigInteger(sign2, magnitude);
            return AS400DecFloat.getNewBigDecimal(bigInt, -exponent);
        }
        long decFloat34BitsHi = BinaryConverter.byteArrayToLong(as400Value, offset);
        long decFloat34BitsLo = BinaryConverter.byteArrayToLong(as400Value, offset + 8);
        long combination = (decFloat34BitsHi & 0x7C00000000000000L) >> 58;
        int n = sign = (decFloat34BitsHi & Long.MIN_VALUE) == Long.MIN_VALUE ? -1 : 1;
        if (combination == 31L && sign == 1) {
            long nanSignal = (decFloat34BitsHi & 0x200000000000000L) >> 57;
            if (nanSignal == 1L) {
                throw new ExtendedIllegalArgumentException("SNaN", 2);
            }
            throw new ExtendedIllegalArgumentException("NaN", 2);
        }
        if (combination == 31L && sign == -1) {
            long nanSignal = (decFloat34BitsHi & 0x200000000000000L) >> 57;
            if (nanSignal == 1L) {
                throw new ExtendedIllegalArgumentException("-SNaN", 2);
            }
            throw new ExtendedIllegalArgumentException("-NaN", 2);
        }
        if (combination == 30L && sign == 1) {
            throw new ExtendedIllegalArgumentException("Infinity", 2);
        }
        if (combination == 30L && sign == -1) {
            throw new ExtendedIllegalArgumentException("-Infinity", 2);
        }
        if ((combination & 0x18L) == 24L) {
            exponentMSD = (int)((combination & 6L) >> 1);
            coefficientMSD = 8L + (combination & 1L);
        } else {
            exponentMSD = (int)((combination & 0x18L) >> 3);
            coefficientMSD = combination & 7L;
        }
        int exponent = (int)((decFloat34BitsHi & 0x3FFC00000000000L) >> 46);
        exponent |= exponentMSD << 12;
        exponent -= 6176;
        int coefficientLo = AS400DecFloat.decFloatBitsToDigits((int)(decFloat34BitsLo & 0x3FFFFFFFL));
        int coefficientMeLo = AS400DecFloat.decFloatBitsToDigits((int)(decFloat34BitsLo >> 30 & 0x3FFFFFFFL));
        int coefficientMeHi = AS400DecFloat.decFloatBitsToDigits((int)((decFloat34BitsHi & 0x3FFFFFFL) << 4 | decFloat34BitsLo >> 60 & 0xFL));
        int coefficientHi = AS400DecFloat.decFloatBitsToDigits((int)(decFloat34BitsHi >> 26 & 0xFFFFFL));
        coefficientHi = (int)((long)coefficientHi + coefficientMSD * 1000000L);
        int[] value = AS400DecFloat.computeMagnitude(new int[]{coefficientHi, coefficientMeHi, coefficientMeLo, coefficientLo});
        byte[] magnitude = new byte[]{(byte)(value[0] >>> 24), (byte)(value[0] >>> 16), (byte)(value[0] >>> 8), (byte)value[0], (byte)(value[1] >>> 24), (byte)(value[1] >>> 16), (byte)(value[1] >>> 8), (byte)value[1], (byte)(value[2] >>> 24), (byte)(value[2] >>> 16), (byte)(value[2] >>> 8), (byte)value[2], (byte)(value[3] >>> 24), (byte)(value[3] >>> 16), (byte)(value[3] >>> 8), (byte)value[3]};
        BigInteger bigInt = new BigInteger(sign, magnitude);
        return AS400DecFloat.getNewBigDecimal(bigInt, -exponent);
    }

    static final String byteToString(int byteVal) {
        int leftDigitValue = byteVal >>> 4 & 0xF;
        int rightDigitValue = byteVal & 0xF;
        char[] digitChars = new char[]{leftDigitValue < 10 ? (char)(48 + leftDigitValue) : (char)(leftDigitValue - 10 + 65), rightDigitValue < 10 ? (char)(48 + rightDigitValue) : (char)(rightDigitValue - 10 + 65)};
        return new String(digitChars);
    }

    private static int packDenselyPackedDecimal(int[] digits, int indx) {
        int result = 0;
        int combination = (digits[indx + 0] & 8) >> 1 | (digits[indx + 1] & 8) >> 2 | (digits[indx + 2] & 8) >> 3;
        switch (combination) {
            case 0: {
                result = digits[indx + 0] << 7 | digits[indx + 1] << 4 | digits[indx + 2];
                break;
            }
            case 1: {
                result = digits[indx + 0] << 7 | digits[indx + 1] << 4 | digits[indx + 2] & 1 | 8;
                break;
            }
            case 2: {
                result = digits[indx + 0] << 7 | (digits[indx + 2] & 6) << 4 | (digits[indx + 1] & 1) << 4 | digits[indx + 2] & 1 | 0xA;
                break;
            }
            case 3: {
                result = digits[indx + 0] << 7 | (digits[indx + 1] & 1) << 4 | digits[indx + 2] & 1 | 0x4E;
                break;
            }
            case 4: {
                result = (digits[indx + 2] & 6) << 7 | (digits[indx + 0] & 1) << 7 | digits[indx + 1] << 4 | digits[indx + 2] & 1 | 0xC;
                break;
            }
            case 5: {
                result = (digits[indx + 1] & 6) << 7 | (digits[indx + 0] & 1) << 7 | (digits[indx + 1] & 1) << 4 | digits[indx + 2] & 1 | 0x2E;
                break;
            }
            case 6: {
                result = (digits[indx + 2] & 6) << 7 | (digits[indx + 0] & 1) << 7 | (digits[indx + 1] & 1) << 4 | digits[indx + 2] & 1 | 0xE;
                break;
            }
            case 7: {
                result = (digits[indx + 0] & 1) << 7 | (digits[indx + 1] & 1) << 4 | digits[indx + 2] & 1 | 0x6E;
            }
        }
        return result;
    }

    private static int unpackDenselyPackedDecimal(int bits) {
        int combination = (bits & 0xE) == 14 ? (bits & 0x60) >> 5 | 4 : ((bits & 8) == 8 ? (~bits & 6) >> 1 : 0);
        int decoded = 0;
        switch (combination) {
            case 0: {
                decoded = (bits & 0x380) << 1 | bits & 0x77;
                break;
            }
            case 1: {
                decoded = (bits & 0x80) << 1 | bits & 0x71 | (bits & 0x300) >> 7 | 0x800;
                break;
            }
            case 2: {
                decoded = (bits & 0x380) << 1 | bits & 0x11 | (bits & 0x60) >> 4 | 0x80;
                break;
            }
            case 3: {
                decoded = (bits & 0x380) << 1 | bits & 0x71 | 8;
                break;
            }
            case 4: {
                decoded = (bits & 0x80) << 1 | bits & 0x11 | (bits & 0x300) >> 7 | 0x880;
                break;
            }
            case 5: {
                decoded = (bits & 0x80) << 1 | bits & 0x11 | (bits & 0x300) >> 3 | 0x808;
                break;
            }
            case 6: {
                decoded = (bits & 0x380) << 1 | bits & 0x11 | 0x88;
                break;
            }
            case 7: {
                decoded = (bits & 0x80) << 1 | bits & 0x11 | 0x888;
            }
        }
        return ((decoded & 0xF00) >> 8) * 100 + ((decoded & 0xF0) >> 4) * 10 + (decoded & 0xF);
    }

    private static final int[] computeMagnitude(int[] input) {
        int length = input.length;
        int[] mag = new int[length];
        mag[length - 1] = input[length - 1];
        for (int i = 0; i < length - 1; ++i) {
            int carry = 0;
            int j = tenRadixMagnitude[i].length - 1;
            int k = length - 1;
            while (j >= 0) {
                long product = ((long)input[length - 2 - i] & 0xFFFFFFFFL) * ((long)tenRadixMagnitude[i][j] & 0xFFFFFFFFL) + ((long)mag[k] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
                carry = (int)(product >>> 32);
                mag[k] = (int)(product & 0xFFFFFFFFL);
                --j;
                --k;
            }
            mag[k] = carry;
        }
        return mag;
    }

    private static final int decFloatBitsToDigits(int bits) {
        int decimal = 0;
        for (int i = 2; i >= 0; --i) {
            decimal *= 1000;
            decimal += AS400DecFloat.unpackDenselyPackedDecimal((int)((long)(bits >> i * 10) & 0x3FFL));
        }
        return decimal;
    }

    private static BigDecimal roundByModePreJDK5(BigInteger intVal, int scale, int mcPrecision, String mcRoundingMode) {
        BigInteger roundingMax = null;
        roundingMax = mcPrecision == 16 ? new BigInteger("10000000000000000") : new BigInteger("10000000000000000000000000000000000");
        BigInteger roundingMin = roundingMax.negate();
        if (roundingMax != null && intVal.compareTo(roundingMax) < 0 && intVal.compareTo(roundingMin) > 0) {
            return AS400DecFloat.getNewBigDecimal(intVal, scale);
        }
        int[] values = SQLDataFactory.getPrecisionForTruncation(AS400DecFloat.getNewBigDecimal(intVal, scale), mcPrecision);
        int precisionNormalized = values[0];
        int droppedZeros = values[1];
        if (droppedZeros != 0) {
            intVal = intVal.divide(new BigInteger("10").pow(droppedZeros));
        }
        int drop = precisionNormalized - mcPrecision;
        BigDecimal rounded = AS400DecFloat.roundOffDigits(intVal, scale, mcRoundingMode, drop);
        if (droppedZeros != 0) {
            rounded = rounded.movePointRight(droppedZeros);
        }
        return rounded;
    }

    private static BigDecimal roundOffDigits(BigInteger intVal, int scale, String mcRoundingMode, int dropCount) {
        BigDecimal divisor = new BigDecimal(new BigInteger("10").pow(dropCount), 0);
        BigDecimal preRoundedBD = AS400DecFloat.getNewBigDecimal(intVal, scale);
        int roundingMode = 0;
        try {
            roundingMode = (Integer)Class.forName("java.math.BigDecimal").getDeclaredField(mcRoundingMode).get(null);
        }
        catch (Exception e) {
            throw new InternalErrorException(6, (Throwable)e);
        }
        BigDecimal rounded = preRoundedBD.divide(divisor, scale, roundingMode);
        BigInteger bigIntPart = rounded.unscaledValue();
        rounded = AS400DecFloat.getNewBigDecimal(bigIntPart, scale - dropCount);
        return rounded;
    }

    private static BigDecimal getNewBigDecimal(BigInteger bigInt, int scale) {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(bigInt, scale);
        }
        catch (NumberFormatException e) {
            if (scale > 0) {
                throw e;
            }
            bigDecimal = new BigDecimal(bigInt);
            bigDecimal = bigDecimal.movePointRight(-scale);
        }
        return bigDecimal;
    }

    public static BigDecimal roundByMode(BigDecimal bd, int precision, String roundingMode) {
        BigDecimal roundedBD = null;
        boolean isGEJVM50 = true;
        try {
            Class<?> cls = Class.forName("java.math.MathContext");
            Constructor<?> ct = cls.getConstructor(Integer.TYPE, Class.forName("java.math.RoundingMode"));
            Object[] arglist = new Object[]{precision, Class.forName("java.math.RoundingMode").getDeclaredField(roundingMode.substring(6)).get(null)};
            Object mathContextRounded = ct.newInstance(arglist);
            Object[] arglist2 = new Object[]{mathContextRounded};
            Class[] c = new Class[]{Class.forName("java.math.MathContext")};
            Method method = BigDecimal.class.getDeclaredMethod("round", c);
            roundedBD = (BigDecimal)method.invoke((Object)bd, arglist2);
        }
        catch (ClassNotFoundException e) {
            isGEJVM50 = false;
        }
        catch (NoSuchMethodException e) {
            isGEJVM50 = false;
        }
        catch (NoSuchFieldException e) {
            isGEJVM50 = false;
        }
        catch (IllegalAccessException e) {
            isGEJVM50 = false;
        }
        catch (InvocationTargetException e) {
            isGEJVM50 = false;
        }
        catch (InstantiationException e) {
            isGEJVM50 = false;
        }
        if (!isGEJVM50) {
            roundedBD = AS400DecFloat.roundByModePreJDK5(bd.unscaledValue(), bd.scale(), precision, roundingMode);
        }
        return roundedBD;
    }
}

