/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLTableCell
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -4848852026390616957L;
    private HTMLTagElement element_;
    private String align_;
    private int colSpan_ = 1;
    private int height_;
    private int rowSpan_ = 1;
    private String vAlign_;
    private int width_;
    private boolean wrap_ = true;
    private String lang_;
    private String dir_;
    private boolean heightPercent_ = false;
    private boolean widthPercent_ = false;
    private boolean useFO_ = false;
    private int borderWidth_ = 1;
    private int cellPadding_ = 1;
    private transient VetoableChangeSupport vetos_;

    public HTMLTableCell() {
    }

    public HTMLTableCell(HTMLTagElement element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.element_ = element;
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public int getColumnSpan() {
        return this.colSpan_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public HTMLTagElement getElement() {
        return this.element_;
    }

    String getEndTag() {
        if (!this.useFO_) {
            return "</td>\n";
        }
        return "</fo:table-cell>\n";
    }

    public int getHeight() {
        return this.height_;
    }

    public String getHorizontalAlignment() {
        return this.align_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public int getRowSpan() {
        return this.rowSpan_;
    }

    String getStartTag() {
        if (!this.useFO_) {
            return "<td";
        }
        return "<fo:table-cell border-style='solid' border-width='" + this.borderWidth_ + "px' padding='" + this.cellPadding_ + "px'";
    }

    String getAttributeTag() {
        StringBuffer tag = new StringBuffer();
        if (this.align_ != null) {
            if (!this.useFO_) {
                tag.append(" align=\"");
                tag.append(this.align_);
                tag.append("\"");
            } else {
                tag.append(" text-align='");
                if (this.align_.equalsIgnoreCase("center")) {
                    tag.append("center");
                } else if (this.align_.equalsIgnoreCase("left")) {
                    tag.append("start");
                } else if (this.align_.equalsIgnoreCase("right")) {
                    tag.append("end");
                }
                tag.append("'");
            }
        }
        if (!this.useFO_) {
            if (this.vAlign_ != null) {
                tag.append(" valign=\"");
                tag.append(this.vAlign_);
                tag.append("\"");
            }
            if (this.rowSpan_ > 1) {
                tag.append(" rowspan=\"");
                tag.append(this.rowSpan_);
                tag.append("\"");
            }
            if (this.colSpan_ > 1) {
                tag.append(" colspan=\"");
                tag.append(this.colSpan_);
                tag.append("\"");
            }
            if (this.height_ > 0) {
                tag.append(" height=\"");
                tag.append(this.height_);
                if (this.heightPercent_) {
                    tag.append("%");
                }
                tag.append("\"");
            }
            if (this.width_ > 0) {
                tag.append(" width=\"");
                tag.append(this.width_);
                if (this.widthPercent_) {
                    tag.append("%");
                }
                tag.append("\"");
            }
            if (!this.wrap_) {
                tag.append(" nowrap=\"nowrap\"");
            }
            tag.append(this.getLanguageAttributeTag());
            tag.append(this.getDirectionAttributeTag());
            tag.append(this.getAttributeString());
        } else {
            if (this.rowSpan_ > 1) {
                tag.append(" number-rows-spanned='");
                tag.append(this.rowSpan_);
                tag.append("'");
            }
            if (this.colSpan_ > 1) {
                tag.append(" number-columns-spanned='");
                tag.append(this.colSpan_);
                tag.append("'");
            }
            if (this.height_ > 0) {
                tag.append(" height='");
                tag.append(this.height_);
                if (this.heightPercent_) {
                    tag.append("%");
                }
                tag.append("'");
            }
            if (this.width_ > 0) {
                tag.append(" width='");
                tag.append(this.width_);
                if (this.widthPercent_) {
                    tag.append("%");
                }
                tag.append("'");
            }
        }
        tag.append(">");
        return tag.toString();
    }

    @Override
    public String getTag() {
        return this.getTag(this.element_);
    }

    @Override
    public String getFOTag() {
        return this.getFOTag(this.element_);
    }

    public String getFOTag(HTMLTagElement element) {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        if (element == null) {
            throw new NullPointerException("element");
        }
        StringBuffer tag = new StringBuffer(this.getStartTag());
        tag.append(this.getAttributeTag());
        tag.append("<fo:block-container");
        tag.append(this.getDirectionAttributeTag());
        tag.append(">\n");
        tag.append(element.getFOTag());
        tag.append("</fo:block-container>\n");
        tag.append(this.getEndTag());
        this.setUseFO(useFO);
        return tag.toString();
    }

    public String getTag(HTMLTagElement element) {
        if (this.useFO_) {
            return this.getFOTag(element);
        }
        if (element == null) {
            throw new NullPointerException("element");
        }
        StringBuffer tag = new StringBuffer(this.getStartTag());
        tag.append(this.getAttributeTag());
        tag.append(element.getTag());
        tag.append(this.getEndTag());
        return tag.toString();
    }

    public String getVerticalAlignment() {
        return this.vAlign_;
    }

    public int getWidth() {
        return this.width_;
    }

    public boolean isHeightInPercent() {
        return this.heightPercent_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public boolean isWidthInPercent() {
        return this.widthPercent_;
    }

    public boolean isWrap() {
        return this.wrap_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setColumnSpan(int span) throws PropertyVetoException {
        if (span <= 0) {
            throw new ExtendedIllegalArgumentException("span", 4);
        }
        int oldSpan = this.colSpan_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("span", (Object)oldSpan, (Object)span);
        }
        this.colSpan_ = span;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("span", (Object)oldSpan, (Object)span);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setElement(String element) throws PropertyVetoException {
        this.setElement(new HTMLText(element));
    }

    public void setElement(HTMLTagElement element) throws PropertyVetoException {
        if (element == null) {
            throw new NullPointerException("element");
        }
        HTMLTagElement old = this.element_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("element", old, element);
        }
        this.element_ = element;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("element", old, element);
        }
    }

    public void setHeight(int height) throws PropertyVetoException {
        if (height <= 0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        int oldHeight = this.height_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("height", (Object)oldHeight, (Object)height);
        }
        this.height_ = height;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", (Object)oldHeight, (Object)height);
        }
    }

    public void setHeight(int height, boolean heightInPercent) throws PropertyVetoException {
        int oldHeight = this.height_;
        this.setHeight(height);
        try {
            this.setHeightInPercent(heightInPercent);
        }
        catch (PropertyVetoException e) {
            this.height_ = oldHeight;
            throw new PropertyVetoException("heightInPercent", e.getPropertyChangeEvent());
        }
    }

    public void setHeightInPercent(boolean heightInPercent) throws PropertyVetoException {
        boolean oldHeight = this.heightPercent_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("heightInPercent", (Object)oldHeight, (Object)heightInPercent);
        }
        this.heightPercent_ = heightInPercent;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("heightInPercent", (Object)oldHeight, (Object)heightInPercent);
        }
    }

    public void setHorizontalAlignment(String alignment) throws PropertyVetoException {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (alignment.equalsIgnoreCase("left") || alignment.equalsIgnoreCase("center") || alignment.equalsIgnoreCase("right")) {
            String old = this.align_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", old, alignment);
            }
            this.align_ = alignment;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", old, alignment);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setRowSpan(int span) throws PropertyVetoException {
        if (span <= 0) {
            throw new ExtendedIllegalArgumentException("span", 4);
        }
        int oldSpan = this.rowSpan_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("span", (Object)oldSpan, (Object)span);
        }
        this.rowSpan_ = span;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("span", (Object)oldSpan, (Object)span);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public void setBorderWidth(int borderWidth) {
        Integer oldWidth = this.borderWidth_;
        Integer newWidth = borderWidth;
        this.borderWidth_ = borderWidth;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("borderWidth", oldWidth, newWidth);
        }
    }

    public void setCellPadding(int cellPadding) {
        Integer oldPadding = this.cellPadding_;
        Integer newPadding = cellPadding;
        this.cellPadding_ = cellPadding;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellPadding", oldPadding, newPadding);
        }
    }

    public void setVerticalAlignment(String alignment) throws PropertyVetoException {
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        if (alignment.equalsIgnoreCase("top") || alignment.equalsIgnoreCase("middle") || alignment.equalsIgnoreCase("bottom") || alignment.equalsIgnoreCase("baseline")) {
            String old = this.vAlign_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", old, alignment);
            }
            this.vAlign_ = alignment;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", old, alignment);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setWidth(int width) throws PropertyVetoException {
        if (width <= 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int oldWidth = this.width_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("width", (Object)oldWidth, (Object)width);
        }
        this.width_ = width;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", (Object)oldWidth, (Object)width);
        }
    }

    public void setWidth(int width, boolean widthInPercent) throws PropertyVetoException {
        int oldWidth = this.width_;
        this.setWidth(width);
        try {
            this.setWidthInPercent(widthInPercent);
        }
        catch (PropertyVetoException e) {
            this.width_ = oldWidth;
            throw new PropertyVetoException("widthInPercent", e.getPropertyChangeEvent());
        }
    }

    public void setWidthInPercent(boolean widthInPercent) throws PropertyVetoException {
        boolean oldWidth = this.widthPercent_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("widthInPercent", (Object)oldWidth, (Object)widthInPercent);
        }
        this.widthPercent_ = widthInPercent;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("widthInPercent", (Object)oldWidth, (Object)widthInPercent);
        }
    }

    public void setWrap(boolean wrap) throws PropertyVetoException {
        boolean oldWrap = this.wrap_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("wrap", (Object)oldWrap, (Object)wrap);
        }
        this.wrap_ = wrap;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("wrap", (Object)oldWrap, (Object)wrap);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

