/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.binder;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.observation.MetricConfig;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.Args;

public final class ConnPoolMetersAsync
implements MeterBinder {
    private final ConnPoolControl<?> pool;
    private final MetricConfig mc;

    private ConnPoolMetersAsync(ConnPoolControl<?> pool, MetricConfig mc) {
        this.pool = pool;
        this.mc = mc;
    }

    public void bindTo(MeterRegistry registry) {
        Args.notNull((Object)registry, (String)"registry");
        Gauge.builder((String)(this.mc.prefix + ".pool.leased"), this.pool, p -> p.getTotalStats().getLeased()).tags(this.mc.commonTags).register(registry);
        Gauge.builder((String)(this.mc.prefix + ".pool.available"), this.pool, p -> p.getTotalStats().getAvailable()).tags(this.mc.commonTags).register(registry);
        Gauge.builder((String)(this.mc.prefix + ".pool.pending"), this.pool, p -> p.getTotalStats().getPending()).tags(this.mc.commonTags).register(registry);
    }

    public static void bindTo(HttpAsyncClientBuilder builder, MeterRegistry registry, MetricConfig mc) {
        Args.notNull((Object)builder, (String)"builder");
        Args.notNull((Object)registry, (String)"registry");
        Args.notNull((Object)mc, (String)"metricConfig");
        AsyncClientConnectionManager cm = builder.getConnManager();
        if (cm instanceof ConnPoolControl) {
            new ConnPoolMetersAsync((ConnPoolControl)cm, mc).bindTo(registry);
        }
    }

    public static void bindTo(HttpAsyncClientBuilder builder, MeterRegistry registry) {
        ConnPoolMetersAsync.bindTo(builder, registry, MetricConfig.DEFAULT);
    }

    private ConnPoolMetersAsync() {
        this.pool = null;
        this.mc = null;
    }
}

