/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.compress;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.zip.GZIPInputStream;
import org.apache.hc.client5.http.entity.DeflateCompressingEntity;
import org.apache.hc.client5.http.entity.DeflateInputStream;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.entity.compress.BrotliCodecFactory;
import org.apache.hc.client5.http.entity.compress.CommonsCompressCodecFactory;
import org.apache.hc.client5.http.entity.compress.CommonsCompressRuntime;
import org.apache.hc.client5.http.entity.compress.CompressingEntity;
import org.apache.hc.client5.http.entity.compress.ContentCoding;
import org.apache.hc.client5.http.entity.compress.DecompressingEntity;
import org.apache.hc.client5.http.impl.Brotli4jRuntime;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.io.IOFunction;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
public final class ContentCodecRegistry {
    private static final Map<ContentCoding, Codec> REGISTRY = ContentCodecRegistry.build();

    private static Map<ContentCoding, Codec> build() {
        EnumMap<ContentCoding, Codec> m = new EnumMap<ContentCoding, Codec>(ContentCoding.class);
        m.put(ContentCoding.GZIP, new Codec(GzipCompressingEntity::new, ent -> new DecompressingEntity((HttpEntity)ent, (IOFunction<InputStream, InputStream>)((IOFunction)GZIPInputStream::new))));
        m.put(ContentCoding.DEFLATE, new Codec(DeflateCompressingEntity::new, ent -> new DecompressingEntity((HttpEntity)ent, (IOFunction<InputStream, InputStream>)((IOFunction)DeflateInputStream::new))));
        if (CommonsCompressRuntime.available()) {
            for (ContentCoding c : Arrays.asList(ContentCoding.BROTLI, ContentCoding.ZSTD, ContentCoding.XZ, ContentCoding.LZMA, ContentCoding.LZ4_FRAMED, ContentCoding.LZ4_BLOCK, ContentCoding.BZIP2, ContentCoding.PACK200, ContentCoding.DEFLATE64)) {
                if (!CommonsCompressCodecFactory.runtimeAvailable(c)) continue;
                m.put(c, new Codec(e -> new CompressingEntity((HttpEntity)e, c.token(), CommonsCompressCodecFactory.encoder(c.token())), ent -> new DecompressingEntity((HttpEntity)ent, CommonsCompressCodecFactory.decoder(c.token()))));
            }
        }
        if (Brotli4jRuntime.available()) {
            m.put(ContentCoding.BROTLI, Codec.decodeOnly(ent -> new DecompressingEntity((HttpEntity)ent, BrotliCodecFactory.decoder())));
        }
        return Collections.unmodifiableMap(m);
    }

    public static HttpEntity wrap(ContentCoding c, HttpEntity src) {
        Codec k = REGISTRY.get((Object)c);
        return k != null && k.encoder != null ? (HttpEntity)k.encoder.apply(src) : null;
    }

    public static HttpEntity unwrap(ContentCoding c, HttpEntity src) {
        Codec k = REGISTRY.get((Object)c);
        return k != null && k.decoder != null ? (HttpEntity)k.decoder.apply(src) : null;
    }

    public static UnaryOperator<HttpEntity> decoder(ContentCoding coding) {
        Codec c = REGISTRY.get((Object)coding);
        return c != null ? c.decoder : null;
    }

    public static UnaryOperator<HttpEntity> encoder(ContentCoding coding) {
        Codec c = REGISTRY.get((Object)coding);
        return c != null ? c.encoder : null;
    }

    private ContentCodecRegistry() {
    }

    static final class Codec {
        final UnaryOperator<HttpEntity> encoder;
        final UnaryOperator<HttpEntity> decoder;

        Codec(UnaryOperator<HttpEntity> enc, UnaryOperator<HttpEntity> dec) {
            this.encoder = enc;
            this.decoder = dec;
        }

        static Codec encodeOnly(UnaryOperator<HttpEntity> e) {
            return new Codec(e, null);
        }

        static Codec decodeOnly(UnaryOperator<HttpEntity> d) {
            return new Codec(null, d);
        }
    }
}

