/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicHeaderIterator {
    TestBasicHeaderIterator() {
    }

    @Test
    void testAllSame() {
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)"value0"), new BasicHeader("nAme", (Object)"value1, value1.1"), new BasicHeader("naMe", (Object)"value2=whatever"), new BasicHeader("namE", (Object)"value3;tag=nil")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[0], hit.next(), (String)"0");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[1], hit.next(), (String)"1");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[2], hit.next(), (String)"2");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[3], hit.next(), (String)"3");
        Assertions.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "name");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[0], hit.next(), (String)"0");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[1], hit.next(), (String)"1");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[2], hit.next(), (String)"2");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[3], hit.next(), (String)"3");
        Assertions.assertFalse((boolean)hit.hasNext());
    }

    @Test
    void testFirstLastOneNone() {
        Header[] headers = new Header[]{new BasicHeader("match", (Object)"value0"), new BasicHeader("mismatch", (Object)"value1, value1.1"), new BasicHeader("single", (Object)"value2=whatever"), new BasicHeader("match", (Object)"value3;tag=nil")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[0], hit.next(), (String)"0");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[1], hit.next(), (String)"1");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[2], hit.next(), (String)"2");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[3], hit.next(), (String)"3");
        Assertions.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "match");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[0], hit.next());
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[3], hit.next());
        Assertions.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "single");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[2], hit.next());
        Assertions.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "way-off");
        Assertions.assertFalse((boolean)hit.hasNext());
    }

    @Test
    void testInterspersed() {
        Header[] headers = new Header[]{new BasicHeader("yellow", (Object)"00"), new BasicHeader("maroon", (Object)"01"), new BasicHeader("orange", (Object)"02"), new BasicHeader("orange", (Object)"03"), new BasicHeader("orange", (Object)"04"), new BasicHeader("yellow", (Object)"05"), new BasicHeader("maroon", (Object)"06"), new BasicHeader("maroon", (Object)"07"), new BasicHeader("maroon", (Object)"08"), new BasicHeader("yellow", (Object)"09"), new BasicHeader("maroon", (Object)"0a"), new BasicHeader("yellow", (Object)"0b"), new BasicHeader("orange", (Object)"0c"), new BasicHeader("yellow", (Object)"0d"), new BasicHeader("orange", (Object)"0e")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[0], hit.next(), (String)"0");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[1], hit.next(), (String)"1");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[2], hit.next(), (String)"2");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[3], hit.next(), (String)"3");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[4], hit.next(), (String)"4");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[5], hit.next(), (String)"5");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[6], hit.next(), (String)"6");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[7], hit.next(), (String)"7");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[8], hit.next(), (String)"8");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[9], hit.next(), (String)"9");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[10], hit.next(), (String)"a");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[11], hit.next(), (String)"b");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[12], hit.next(), (String)"c");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[13], hit.next(), (String)"d");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[14], hit.next(), (String)"e");
        Assertions.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "Yellow");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[0], hit.next());
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[5], hit.next(), (String)"5");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[9], hit.next(), (String)"9");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[11], hit.next(), (String)"b");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[13], hit.next(), (String)"d");
        Assertions.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "marOOn");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[1], hit.next(), (String)"1");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[6], hit.next(), (String)"6");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[7], hit.next(), (String)"7");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[8], hit.next(), (String)"8");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[10], hit.next(), (String)"a");
        Assertions.assertFalse((boolean)hit.hasNext());
        hit = new BasicHeaderIterator(headers, "OranGe");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[2], hit.next());
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[3], hit.next());
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[4], hit.next(), (String)"4");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[12], hit.next(), (String)"b");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[14], hit.next(), (String)"e");
        Assertions.assertFalse((boolean)hit.hasNext());
    }

    @Test
    void testInvalid() {
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHeaderIterator(null, "whatever"));
        BasicHeaderIterator hit = new BasicHeaderIterator(new Header[0], "whatever");
        Assertions.assertFalse((boolean)hit.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> TestBasicHeaderIterator.lambda$testInvalid$1((Iterator)hit));
    }

    @Test
    void testRemaining() {
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)"value0"), new BasicHeader("nAme", (Object)"value1, value1.1"), new BasicHeader("naMe", (Object)"value2=whatever"), new BasicHeader("namE", (Object)"value3;tag=nil")};
        BasicHeaderIterator hit = new BasicHeaderIterator(headers, null);
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[0], hit.next(), (String)"0");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[1], hit.next(), (String)"1");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[2], hit.next(), (String)"2");
        Assertions.assertTrue((boolean)hit.hasNext());
        Assertions.assertEquals((Object)headers[3], hit.next(), (String)"3");
        Assertions.assertFalse((boolean)hit.hasNext());
        BasicHeaderIterator hit2 = new BasicHeaderIterator(headers, null);
        Assertions.assertTrue((boolean)hit2.hasNext());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> TestBasicHeaderIterator.lambda$testRemaining$2((Iterator)hit2));
    }

    private static /* synthetic */ void lambda$testRemaining$2(Iterator hit2) throws Throwable {
        hit2.remove();
    }

    private static /* synthetic */ void lambda$testInvalid$1(Iterator hit) throws Throwable {
        Header cfr_ignored_0 = (Header)hit.next();
    }
}

