/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel.agg;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public abstract class IgniteReduceAggregateBase
extends SingleRel
implements TraitsAwareIgniteRel {
    protected final ImmutableBitSet groupSet;
    protected final List<ImmutableBitSet> groupSets;
    protected final List<AggregateCall> aggCalls;

    protected IgniteReduceAggregateBase(RelOptCluster cluster, RelTraitSet traits, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls, RelDataType rowType) {
        super(cluster, traits, input);
        assert (rowType != null);
        this.groupSet = groupSet;
        if (groupSets == null) {
            groupSets = ImmutableList.of((Object)groupSet);
        }
        this.groupSets = groupSets;
        this.aggCalls = aggCalls;
        this.rowType = rowType;
    }

    protected IgniteReduceAggregateBase(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), input.getInput(), input.getBitSet("group"), input.getBitSetList("groups"), input.getAggregateCalls("aggs"), input.getRowType("rowType"));
    }

    protected RelDataType deriveRowType() {
        throw new UnsupportedOperationException();
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw).itemIf("rowType", (Object)this.rowType, pw.getDetailLevel() == SqlExplainLevel.ALL_ATTRIBUTES).item("group", (Object)this.groupSet).itemIf("groups", this.groupSets, Aggregate.Group.induce((ImmutableBitSet)this.groupSet, this.groupSets) != Aggregate.Group.SIMPLE).itemIf("aggs", this.aggCalls, pw.nest());
        if (!pw.nest()) {
            for (Ord ord : Ord.zip(this.aggCalls)) {
                pw.item((String)Util.first((Object)((AggregateCall)ord.e).name, (Object)("agg#" + ord.i)), ord.e);
            }
        }
        return pw;
    }

    public ImmutableBitSet getGroupSet() {
        return this.groupSet;
    }

    public List<ImmutableBitSet> getGroupSets() {
        return this.groupSets;
    }

    public List<AggregateCall> getAggregateCalls() {
        return this.aggCalls;
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        if (TraitUtils.distribution(nodeTraits) == IgniteDistributions.single()) {
            return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)IgniteDistributions.single())));
        }
        return null;
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)RewindabilityTrait.ONE_WAY), (Object)ImmutableList.of((Object)inputTraits.get(0))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), (Object)ImmutableList.of((Object)in.replace((RelTrait)IgniteDistributions.single()))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.correlation(inTraits.get(0))), inTraits));
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getRowCount(this.getInput());
    }
}

