/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql.kill;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlKill;

public class IgniteSqlKillQuery
extends IgniteSqlKill {
    private static final SqlOperator SYNC_OPERATOR = new SqlSpecialOperator("KILL QUERY", SqlKind.OTHER_DDL);
    private static final SqlOperator ASYNC_OPERATOR = new SqlSpecialOperator("KILL QUERY ASYNC", SqlKind.OTHER_DDL);
    private final SqlCharStringLiteral globalQueryId;
    private final UUID nodeId;
    private final long queryId;
    private final boolean isAsync;

    public IgniteSqlKillQuery(SqlParserPos pos, SqlCharStringLiteral globalQueryId, UUID nodeId, long queryId, boolean isAsync) {
        super(isAsync ? ASYNC_OPERATOR : SYNC_OPERATOR, pos);
        this.globalQueryId = globalQueryId;
        this.nodeId = nodeId;
        this.queryId = queryId;
        this.isAsync = isAsync;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.globalQueryId);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        this.globalQueryId.unparse(writer, 0, 0);
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public long queryId() {
        return this.queryId;
    }

    public boolean isAsync() {
        return this.isAsync;
    }
}

