/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.jdbc.CacheAbstractJdbcStore;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class CacheStoreConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean jdbcStore;
    private String store;
    private String storeFactory;
    private boolean readThrough;
    private boolean writeThrough;
    private boolean writeBehindEnabled;
    private int batchSz;
    private long flushFreq;
    private int flushSz;
    private int flushThreadCnt;
    private boolean storeKeepBinary;
    private boolean writeBehindCoalescing;

    public CacheStoreConfiguration() {
    }

    public CacheStoreConfiguration(IgniteEx ignite, CacheConfiguration ccfg) {
        IgniteCacheProxy c = ignite.context().cache().jcache(ccfg.getName());
        CacheStore<?, ?> cstore = c != null && c.context().started() ? c.context().store().configuredStore() : null;
        this.jdbcStore = cstore instanceof CacheAbstractJdbcStore;
        this.store = VisorTaskUtils.compactClass(cstore);
        this.storeFactory = VisorTaskUtils.compactClass(ccfg.getCacheStoreFactory());
        this.readThrough = ccfg.isReadThrough();
        this.writeThrough = ccfg.isWriteThrough();
        this.writeBehindEnabled = ccfg.isWriteBehindEnabled();
        this.batchSz = ccfg.getWriteBehindBatchSize();
        this.flushFreq = ccfg.getWriteBehindFlushFrequency();
        this.flushSz = ccfg.getWriteBehindFlushSize();
        this.flushThreadCnt = ccfg.getWriteBehindFlushThreadCount();
        this.storeKeepBinary = ccfg.isStoreKeepBinary();
        this.writeBehindCoalescing = ccfg.getWriteBehindCoalescing();
    }

    public boolean isEnabled() {
        return this.store != null;
    }

    public boolean isJdbcStore() {
        return this.jdbcStore;
    }

    @Nullable
    public String getStore() {
        return this.store;
    }

    public String getStoreFactory() {
        return this.storeFactory;
    }

    public boolean isReadThrough() {
        return this.readThrough;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public boolean isWriteBehindEnabled() {
        return this.writeBehindEnabled;
    }

    public int getBatchSize() {
        return this.batchSz;
    }

    public long getFlushFrequency() {
        return this.flushFreq;
    }

    public int getFlushSize() {
        return this.flushSz;
    }

    public int getFlushThreadCount() {
        return this.flushThreadCnt;
    }

    public boolean isStoreKeepBinary() {
        return this.storeKeepBinary;
    }

    public boolean getWriteBehindCoalescing() {
        return this.writeBehindCoalescing;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.jdbcStore);
        U.writeString(out, this.store);
        U.writeString(out, this.storeFactory);
        out.writeBoolean(this.readThrough);
        out.writeBoolean(this.writeThrough);
        out.writeBoolean(this.writeBehindEnabled);
        out.writeInt(this.batchSz);
        out.writeLong(this.flushFreq);
        out.writeInt(this.flushSz);
        out.writeInt(this.flushThreadCnt);
        out.writeBoolean(this.storeKeepBinary);
        out.writeBoolean(this.writeBehindCoalescing);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.jdbcStore = in.readBoolean();
        this.store = U.readString(in);
        this.storeFactory = U.readString(in);
        this.readThrough = in.readBoolean();
        this.writeThrough = in.readBoolean();
        this.writeBehindEnabled = in.readBoolean();
        this.batchSz = in.readInt();
        this.flushFreq = in.readLong();
        this.flushSz = in.readInt();
        this.flushThreadCnt = in.readInt();
        this.storeKeepBinary = in.readBoolean();
        this.writeBehindCoalescing = in.readBoolean();
    }

    public String toString() {
        return S.toString(CacheStoreConfiguration.class, this);
    }
}

