/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.ConcurrentStripedPool;
import org.apache.ignite.internal.processors.query.h2.H2Connection;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2DefaultTableEngine;
import org.apache.ignite.internal.processors.query.h2.opt.H2PlainRowFactory;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.Driver;
import org.h2.api.JavaObjectSerializer;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.jdbc.JdbcConnection;
import org.h2.store.DataHandler;

public class ConnectionManager {
    private static final String DEFAULT_DB_OPTIONS = ";LOCK_MODE=3;MULTI_THREADED=1;DB_CLOSE_ON_EXIT=FALSE;DEFAULT_LOCK_TIMEOUT=10000;FUNCTIONS_IN_SCHEMA=true;OPTIMIZE_REUSE_RESULTS=0;QUERY_CACHE_SIZE=0;MAX_OPERATION_MEMORY=0;BATCH_JOINS=1;ROW_FACTORY=\"" + H2PlainRowFactory.class.getName() + "\";DEFAULT_TABLE_ENGINE=" + GridH2DefaultTableEngine.class.getName();
    private static final int DFLT_CONNECTION_POOL_SIZE = 32;
    private static final H2Utils.Setter<Database, JavaObjectSerializer> DB_JOBJ_SERIALIZER = H2Utils.setter(Database.class, "javaObjectSerializer");
    private final Long stmtCleanupPeriod = Long.getLong("IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD", 10000L);
    private final Long stmtTimeout = Long.getLong("IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT", 600000L) * 1000000L;
    private final String dbUrl;
    private final GridTimeoutProcessor.CancelableTask stmtCleanupTask;
    private final IgniteLogger log;
    private final Set<H2Connection> usedConns = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentStripedPool<H2Connection> connPool;
    private final Connection sysConn;
    private final DataHandler dataNhd;
    private final GridBusyLock busyLock = new GridBusyLock();

    public ConnectionManager(GridKernalContext ctx) {
        this.connPool = new ConcurrentStripedPool(ctx.config().getQueryThreadPoolSize(), 32);
        this.dbUrl = "jdbc:h2:mem:" + ctx.localNodeId() + DEFAULT_DB_OPTIONS;
        this.log = ctx.log(ConnectionManager.class);
        Driver.load();
        try {
            this.sysConn = DriverManager.getConnection(this.dbUrl);
            this.sysConn.setSchema("INFORMATION_SCHEMA");
            this.dataNhd = this.sysConn.unwrap(JdbcConnection.class).getSession().getDataHandler();
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Failed to initialize DB connection: " + this.dbUrl, (Throwable)e);
        }
        this.stmtCleanupTask = ctx.timeout().schedule(this::cleanupStatements, this.stmtCleanupPeriod.longValue(), this.stmtCleanupPeriod.longValue());
    }

    public void executeStatement(String schema, String sql) throws IgniteCheckedException {
        try (H2PooledConnection conn = this.connection(schema);){
            Connection c = conn.connection();
            try (Statement stmt = c.createStatement();){
                stmt.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to execute statement: " + sql, (Throwable)e);
        }
    }

    public void executeSystemStatement(String sql) throws IgniteCheckedException {
        Statement stmt = null;
        try {
            stmt = this.sysConn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            U.close((AutoCloseable)this.sysConn, (IgniteLogger)this.log);
            throw new IgniteCheckedException("Failed to execute system statement: " + sql, (Throwable)e);
        }
        finally {
            U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
        }
    }

    public void onCacheDestroyed() {
        this.connPool.forEach(H2Connection::clearStatementCache);
    }

    private void closeConnections() {
        this.busyLock.block();
        this.connPool.forEach(c -> U.close((AutoCloseable)c.connection(), (IgniteLogger)this.log));
        this.connPool.clear();
        this.usedConns.forEach(c -> U.close((AutoCloseable)c.connection(), (IgniteLogger)this.log));
        this.usedConns.clear();
    }

    public void onKernalStop() {
        this.closeConnections();
    }

    public void stop() {
        if (this.stmtCleanupTask != null) {
            this.stmtCleanupTask.close();
        }
        this.closeConnections();
        try (Statement s = this.sysConn.createStatement();){
            s.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to shutdown database.", (Throwable)e);
        }
        U.close((AutoCloseable)this.sysConn, (IgniteLogger)this.log);
    }

    private void cleanupStatements() {
        this.connPool.forEach(c -> {
            if (c.statementCache().inactiveFor(this.stmtTimeout)) {
                c.clearStatementCache();
            }
        });
    }

    public H2PooledConnection connection(String schema) {
        H2PooledConnection conn = this.connection();
        try {
            conn.schema(schema);
            return conn;
        }
        catch (IgniteSQLException e) {
            U.closeQuiet((AutoCloseable)conn);
            throw e;
        }
    }

    void poolSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid connection pool size: " + size);
        }
        this.connPool.resize(size);
    }

    public H2PooledConnection connection() {
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to initialize DB connection (grid is stopping)");
        }
        try {
            H2Connection conn = this.connPool.borrow();
            if (conn == null) {
                conn = this.newConnection();
            }
            H2PooledConnection connWrp = new H2PooledConnection(conn, this);
            this.usedConns.add(conn);
            assert (!conn.connection().isClosed()) : "Connection is closed [conn=" + conn + "]";
            H2PooledConnection h2PooledConnection = connWrp;
            return h2PooledConnection;
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Failed to initialize DB connection: " + this.dbUrl, (Throwable)e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private H2Connection newConnection() {
        try {
            return new H2Connection(DriverManager.getConnection(this.dbUrl), this.log);
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Failed to initialize DB connection: " + this.dbUrl, (Throwable)e);
        }
    }

    void recycle(H2Connection conn) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            boolean rmv = this.usedConns.remove(conn);
            assert (rmv) : "Connection isn't tracked [conn=" + conn + "]";
            if (!this.connPool.recycle(conn)) {
                conn.close();
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public DataHandler dataHandler() {
        return this.dataNhd;
    }

    void setH2Serializer(JavaObjectSerializer serializer) {
        if (this.dataNhd != null && this.dataNhd instanceof Database) {
            DB_JOBJ_SERIALIZER.set((Database)this.dataNhd, serializer);
        }
    }

    private static void forbidH2DbSettings(String ... settings) {
        try {
            Field knownSettingsField = ConnectionInfo.class.getDeclaredField("KNOWN_SETTINGS");
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(knownSettingsField, knownSettingsField.getModifiers() & 0xFFFFFFEF);
            knownSettingsField.setAccessible(true);
            HashSet knownSettings = (HashSet)knownSettingsField.get(null);
            for (String s : settings) {
                knownSettings.remove(s);
            }
            modifiers.setInt(knownSettingsField, knownSettingsField.getModifiers() & 0x10);
            modifiers.setAccessible(false);
            knownSettingsField.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        System.setProperty("h2.objectCache", "false");
        System.setProperty("h2.serializeJavaObject", "false");
        System.setProperty("h2.objectCacheMaxPerElementSize", "0");
        System.setProperty("h2.optimizeTwoEquals", "false");
        System.setProperty("h2.dropRestrict", "false");
        ConnectionManager.forbidH2DbSettings("INIT");
    }
}

