/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjects;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.row.InternalTuple;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.util.IgniteNameUtils;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRowTupleAdapter
implements Tuple,
SchemaAware {
    protected transient Row row;

    public AbstractRowTupleAdapter(@NotNull Row row) {
        this.row = row;
    }

    public SchemaDescriptor schema() {
        return this.row.schema();
    }

    public int columnCount() {
        return this.row.hasValue() ? this.row.schema().length() : this.row.schema().keyColumns().length();
    }

    public String columnName(int columnIndex) {
        return this.rowColumnByIndex(columnIndex).name();
    }

    public int columnIndex(@NotNull String columnName) {
        Objects.requireNonNull(columnName);
        Column col = this.row.schema().column(IgniteNameUtils.parseSimpleName((String)columnName));
        return col == null ? -1 : col.schemaIndex();
    }

    public <T> T valueOrDefault(@NotNull String columnName, T defaultValue) {
        Objects.requireNonNull(columnName);
        Column col = this.row.schema().column(IgniteNameUtils.parseSimpleName((String)columnName));
        return (T)(col == null ? defaultValue : col.type().spec().objectValue((InternalTuple)this.row, col.schemaIndex()));
    }

    public <T> T value(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return (T)col.type().spec().objectValue((InternalTuple)this.row, col.schemaIndex());
    }

    public <T> T value(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return (T)col.type().spec().objectValue((InternalTuple)this.row, col.schemaIndex());
    }

    public BinaryObject binaryObjectValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return BinaryObjects.wrap(this.row.bytesValue(col.schemaIndex()));
    }

    public BinaryObject binaryObjectValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return BinaryObjects.wrap(this.row.bytesValue(col.schemaIndex()));
    }

    public byte byteValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.byteValue(col.schemaIndex());
    }

    public byte byteValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.byteValue(col.schemaIndex());
    }

    public short shortValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.shortValue(col.schemaIndex());
    }

    public short shortValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.shortValue(col.schemaIndex());
    }

    public int intValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.intValue(col.schemaIndex());
    }

    public int intValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.intValue(col.schemaIndex());
    }

    public long longValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.longValue(col.schemaIndex());
    }

    public long longValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.longValue(col.schemaIndex());
    }

    public float floatValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.floatValue(col.schemaIndex());
    }

    public float floatValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.floatValue(col.schemaIndex());
    }

    public double doubleValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.doubleValue(col.schemaIndex());
    }

    public double doubleValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.doubleValue(col.schemaIndex());
    }

    public String stringValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.stringValue(col.schemaIndex());
    }

    public String stringValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.stringValue(col.schemaIndex());
    }

    public UUID uuidValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.uuidValue(col.schemaIndex());
    }

    public UUID uuidValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.uuidValue(col.schemaIndex());
    }

    public BitSet bitmaskValue(@NotNull String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.bitmaskValue(col.schemaIndex());
    }

    public BitSet bitmaskValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.bitmaskValue(col.schemaIndex());
    }

    public LocalDate dateValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.dateValue(col.schemaIndex());
    }

    public LocalDate dateValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.dateValue(col.schemaIndex());
    }

    public LocalTime timeValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.timeValue(col.schemaIndex());
    }

    public LocalTime timeValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.timeValue(col.schemaIndex());
    }

    public LocalDateTime datetimeValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.dateTimeValue(col.schemaIndex());
    }

    public LocalDateTime datetimeValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.dateTimeValue(col.schemaIndex());
    }

    public Instant timestampValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.timestampValue(col.schemaIndex());
    }

    public Instant timestampValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.timestampValue(col.schemaIndex());
    }

    @NotNull
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int cur;

            @Override
            public boolean hasNext() {
                return this.cur < AbstractRowTupleAdapter.this.row.schema().length();
            }

            @Override
            public Object next() {
                return this.hasNext() ? AbstractRowTupleAdapter.this.value(this.cur++) : null;
            }
        };
    }

    public int hashCode() {
        return Tuple.hashCode((Tuple)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tuple) {
            return Tuple.equals((Tuple)this, (Tuple)((Tuple)obj));
        }
        return false;
    }

    protected Column rowColumnByName(@NotNull String columnName) {
        Objects.requireNonNull(columnName);
        Column col = this.row.schema().column(IgniteNameUtils.parseSimpleName((String)columnName));
        if (col == null) {
            throw new IllegalArgumentException("Invalid column name: columnName=" + columnName);
        }
        return col;
    }

    protected Column rowColumnByIndex(int columnIndex) {
        Objects.checkIndex(columnIndex, this.row.schema().length());
        return this.row.schema().column(columnIndex);
    }
}

