/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.flow.builder;

import java.io.PrintWriter;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.DecoratorRegistry;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.exception.handler.DefaultExceptionHandlers;
import org.apache.ignite.internal.cli.core.flow.Flow;
import org.apache.ignite.internal.cli.core.flow.FlowInterruptException;
import org.apache.ignite.internal.cli.core.flow.Flowable;
import org.apache.ignite.internal.cli.core.flow.builder.FlowBuilder;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAnswer;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAskerFactory;
import org.apache.ignite.internal.cli.core.repl.context.CommandLineContextProvider;
import org.apache.ignite.internal.cli.decorators.DefaultDecoratorRegistry;
import org.apache.ignite.internal.cli.logger.CliLoggers;

public class FlowBuilderImpl<I, O>
implements FlowBuilder<I, O> {
    private final Flow<I, O> flow;
    private final ExceptionHandlers exceptionHandlers;
    private final DecoratorRegistry decoratorRegistry;
    private boolean verbose;

    FlowBuilderImpl(Flow<I, O> flow) {
        this(flow, new DefaultExceptionHandlers(), new DefaultDecoratorRegistry(), false);
    }

    private FlowBuilderImpl(Flow<I, O> flow, ExceptionHandlers exceptionHandlers, DecoratorRegistry decoratorRegistry, boolean verbose) {
        this.flow = flow;
        this.exceptionHandlers = exceptionHandlers;
        this.decoratorRegistry = decoratorRegistry;
        this.verbose = verbose;
    }

    @Override
    public <OT> FlowBuilder<I, OT> then(Flow<O, OT> flow) {
        return new FlowBuilderImpl<I, OT>(this.flow.composite(flow), this.exceptionHandlers, this.decoratorRegistry, this.verbose);
    }

    @Override
    public <OT> FlowBuilder<I, OT> flatMap(Function<O, FlowBuilder<O, OT>> mapper) {
        return this.then(it -> ((FlowBuilder)mapper.apply(it.value())).build().start(it));
    }

    @Override
    public <OT> FlowBuilder<I, O> ifThen(Predicate<O> tester, Flow<O, OT> flow) {
        return this.then(input -> {
            if (tester.test(input.value())) {
                flow.start(input);
            }
            return input;
        });
    }

    @Override
    public <QT> FlowBuilder<I, QT> question(String questionText, List<QuestionAnswer<O, QT>> questionAnswers) {
        return this.then(input -> Flowable.success(QuestionAskerFactory.newQuestionAsker().askQuestion(questionText, input.value(), questionAnswers)));
    }

    @Override
    public <QT> FlowBuilder<I, QT> question(Function<O, String> questionText, List<QuestionAnswer<O, QT>> answers) {
        return this.then(input -> Flowable.success(QuestionAskerFactory.newQuestionAsker().askQuestion((String)questionText.apply(input.value()), input.value(), answers)));
    }

    @Override
    public FlowBuilder<I, O> exceptionHandler(ExceptionHandler<?> exceptionHandler) {
        this.exceptionHandlers.addExceptionHandler(exceptionHandler);
        return this;
    }

    @Override
    public FlowBuilder<I, O> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public FlowBuilder<I, O> print(Decorator<O, TerminalOutput> decorator) {
        return this.then(input -> this.printResult(input, type -> decorator));
    }

    @Override
    public FlowBuilder<I, O> print() {
        return this.then(input -> this.printResult(input, this.decoratorRegistry::getDecorator));
    }

    @Override
    public Flow<I, O> build() {
        return this::run;
    }

    @Override
    public void start() {
        try {
            this.run(Flowable.empty());
        }
        catch (FlowInterruptException flowInterruptException) {
            // empty catch block
        }
    }

    private Flowable<O> run(Flowable<I> input) {
        try {
            if (this.verbose) {
                CliLoggers.startOutputRedirect(CommandLineContextProvider.getContext().err());
            }
            Flowable<O> flowable = this.flow.start(input);
            return flowable;
        }
        finally {
            if (this.verbose) {
                CliLoggers.stopOutputRedirect();
            }
        }
    }

    private Flowable<O> printResult(Flowable<O> input, Function<Class<O>, Decorator<O, TerminalOutput>> decoratorProvider) {
        if (input.hasResult()) {
            CommandLineContextProvider.print(() -> {
                String out = ((Decorator)decoratorProvider.apply(input.type())).decorate(input.value()).toTerminalString();
                PrintWriter output = CommandLineContextProvider.getContext().out();
                output.println(out);
            });
        } else if (input.hasError()) {
            PrintWriter errOutput = CommandLineContextProvider.getContext().err();
            this.exceptionHandlers.handleException(ExceptionWriter.fromPrintWriter(errOutput), input.errorCause());
        }
        return input;
    }
}

