/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import org.apache.ignite.internal.sql.engine.message.QueryBatchMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class QueryBatchMessageDeserializer
implements MessageDeserializer<QueryBatchMessage> {
    private final QueryBatchMessageBuilder msg;

    QueryBatchMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryBatchMessage();
    }

    public Class<QueryBatchMessage> klass() {
        return QueryBatchMessage.class;
    }

    public QueryBatchMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.batchId(reader.readInt("batchId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.exchangeId(reader.readLong("exchangeId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.fragmentId(reader.readLong("fragmentId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.last(reader.readBoolean("last"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.msg.queryId(reader.readUuid("queryId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.msg.rowsByteArray(reader.readByteArray("rowsByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryBatchMessage.class);
    }
}

