/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.Objects;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public abstract class IgniteAbstractSqlAlterTable
extends SqlDdl {
    protected final SqlIdentifier name;
    protected final boolean ifExists;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("ALTER TABLE", SqlKind.ALTER_TABLE);

    public IgniteAbstractSqlAlterTable(SqlParserPos pos, boolean ifExists, SqlIdentifier tblName) {
        super(OPERATOR, pos);
        this.ifExists = ifExists;
        this.name = Objects.requireNonNull(tblName, "table name");
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        this.unparseAlterTableOperation(writer, leftPrec, rightPrec);
    }

    protected abstract void unparseAlterTableOperation(SqlWriter var1, int var2, int var3);

    public SqlIdentifier name() {
        return this.name;
    }

    public boolean ifExists() {
        return this.ifExists;
    }
}

